/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.AbstractExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeflateFrameExtension
extends AbstractExtension {
    private static final Logger LOG = Log.getLogger(DeflateFrameExtension.class);
    private int _minLength = 8;
    private Deflater _deflater;
    private Inflater _inflater;

    public DeflateFrameExtension() {
        super("x-deflate-frame");
    }

    @Override
    public boolean init(Map<String, String> parameters) {
        if (!parameters.containsKey("minLength")) {
            parameters.put("minLength", Integer.toString(this._minLength));
        }
        if (super.init(parameters)) {
            this._minLength = this.getInitParameter("minLength", this._minLength);
            this._deflater = new Deflater();
            this._inflater = new Inflater();
            return true;
        }
        return false;
    }

    @Override
    public void onFrame(byte flags, byte opcode, Buffer buffer) {
        int length;
        if (this.getConnection().isControl(opcode) || !this.isFlag(flags, 1)) {
            super.onFrame(flags, opcode, buffer);
            return;
        }
        if (buffer.array() == null) {
            buffer = buffer.asMutableBuffer();
        }
        if ((length = 0xFF & buffer.get()) >= 126) {
            int b = length == 127 ? 8 : 2;
            length = 0;
            while (b-- > 0) {
                length = 256 * length + (0xFF & buffer.get());
            }
        }
        this._inflater.setInput(buffer.array(), buffer.getIndex(), buffer.length());
        ByteArrayBuffer buf = new ByteArrayBuffer(length);
        try {
            while (this._inflater.getRemaining() > 0) {
                int inflated = this._inflater.inflate(buf.array(), buf.putIndex(), buf.space());
                if (inflated == 0) {
                    throw new DataFormatException("insufficient data");
                }
                buf.setPutIndex(buf.putIndex() + inflated);
            }
            super.onFrame(this.clearFlag(flags, 1), opcode, (Buffer)buf);
        }
        catch (DataFormatException e) {
            LOG.warn((Throwable)e);
            this.getConnection().close(1002, e.toString());
        }
    }

    @Override
    public void addFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
        if (this.getConnection().isControl(opcode) || length < this._minLength) {
            super.addFrame(this.clearFlag(flags, 1), opcode, content, offset, length);
            return;
        }
        this._deflater.reset();
        this._deflater.setInput(content, offset, length);
        this._deflater.finish();
        byte[] out = new byte[length];
        int out_offset = 0;
        if (length > 65535) {
            out[out_offset++] = 127;
            out[out_offset++] = (byte)(length >> 56 & 0x7F);
            out[out_offset++] = (byte)(length >> 48 & 0xFF);
            out[out_offset++] = (byte)(length >> 40 & 0xFF);
            out[out_offset++] = (byte)(length >> 32 & 0xFF);
            out[out_offset++] = (byte)(length >> 24 & 0xFF);
            out[out_offset++] = (byte)(length >> 16 & 0xFF);
            out[out_offset++] = (byte)(length >> 8 & 0xFF);
            out[out_offset++] = (byte)(length & 0xFF);
        } else if (length >= 126) {
            out[out_offset++] = 126;
            out[out_offset++] = (byte)(length >> 8);
            out[out_offset++] = (byte)(length & 0xFF);
        } else {
            out[out_offset++] = (byte)(length & 0x7F);
        }
        int l = this._deflater.deflate(out, out_offset, length - out_offset);
        if (this._deflater.finished()) {
            super.addFrame(this.setFlag(flags, 1), opcode, out, 0, l + out_offset);
        } else {
            super.addFrame(this.clearFlag(flags, 1), opcode, content, offset, length);
        }
    }
}

