/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnectionD00;
import org.eclipse.jetty.websocket.WebSocketConnectionD06;

public class WebSocketFactory {
    private final Acceptor _acceptor;
    private WebSocketBuffers _buffers;
    private int _maxIdleTime = 300000;

    public WebSocketFactory(Acceptor acceptor) {
        this(acceptor, 65536);
    }

    public WebSocketFactory(Acceptor acceptor, int bufferSize) {
        this._buffers = new WebSocketBuffers(bufferSize);
        this._acceptor = acceptor;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getBufferSize() {
        return this._buffers.getBufferSize();
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize != this.getBufferSize()) {
            this._buffers = new WebSocketBuffers(bufferSize);
        }
    }

    public void upgrade(HttpServletRequest request, HttpServletResponse response, WebSocket websocket, String origin, String protocol) throws IOException {
        AbstractConnection connection;
        if (!"websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            throw new IllegalStateException("!Upgrade:websocket");
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            throw new IllegalStateException("!HTTP/1.1");
        }
        int draft = request.getIntHeader("Sec-WebSocket-Version");
        if (draft < 0) {
            draft = request.getIntHeader("Sec-WebSocket-Draft");
        }
        HttpConnection http = HttpConnection.getCurrentConnection();
        ConnectedEndPoint endp = (ConnectedEndPoint)http.getEndPoint();
        switch (draft) {
            case 6: {
                connection = new WebSocketConnectionD06(websocket, (EndPoint)endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol, draft);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new HttpException(400, "Unsupported draft specification: " + draft);
            }
            default: {
                connection = new WebSocketConnectionD00(websocket, (EndPoint)endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol, draft);
            }
        }
        connection.handshake(request, response, origin, protocol);
        response.flushBuffer();
        connection.fillBuffersFrom(((HttpParser)http.getParser()).getHeaderBuffer());
        connection.fillBuffersFrom(((HttpParser)http.getParser()).getBodyBuffer());
        request.setAttribute("org.eclipse.jetty.io.Connection", (Object)connection);
    }

    public static String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()) == null || protocol.length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    public boolean acceptWebSocket(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            String protocol = request.getHeader("Sec-WebSocket-Protocol");
            if (protocol == null) {
                protocol = request.getHeader("WebSocket-Protocol");
            }
            WebSocket websocket = null;
            for (String p : WebSocketFactory.parseProtocols(protocol)) {
                websocket = this._acceptor.doWebSocketConnect(request, p);
                if (websocket == null) continue;
                protocol = p;
                break;
            }
            String host = request.getHeader("Host");
            String origin = request.getHeader("Origin");
            origin = this._acceptor.checkOrigin(request, host, origin);
            if (websocket != null) {
                this.upgrade(request, response, websocket, origin, protocol);
                return true;
            }
            response.sendError(503);
        }
        return false;
    }

    public static interface Acceptor {
        public WebSocket doWebSocketConnect(HttpServletRequest var1, String var2);

        public String checkOrigin(HttpServletRequest var1, String var2, String var3);
    }
}

