/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.websocket.WebSocketBuffers;

public class WebSocketGenerator {
    private final WebSocketBuffers _buffers;
    private final EndPoint _endp;
    private Buffer _buffer;

    public WebSocketGenerator(WebSocketBuffers buffers, EndPoint endp) {
        this._buffers = buffers;
        this._endp = endp;
    }

    public synchronized void addFrame(byte frame, byte[] content, int blockFor) throws IOException {
        this.addFrame(frame, content, 0, content.length, blockFor);
    }

    public synchronized void addFrame(byte frame, byte[] content, int offset, int length, int blockFor) throws IOException {
        if (this._buffer == null) {
            this._buffer = this._buffers.getDirectBuffer();
        }
        if (this._buffer.space() == 0) {
            this.expelBuffer(blockFor);
        }
        this.bufferPut(frame, blockFor);
        if (this.isLengthFrame(frame)) {
            int lengthBytes = new BigInteger(String.valueOf(length)).bitLength() / 7 + 1;
            for (int i = lengthBytes - 1; i > 0; --i) {
                byte lengthByte = (byte)(0x80 | 0x7F & length >> 7 * i);
                this.bufferPut(lengthByte, blockFor);
            }
            this.bufferPut((byte)(0x7F & length), blockFor);
        }
        int remaining = length;
        while (remaining > 0) {
            int chunk = remaining < this._buffer.space() ? remaining : this._buffer.space();
            this._buffer.put(content, offset + (length - remaining), chunk);
            remaining -= chunk;
            if (this._buffer.space() > 0) {
                if (!this.isLengthFrame(frame)) {
                    this._buffer.put((byte)-1);
                }
                this.flushBuffer();
                continue;
            }
            this.expelBuffer(blockFor);
            if (remaining != 0) continue;
            if (!this.isLengthFrame(frame)) {
                this._buffer.put((byte)-1);
            }
            this.flushBuffer();
        }
    }

    private synchronized boolean isLengthFrame(byte frame) {
        return (frame & 0xFFFFFF80) == -128;
    }

    private synchronized void bufferPut(byte datum, long blockFor) throws IOException {
        this._buffer.put(datum);
        if (this._buffer.space() == 0) {
            this.expelBuffer(blockFor);
        }
    }

    public synchronized void addFrame(byte frame, String content, int blockFor) throws IOException {
        byte[] bytes = content.getBytes("UTF-8");
        this.addFrame(frame, bytes, 0, bytes.length, blockFor);
    }

    public synchronized int flush(long blockFor) throws IOException {
        return this.expelBuffer(blockFor);
    }

    public synchronized int flush() throws IOException {
        int flushed = this.flushBuffer();
        if (this._buffer != null && this._buffer.length() == 0) {
            this._buffers.returnBuffer(this._buffer);
            this._buffer = null;
        }
        return flushed;
    }

    private synchronized int flushBuffer() throws IOException {
        if (!this._endp.isOpen()) {
            throw new IOException("Closed");
        }
        if (this._buffer != null) {
            return this._endp.flush(this._buffer);
        }
        return 0;
    }

    private synchronized int expelBuffer(long blockFor) throws IOException {
        int result = this.flushBuffer();
        this._buffer.compact();
        if (!this._endp.isBlocking()) {
            while (this._buffer.space() == 0) {
                boolean ready = this._endp.blockWritable(blockFor);
                if (!ready) {
                    throw new IOException("Write timeout");
                }
                result += this.flushBuffer();
                this._buffer.compact();
            }
        }
        return result;
    }

    public synchronized boolean isBufferEmpty() {
        return this._buffer == null || this._buffer.length() == 0;
    }

    public static byte[] doTheHixieHixieShake(long key1, long key2, byte[] key3) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] fodder = new byte[16];
            fodder[0] = (byte)(0xFFL & key1 >> 24);
            fodder[1] = (byte)(0xFFL & key1 >> 16);
            fodder[2] = (byte)(0xFFL & key1 >> 8);
            fodder[3] = (byte)(0xFFL & key1);
            fodder[4] = (byte)(0xFFL & key2 >> 24);
            fodder[5] = (byte)(0xFFL & key2 >> 16);
            fodder[6] = (byte)(0xFFL & key2 >> 8);
            fodder[7] = (byte)(0xFFL & key2);
            for (int i = 0; i < 8; ++i) {
                fodder[8 + i] = key3[i];
            }
            md.update(fodder);
            byte[] result = md.digest();
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

