/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;

public class WebSocketFactory {
    private WebSocketBuffers _buffers;
    private long _maxIdleTime = 300000L;

    public WebSocketFactory() {
        this._buffers = new WebSocketBuffers(8192);
    }

    public WebSocketFactory(int bufferSize) {
        this._buffers = new WebSocketBuffers(bufferSize);
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getBufferSize() {
        return this._buffers.getBufferSize();
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize != this.getBufferSize()) {
            this._buffers = new WebSocketBuffers(bufferSize);
        }
    }

    public void upgrade(HttpServletRequest request, HttpServletResponse response, WebSocket websocket, String origin, String protocol) throws IOException {
        if (!"WebSocket".equals(request.getHeader("Upgrade"))) {
            throw new IllegalStateException("!Upgrade:websocket");
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            throw new IllegalStateException("!HTTP/1.1");
        }
        HttpConnection http = HttpConnection.getCurrentConnection();
        ConnectedEndPoint endp = (ConnectedEndPoint)http.getEndPoint();
        WebSocketConnection connection = new WebSocketConnection(websocket, (EndPoint)endp, this._buffers, http.getTimeStamp(), this._maxIdleTime);
        String uri = request.getRequestURI();
        String host = request.getHeader("Host");
        response.setHeader("Upgrade", "WebSocket");
        response.addHeader("Connection", "Upgrade");
        response.addHeader("WebSocket-Origin", origin);
        response.addHeader("WebSocket-Location", "ws://" + host + uri);
        if (protocol != null) {
            response.addHeader("WebSocket-Protocol", protocol);
        }
        response.sendError(101, "Web Socket Protocol Handshake");
        response.flushBuffer();
        connection.fill(((HttpParser)http.getParser()).getHeaderBuffer());
        connection.fill(((HttpParser)http.getParser()).getBodyBuffer());
        websocket.onConnect(connection);
        request.setAttribute("org.eclipse.jetty.io.Connection", (Object)connection);
        response.flushBuffer();
    }
}

