/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

public class WebAppClassLoader
extends URLClassLoader {
    private static final Logger LOG;
    private static final ThreadLocal<Boolean> __loadServerClasses;
    private final Context _context;
    private final ClassLoader _parent;
    private final Set<String> _extensions = new HashSet<String>();
    private String _name = String.valueOf(this.hashCode());
    private final List<ClassFileTransformer> _transformers = new CopyOnWriteArrayList<ClassFileTransformer>();

    public static <T> T runWithServerClassAccess(PrivilegedExceptionAction<T> action) throws Exception {
        Boolean lsc = __loadServerClasses.get();
        try {
            __loadServerClasses.set(true);
            T t = action.run();
            return t;
        }
        finally {
            if (lsc == null) {
                __loadServerClasses.remove();
            } else {
                __loadServerClasses.set(lsc);
            }
        }
    }

    public WebAppClassLoader(Context context) throws IOException {
        this(null, context);
    }

    public WebAppClassLoader(ClassLoader parent, Context context) throws IOException {
        super(new URL[]{}, parent != null ? parent : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : (WebAppClassLoader.class.getClassLoader() != null ? WebAppClassLoader.class.getClassLoader() : ClassLoader.getSystemClassLoader())));
        this._parent = this.getParent();
        this._context = context;
        if (this._parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
        this._extensions.add(".jar");
        this._extensions.add(".zip");
        String extensions = System.getProperty(WebAppClassLoader.class.getName() + ".extensions");
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, ",;");
            while (tokenizer.hasMoreTokens()) {
                this._extensions.add(tokenizer.nextToken().trim());
            }
        }
        if (context.getExtraClasspath() != null) {
            this.addClassPath(context.getExtraClasspath());
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Context getContext() {
        return this._context;
    }

    public void addClassPath(Resource resource) throws IOException {
        if (resource instanceof ResourceCollection) {
            for (Resource r : ((ResourceCollection)resource).getResources()) {
                this.addClassPath(r);
            }
        } else {
            this.addClassPath(resource.toString());
        }
    }

    public void addClassPath(String classPath) throws IOException {
        if (classPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            Resource resource = this._context.newResource(tokenizer.nextToken().trim());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Path resource=" + resource, new Object[0]);
            }
            if (resource.isDirectory() && resource instanceof ResourceCollection) {
                this.addClassPath(resource);
                continue;
            }
            File file = resource.getFile();
            if (file != null) {
                URL url = resource.getURI().toURL();
                this.addURL(url);
                continue;
            }
            if (resource.isDirectory()) {
                this.addURL(resource.getURI().toURL());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check file exists and is not nested jar: " + resource, new Object[0]);
            }
            throw new IllegalArgumentException("File not resolvable or incompatible with URLClassloader: " + resource);
        }
    }

    private boolean isFileSupported(String file) {
        int dot = file.lastIndexOf(46);
        return dot != -1 && this._extensions.contains(file.substring(dot));
    }

    public void addJars(Resource lib) {
        if (lib.exists() && lib.isDirectory()) {
            String[] files = lib.list();
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    String fnlc;
                    Resource fn = lib.addPath(files[f]);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("addJar - {}", new Object[]{fn});
                    }
                    if (!this.isFileSupported(fnlc = fn.getName().toLowerCase(Locale.ENGLISH))) continue;
                    String jar = fn.toString();
                    jar = StringUtil.replace((String)jar, (String)",", (String)"%2C");
                    jar = StringUtil.replace((String)jar, (String)";", (String)"%3B");
                    this.addClassPath(jar);
                    continue;
                }
                catch (Exception ex) {
                    LOG.warn("EXCEPTION ", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this._context.getPermissions();
        PermissionCollection pc = permissions == null ? super.getPermissions(cs) : permissions;
        return pc;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        boolean system_class = this._context.isSystemClass(name);
        boolean server_class = this._context.isServerClass(name) && !Boolean.TRUE.equals(__loadServerClasses.get());
        List<URL> from_parent = this.toList(server_class ? null : this._parent.getResources(name));
        List<URL> from_webapp = this.toList((Enumeration<URL>)(system_class && !from_parent.isEmpty() ? null : this.findResources(name)));
        if (this._context.isParentLoaderPriority()) {
            from_parent.addAll(from_webapp);
            return Collections.enumeration(from_parent);
        }
        from_webapp.addAll(from_parent);
        return Collections.enumeration(from_webapp);
    }

    private List<URL> toList(Enumeration<URL> e) {
        if (e == null) {
            return new ArrayList<URL>();
        }
        return Collections.list(e);
    }

    @Override
    public URL getResource(String name) {
        boolean server_class;
        URL url = null;
        boolean tried_parent = false;
        String tmp = name;
        if (tmp != null && tmp.endsWith(".class")) {
            tmp = tmp.substring(0, tmp.length() - 6);
        }
        boolean system_class = this._context.isSystemClass(tmp);
        boolean bl = server_class = this._context.isServerClass(tmp) && !Boolean.TRUE.equals(__loadServerClasses.get());
        if (LOG.isDebugEnabled()) {
            LOG.debug("getResource({}) system={} server={} cl={}", new Object[]{name, system_class, server_class, this});
        }
        if (system_class && server_class) {
            return null;
        }
        ClassLoader source = null;
        if (this._parent != null && (this._context.isParentLoaderPriority() || system_class) && !server_class) {
            tried_parent = true;
            if (this._parent != null) {
                source = this._parent;
                url = this._parent.getResource(name);
            }
        }
        if (url == null) {
            url = this.findResource(name);
            source = this;
            if (url == null && name.startsWith("/")) {
                url = this.findResource(name.substring(1));
            }
        }
        if (url == null && !tried_parent && !server_class && this._parent != null) {
            tried_parent = true;
            source = this._parent;
            url = this._parent.getResource(name);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("gotResource({})=={} from={} tried_parent={}", new Object[]{name, url, source, tried_parent});
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            boolean server_class;
            Class<?> c = this.findLoadedClass(name);
            ClassNotFoundException ex = null;
            boolean tried_parent = false;
            boolean system_class = this._context.isSystemClass(name);
            boolean bl = server_class = this._context.isServerClass(name) && !Boolean.TRUE.equals(__loadServerClasses.get());
            if (LOG.isDebugEnabled()) {
                LOG.debug("loadClass({}) system={} server={} cl={}", new Object[]{name, system_class, server_class, this});
            }
            ClassLoader source = null;
            if (system_class && server_class) {
                return null;
            }
            if (c == null && this._parent != null && (this._context.isParentLoaderPriority() || system_class) && !server_class) {
                tried_parent = true;
                source = this._parent;
                try {
                    c = this._parent.loadClass(name);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("loaded " + c, new Object[0]);
                    }
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                }
            }
            if (c == null) {
                try {
                    source = this;
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                }
            }
            if (c == null && this._parent != null && !tried_parent && !server_class) {
                tried_parent = true;
                source = this._parent;
                c = this._parent.loadClass(name);
            }
            if (c == null && ex != null) {
                LOG.debug("!loadedClass({}) from={} tried_parent={}", new Object[]{name, this, tried_parent});
                throw ex;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("loadedClass({})=={} from={} tried_parent={}", new Object[]{name, c, source, tried_parent});
            }
            if (resolve) {
                this.resolveClass(c);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resolved({})=={} from={} tried_parent={}", new Object[]{name, c, source, tried_parent});
                }
            }
            return c;
        }
    }

    @Deprecated
    public void addClassFileTransformer(ClassFileTransformer transformer) {
        this._transformers.add(transformer);
    }

    @Deprecated
    public boolean removeClassFileTransformer(ClassFileTransformer transformer) {
        return this._transformers.remove(transformer);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this._transformers.add(transformer);
    }

    public boolean removeTransformer(ClassFileTransformer transformer) {
        return this._transformers.remove(transformer);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this._transformers.isEmpty()) {
            clazz = super.findClass(name);
        } else {
            String path = name.replace('.', '/').concat(".class");
            URL url = this.getResource(path);
            if (url == null) {
                throw new ClassNotFoundException(name);
            }
            InputStream content = null;
            try {
                content = url.openStream();
                byte[] bytes = IO.readBytes((InputStream)content);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("foundClass({}) url={} cl={}", new Object[]{name, url, this});
                }
                for (ClassFileTransformer transformer : this._transformers) {
                    byte[] tmp = transformer.transform(this, name, null, null, bytes);
                    if (tmp == null) continue;
                    bytes = tmp;
                }
                clazz = this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
            catch (IllegalClassFormatException e) {
                throw new ClassNotFoundException(name, e);
            }
            finally {
                if (content != null) {
                    try {
                        content.close();
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                }
            }
        }
        return clazz;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        return "WebAppClassLoader=" + this._name + "@" + Long.toHexString(this.hashCode());
    }

    static {
        WebAppClassLoader.registerAsParallelCapable();
        LOG = Log.getLogger(WebAppClassLoader.class);
        __loadServerClasses = new ThreadLocal();
    }

    public static interface Context {
        public Resource newResource(String var1) throws IOException;

        public PermissionCollection getPermissions();

        public boolean isSystemClass(String var1);

        public boolean isServerClass(String var1);

        public boolean isParentLoaderPriority();

        public String getExtraClasspath();
    }
}

