/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.unixsocket;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.unixsocket.UnixSocketEndPoint;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject(value="HTTP connector using NIO ByteChannels and Selectors")
public class UnixSocketConnector
extends AbstractConnector {
    private static final Logger LOG = Log.getLogger(UnixSocketConnector.class);
    private final SelectorManager _manager;
    private String _unixSocket = "/tmp/jetty.sock";
    private volatile UnixServerSocketChannel _acceptChannel;
    private volatile int _acceptQueueSize = 0;
    private volatile boolean _reuseAddress = true;

    public UnixSocketConnector(@Name(value="server") Server server) {
        this(server, null, null, null, -1, new ConnectionFactory[]{new HttpConnectionFactory()});
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="selectors") int selectors) {
        this(server, null, null, null, selectors, new ConnectionFactory[]{new HttpConnectionFactory()});
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="selectors") int selectors, ConnectionFactory ... factories) {
        this(server, null, null, null, selectors, factories);
    }

    public UnixSocketConnector(@Name(value="server") Server server, ConnectionFactory ... factories) {
        this(server, null, null, null, -1, factories);
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory sslContextFactory) {
        this(server, null, null, null, -1, AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{new HttpConnectionFactory()}));
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="selectors") int selectors, @Name(value="sslContextFactory") SslContextFactory sslContextFactory) {
        this(server, null, null, null, selectors, AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{new HttpConnectionFactory()}));
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory sslContextFactory, ConnectionFactory ... factories) {
        this(server, null, null, null, -1, AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])factories));
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="executor") Executor executor, @Name(value="scheduler") Scheduler scheduler, @Name(value="bufferPool") ByteBufferPool bufferPool, @Name(value="selectors") int selectors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, 0, factories);
        this._manager = this.newSelectorManager(this.getExecutor(), this.getScheduler(), selectors > 0 ? selectors : 1);
        this.addBean(this._manager, true);
        this.setAcceptorPriorityDelta(-2);
    }

    @ManagedAttribute
    public String getUnixSocket() {
        return this._unixSocket;
    }

    public void setUnixSocket(String filename) {
        this._unixSocket = filename;
    }

    protected SelectorManager newSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        return new UnixSocketConnectorManager(executor, scheduler, selectors);
    }

    protected void doStart() throws Exception {
        this.open();
        super.doStart();
        if (this.getAcceptors() == 0) {
            this._manager.acceptor((SelectableChannel)this._acceptChannel);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.close();
    }

    public boolean isOpen() {
        UnixServerSocketChannel channel = this._acceptChannel;
        return channel != null && channel.isOpen();
    }

    public void open() throws IOException {
        if (this._acceptChannel == null) {
            File file = new File(this._unixSocket);
            file.deleteOnExit();
            UnixSocketAddress bindAddress = new UnixSocketAddress(file);
            UnixServerSocketChannel serverChannel = UnixServerSocketChannel.open();
            serverChannel.configureBlocking(this.getAcceptors() > 0);
            serverChannel.socket().bind((SocketAddress)bindAddress, this.getAcceptQueueSize());
            this.addBean(serverChannel);
            LOG.debug("opened {}", new Object[]{serverChannel});
            this._acceptChannel = serverChannel;
        }
    }

    public Future<Void> shutdown() {
        return super.shutdown();
    }

    public void close() {
        UnixServerSocketChannel serverChannel = this._acceptChannel;
        this._acceptChannel = null;
        if (serverChannel != null) {
            this.removeBean(serverChannel);
            if (serverChannel.isOpen()) {
                try {
                    serverChannel.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            new File(this._unixSocket).delete();
        }
    }

    public void accept(int acceptorID) throws IOException {
        LOG.debug("Blocking UnixSocket accept used.  Might not be able to be interrupted!", new Object[0]);
        UnixServerSocketChannel serverChannel = this._acceptChannel;
        if (serverChannel != null && serverChannel.isOpen()) {
            LOG.debug("accept {}", new Object[]{serverChannel});
            UnixSocketChannel channel = serverChannel.accept();
            LOG.debug("accepted {}", new Object[]{channel});
            this.accepted(channel);
        }
    }

    protected void accepted(UnixSocketChannel channel) throws IOException {
        channel.configureBlocking(false);
        this._manager.accept((SelectableChannel)channel);
    }

    public SelectorManager getSelectorManager() {
        return this._manager;
    }

    public Object getTransport() {
        return this._acceptChannel;
    }

    protected UnixSocketEndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey key) throws IOException {
        return new UnixSocketEndPoint((UnixSocketChannel)channel, selector, key, this.getScheduler());
    }

    @ManagedAttribute(value="Accept Queue size")
    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this._acceptQueueSize = acceptQueueSize;
    }

    public boolean getReuseAddress() {
        return this._reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this._reuseAddress = reuseAddress;
    }

    public String toString() {
        return String.format("%s{%s}", super.toString(), this._unixSocket);
    }

    protected class UnixSocketConnectorManager
    extends SelectorManager {
        public UnixSocketConnectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        protected void accepted(SelectableChannel channel) throws IOException {
            UnixSocketConnector.this.accepted((UnixSocketChannel)channel);
        }

        protected Selector newSelector() throws IOException {
            return NativeSelectorProvider.getInstance().openSelector();
        }

        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) throws IOException {
            UnixSocketEndPoint endp = UnixSocketConnector.this.newEndPoint(channel, selector, selectionKey);
            endp.setIdleTimeout(UnixSocketConnector.this.getIdleTimeout());
            return endp;
        }

        public Connection newConnection(SelectableChannel channel, EndPoint endpoint, Object attachment) throws IOException {
            return UnixSocketConnector.this.getDefaultConnectionFactory().newConnection((Connector)UnixSocketConnector.this, endpoint);
        }

        protected void endPointOpened(EndPoint endpoint) {
            super.endPointOpened(endpoint);
            UnixSocketConnector.this.onEndPointOpened(endpoint);
        }

        protected void endPointClosed(EndPoint endpoint) {
            UnixSocketConnector.this.onEndPointClosed(endpoint);
            super.endPointClosed(endpoint);
        }

        protected boolean doFinishConnect(SelectableChannel channel) throws IOException {
            return ((UnixSocketChannel)channel).finishConnect();
        }

        protected boolean isConnectionPending(SelectableChannel channel) {
            return ((UnixSocketChannel)channel).isConnectionPending();
        }

        protected SelectableChannel doAccept(SelectableChannel server) throws IOException {
            LOG.debug("doAccept async {}", new Object[]{server});
            UnixSocketChannel channel = ((UnixServerSocketChannel)server).accept();
            LOG.debug("accepted async {}", new Object[]{channel});
            return channel;
        }
    }
}

