/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.unixsocket.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Map;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.unixsocket.UnixSocketEndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpClientTransportOverUnixSockets
extends HttpClientTransportOverHTTP {
    private static final Logger LOG = Log.getLogger(HttpClientTransportOverUnixSockets.class);
    private String _unixSocket;

    public HttpClientTransportOverUnixSockets(String unixSocket) {
        if (unixSocket == null) {
            throw new IllegalArgumentException("Unix socket file cannot be null");
        }
        this._unixSocket = unixSocket;
    }

    protected SelectorManager newSelectorManager(HttpClient client) {
        return new UnixSocketSelectorManager(client, this.getSelectors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(InetSocketAddress address, Map<String, Object> context) {
        UnixSocketChannel channel = null;
        try {
            InetAddress inet = address.getAddress();
            if (!(inet.isLoopbackAddress() || inet.isLinkLocalAddress() || inet.isSiteLocalAddress())) {
                throw new ConnectException("UnixSocket cannot connect to " + address.getHostString());
            }
            UnixSocketAddress unixAddress = new UnixSocketAddress(this._unixSocket);
            channel = UnixSocketChannel.open((UnixSocketAddress)unixAddress);
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            HttpClient client = destination.getHttpClient();
            this.configure(client, (SocketChannel)channel);
            channel.configureBlocking(false);
            this.getSelectorManager().accept((SelectableChannel)channel, context);
        }
        catch (Throwable x) {
            if (x.getClass() == SocketException.class) {
                x = new SocketException("Could not connect to " + address).initCause(x);
            }
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException ex) {
                LOG.ignore((Throwable)ex);
            }
            finally {
                this.connectFailed(context, x);
            }
        }
    }

    public class UnixSocketSelectorManager
    extends AbstractConnectorHttpClientTransport.ClientSelectorManager {
        protected UnixSocketSelectorManager(HttpClient client, int selectors) {
            super((AbstractConnectorHttpClientTransport)HttpClientTransportOverUnixSockets.this, client, selectors);
        }

        protected Selector newSelector() throws IOException {
            return NativeSelectorProvider.getInstance().openSelector();
        }

        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey key) {
            UnixSocketEndPoint endp = new UnixSocketEndPoint((UnixSocketChannel)channel, selector, key, this.getScheduler());
            endp.setIdleTimeout(HttpClientTransportOverUnixSockets.this.getHttpClient().getIdleTimeout());
            return endp;
        }
    }
}

