/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.util.Collection;

public final class Utils {
    public static String join(Object[] arr, String delim) {
        if (arr == null) {
            return "";
        }
        return Utils.join(arr, 0, arr.length, delim);
    }

    public static String join(Object[] arr, int start, int end, String delim) {
        if (arr == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (i > start) {
                str.append(delim);
            }
            str.append(arr[i]);
        }
        return str.toString();
    }

    public static String join(Collection<?> objs, String delim) {
        if (objs == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        boolean needDelim = false;
        for (Object obj : objs) {
            if (needDelim) {
                str.append(delim);
            }
            str.append(obj);
            needDelim = true;
        }
        return str.toString();
    }

    public static boolean isBlank(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            int c = value.codePointAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String value) {
        if (value == null) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            int c = value.codePointAt(i);
            if (Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }
}

