/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets.gzip;

import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.servlets.gzip.GzipFactory;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class GzipHttpOutput
extends HttpOutput {
    public static Logger LOG = Log.getLogger(GzipHttpOutput.class);
    private static final PreEncodedHttpField CONTENT_ENCODING_GZIP = new PreEncodedHttpField(HttpHeader.CONTENT_ENCODING, "gzip");
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private final AtomicReference<GZState> _state = new AtomicReference<GZState>(GZState.NOT_COMPRESSING);
    private final CRC32 _crc = new CRC32();
    private Deflater _deflater;
    private GzipFactory _factory;
    private ByteBuffer _buffer;

    public GzipHttpOutput(HttpChannel channel) {
        super(channel);
    }

    public void reset() {
        this._state.set(GZState.NOT_COMPRESSING);
        super.reset();
    }

    protected void write(ByteBuffer content, boolean complete, Callback callback) {
        switch (this._state.get()) {
            case NOT_COMPRESSING: {
                this.superWrite(content, complete, callback);
                return;
            }
            case MIGHT_COMPRESS: {
                this.commit(content, complete, callback);
                break;
            }
            case COMMITTING: {
                callback.failed((Throwable)new WritePendingException());
                break;
            }
            case COMPRESSING: {
                this.gzip(content, complete, callback);
                break;
            }
            default: {
                callback.failed((Throwable)new IllegalStateException("state=" + (Object)((Object)this._state.get())));
            }
        }
    }

    private void superWrite(ByteBuffer content, boolean complete, Callback callback) {
        super.write(content, complete, callback);
    }

    private void addTrailer() {
        int i = this._buffer.limit();
        this._buffer.limit(i + 8);
        int v = (int)this._crc.getValue();
        this._buffer.put(i++, (byte)(v & 0xFF));
        this._buffer.put(i++, (byte)(v >>> 8 & 0xFF));
        this._buffer.put(i++, (byte)(v >>> 16 & 0xFF));
        this._buffer.put(i++, (byte)(v >>> 24 & 0xFF));
        v = this._deflater.getTotalIn();
        this._buffer.put(i++, (byte)(v & 0xFF));
        this._buffer.put(i++, (byte)(v >>> 8 & 0xFF));
        this._buffer.put(i++, (byte)(v >>> 16 & 0xFF));
        this._buffer.put(i++, (byte)(v >>> 24 & 0xFF));
    }

    private void gzip(ByteBuffer content, boolean complete, Callback callback) {
        if (content.hasRemaining() || complete) {
            if (content.hasArray()) {
                new GzipArrayCB(content, complete, callback).iterate();
            } else {
                new GzipBufferCB(content, complete, callback).iterate();
            }
        } else {
            callback.succeeded();
        }
    }

    protected void commit(ByteBuffer content, boolean complete, Callback callback) {
        Response response = this.getHttpChannel().getResponse();
        int sc = response.getStatus();
        if (sc > 0 && (sc < 200 || sc == 204 || sc == 205 || sc >= 300)) {
            LOG.debug("{} exclude by status {}", new Object[]{this, sc});
            this.noCompression();
            this.superWrite(content, complete, callback);
            return;
        }
        String ct = this.getHttpChannel().getResponse().getContentType();
        if (ct != null && this._factory.isExcludedMimeType(StringUtil.asciiToLowerCase((String)(ct = MimeTypes.getContentTypeWithoutCharset((String)ct))))) {
            LOG.debug("{} exclude by mimeType {}", new Object[]{this, ct});
            this.noCompression();
            this.superWrite(content, complete, callback);
            return;
        }
        String ce = this.getHttpChannel().getResponse().getHeader("Content-Encoding");
        if (ce != null) {
            LOG.debug("{} exclude by content-encoding {}", new Object[]{this, ce});
            this.noCompression();
            this.superWrite(content, complete, callback);
            return;
        }
        if (this._state.compareAndSet(GZState.MIGHT_COMPRESS, GZState.COMMITTING)) {
            HttpFields fields = response.getHttpFields();
            fields.add(this._factory.getVaryField());
            long content_length = response.getContentLength();
            if (content_length < 0L && complete) {
                content_length = content.remaining();
            }
            this._deflater = this._factory.getDeflater(this.getHttpChannel().getRequest(), content_length);
            if (this._deflater == null) {
                LOG.debug("{} exclude no deflater", new Object[]{this});
                this._state.set(GZState.NOT_COMPRESSING);
                this.superWrite(content, complete, callback);
                return;
            }
            fields.put((HttpField)CONTENT_ENCODING_GZIP);
            this._crc.reset();
            this._buffer = this.getHttpChannel().getByteBufferPool().acquire(this._factory.getBufferSize(), false);
            BufferUtil.fill((ByteBuffer)this._buffer, (byte[])GZIP_HEADER, (int)0, (int)GZIP_HEADER.length);
            response.setContentLength(-1);
            String etag = fields.get(HttpHeader.ETAG);
            if (etag != null) {
                fields.put(HttpHeader.ETAG, etag.substring(0, etag.length() - 1) + "--gzip" + '\"');
            }
            LOG.debug("{} compressing {}", new Object[]{this, this._deflater});
            this._state.set(GZState.COMPRESSING);
            this.gzip(content, complete, callback);
        } else {
            callback.failed((Throwable)new WritePendingException());
        }
    }

    public void noCompression() {
        block4: while (true) {
            switch (this._state.get()) {
                case NOT_COMPRESSING: {
                    return;
                }
                case MIGHT_COMPRESS: {
                    if (!this._state.compareAndSet(GZState.MIGHT_COMPRESS, GZState.NOT_COMPRESSING)) continue block4;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(this._state.get().toString());
    }

    public void noCompressionIfPossible() {
        block4: while (true) {
            switch (this._state.get()) {
                case NOT_COMPRESSING: 
                case COMPRESSING: {
                    return;
                }
                case MIGHT_COMPRESS: {
                    if (!this._state.compareAndSet(GZState.MIGHT_COMPRESS, GZState.NOT_COMPRESSING)) continue block4;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(this._state.get().toString());
    }

    public void mightCompress(GzipFactory factory) {
        block3: while (true) {
            switch (this._state.get()) {
                case NOT_COMPRESSING: {
                    this._factory = factory;
                    if (this._state.compareAndSet(GZState.NOT_COMPRESSING, GZState.MIGHT_COMPRESS)) {
                        LOG.debug("{} might compress", new Object[]{this});
                        return;
                    }
                    this._factory = null;
                    continue block3;
                }
            }
            break;
        }
        throw new IllegalStateException(this._state.get().toString());
    }

    private class GzipBufferCB
    extends IteratingNestedCallback {
        private final ByteBuffer _input;
        private final ByteBuffer _content;
        private final boolean _last;

        public GzipBufferCB(ByteBuffer content, boolean complete, Callback callback) {
            super(callback);
            this._input = GzipHttpOutput.this.getHttpChannel().getByteBufferPool().acquire(Math.min(GzipHttpOutput.this._factory.getBufferSize(), content.remaining()), false);
            this._content = content;
            this._last = complete;
        }

        protected IteratingCallback.Action process() throws Exception {
            if (GzipHttpOutput.this._deflater.needsInput()) {
                if (BufferUtil.isEmpty((ByteBuffer)this._content)) {
                    if (GzipHttpOutput.this._deflater.finished()) {
                        GzipHttpOutput.this._factory.recycle(GzipHttpOutput.this._deflater);
                        GzipHttpOutput.this._deflater = null;
                        GzipHttpOutput.this.getHttpChannel().getByteBufferPool().release(GzipHttpOutput.this._buffer);
                        GzipHttpOutput.this._buffer = null;
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    if (!this._last) {
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    GzipHttpOutput.this._deflater.finish();
                } else {
                    BufferUtil.clearToFill((ByteBuffer)this._input);
                    int took = BufferUtil.put((ByteBuffer)this._content, (ByteBuffer)this._input);
                    BufferUtil.flipToFlush((ByteBuffer)this._input, (int)0);
                    if (took == 0) {
                        throw new IllegalStateException();
                    }
                    byte[] array = this._input.array();
                    int off = this._input.arrayOffset() + this._input.position();
                    int len = this._input.remaining();
                    GzipHttpOutput.this._crc.update(array, off, len);
                    GzipHttpOutput.this._deflater.setInput(array, off, len);
                    if (this._last && BufferUtil.isEmpty((ByteBuffer)this._content)) {
                        GzipHttpOutput.this._deflater.finish();
                    }
                }
            }
            BufferUtil.compact((ByteBuffer)GzipHttpOutput.this._buffer);
            int off = GzipHttpOutput.this._buffer.arrayOffset() + GzipHttpOutput.this._buffer.limit();
            int len = GzipHttpOutput.this._buffer.capacity() - GzipHttpOutput.this._buffer.limit() - (this._last ? 8 : 0);
            int produced = GzipHttpOutput.this._deflater.deflate(GzipHttpOutput.this._buffer.array(), off, len, 0);
            GzipHttpOutput.this._buffer.limit(GzipHttpOutput.this._buffer.limit() + produced);
            boolean finished = GzipHttpOutput.this._deflater.finished();
            if (finished) {
                GzipHttpOutput.this.addTrailer();
            }
            GzipHttpOutput.this.superWrite(GzipHttpOutput.this._buffer, finished, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }
    }

    private class GzipArrayCB
    extends IteratingNestedCallback {
        private final boolean _complete;

        public GzipArrayCB(ByteBuffer content, boolean complete, Callback callback) {
            super(callback);
            this._complete = complete;
            byte[] array = content.array();
            int off = content.arrayOffset() + content.position();
            int len = content.remaining();
            GzipHttpOutput.this._crc.update(array, off, len);
            GzipHttpOutput.this._deflater.setInput(array, off, len);
            if (complete) {
                GzipHttpOutput.this._deflater.finish();
            }
            content.position(content.limit());
        }

        protected IteratingCallback.Action process() throws Exception {
            if (GzipHttpOutput.this._deflater.needsInput()) {
                if (GzipHttpOutput.this._deflater.finished()) {
                    GzipHttpOutput.this._factory.recycle(GzipHttpOutput.this._deflater);
                    GzipHttpOutput.this._deflater = null;
                    GzipHttpOutput.this.getHttpChannel().getByteBufferPool().release(GzipHttpOutput.this._buffer);
                    GzipHttpOutput.this._buffer = null;
                    return IteratingCallback.Action.SUCCEEDED;
                }
                if (!this._complete) {
                    return IteratingCallback.Action.SUCCEEDED;
                }
                GzipHttpOutput.this._deflater.finish();
            }
            BufferUtil.compact((ByteBuffer)GzipHttpOutput.this._buffer);
            int off = GzipHttpOutput.this._buffer.arrayOffset() + GzipHttpOutput.this._buffer.limit();
            int len = GzipHttpOutput.this._buffer.capacity() - GzipHttpOutput.this._buffer.limit() - (this._complete ? 8 : 0);
            int produced = GzipHttpOutput.this._deflater.deflate(GzipHttpOutput.this._buffer.array(), off, len, 0);
            GzipHttpOutput.this._buffer.limit(GzipHttpOutput.this._buffer.limit() + produced);
            boolean complete = GzipHttpOutput.this._deflater.finished();
            if (complete) {
                GzipHttpOutput.this.addTrailer();
            }
            GzipHttpOutput.this.superWrite(GzipHttpOutput.this._buffer, complete, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }
    }

    private static enum GZState {
        NOT_COMPRESSING,
        MIGHT_COMPRESS,
        COMMITTING,
        COMPRESSING,
        FINISHED;

    }
}

