/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.http.gzip.GzipResponseWrapper;
import org.eclipse.jetty.servlets.UserAgentFilter;
import org.eclipse.jetty.util.log.Log;

public class GzipFilter
extends UserAgentFilter {
    protected Set<String> _mimeTypes;
    protected int _bufferSize = 8192;
    protected int _minGzipSize = 256;
    protected Set<String> _excluded;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        StringTokenizer tok;
        super.init(filterConfig);
        String tmp = filterConfig.getInitParameter("bufferSize");
        if (tmp != null) {
            this._bufferSize = Integer.parseInt(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("minGzipSize")) != null) {
            this._minGzipSize = Integer.parseInt(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("mimeTypes")) != null) {
            this._mimeTypes = new HashSet<String>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._mimeTypes.add(tok.nextToken());
            }
        }
        if ((tmp = filterConfig.getInitParameter("excludedAgents")) != null) {
            this._excluded = new HashSet<String>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excluded.add(tok.nextToken());
            }
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block12: {
            HttpServletResponse response;
            HttpServletRequest request;
            block11: {
                String ua;
                request = (HttpServletRequest)req;
                response = (HttpServletResponse)res;
                String ae = request.getHeader("accept-encoding");
                if (ae == null || ae.indexOf("gzip") < 0 || response.containsHeader("Content-Encoding") || "HEAD".equalsIgnoreCase(request.getMethod())) break block11;
                if (this._excluded != null && this._excluded.contains(ua = this.getUserAgent((ServletRequest)request))) {
                    super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
                    return;
                }
                GzipResponseWrapper wrappedResponse = this.newGzipResponseWrapper(request, response);
                boolean exceptional = true;
                try {
                    super.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse, chain);
                    exceptional = false;
                }
                catch (Throwable throwable) {
                    Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                    if (continuation.isSuspended() && continuation.isResponseWrapped()) {
                        continuation.addContinuationListener(new ContinuationListener(wrappedResponse){
                            final /* synthetic */ GzipResponseWrapper val$wrappedResponse;
                            {
                                this.val$wrappedResponse = gzipResponseWrapper;
                            }

                            public void onComplete(Continuation continuation) {
                                try {
                                    this.val$wrappedResponse.finish();
                                }
                                catch (IOException e) {
                                    Log.warn((Throwable)e);
                                }
                            }

                            public void onTimeout(Continuation continuation) {
                            }
                        });
                    } else if (exceptional && !response.isCommitted()) {
                        wrappedResponse.resetBuffer();
                        wrappedResponse.noGzip();
                    } else {
                        wrappedResponse.finish();
                    }
                    throw throwable;
                }
                Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                if (continuation.isSuspended() && continuation.isResponseWrapped()) {
                    continuation.addContinuationListener(new /* invalid duplicate definition of identical inner class */);
                } else if (exceptional && !response.isCommitted()) {
                    wrappedResponse.resetBuffer();
                    wrappedResponse.noGzip();
                } else {
                    wrappedResponse.finish();
                }
                break block12;
            }
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
    }

    protected GzipResponseWrapper newGzipResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        return new GzipResponseWrapper(request, response){
            {
                this.setMimeTypes(GzipFilter.this._mimeTypes);
                this.setBufferSize(GzipFilter.this._bufferSize);
                this.setMinGzipSize(GzipFilter.this._minGzipSize);
            }

            protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
                return GzipFilter.this.newWriter(out, encoding);
            }
        };
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new PrintWriter(out) : new PrintWriter(new OutputStreamWriter(out, encoding));
    }
}

