/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.log.Log;

public class CrossOriginFilter
implements Filter {
    private static final String ORIGIN_HEADER = "Origin";
    private static final String ACCESS_CONTROL_REQUEST_METHOD_HEADER = "Access-Control-Request-Method";
    private static final String ACCESS_CONTROL_REQUEST_HEADERS_HEADER = "Access-Control-Request-Headers";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_MAX_AGE_HEADER = "Access-Control-Max-Age";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    private static final String ALLOWED_ORIGINS_PARAM = "allowedOrigins";
    private static final String ALLOWED_METHODS_PARAM = "allowedMethods";
    private static final String ALLOWED_HEADERS_PARAM = "allowedHeaders";
    private static final String PREFLIGHT_MAX_AGE_PARAM = "preflightMaxAge";
    private static final String ALLOWED_CREDENTIALS_PARAM = "allowCredentials";
    private static final String ANY_ORIGIN = "*";
    private static final List<String> SIMPLE_HTTP_METHODS = Arrays.asList("GET", "POST", "HEAD");
    private boolean anyOriginAllowed = false;
    private List<String> allowedOrigins = new ArrayList<String>();
    private List<String> allowedMethods = new ArrayList<String>();
    private List<String> allowedHeaders = new ArrayList<String>();
    private int preflightMaxAge = 0;
    private boolean allowCredentials = false;

    public void init(FilterConfig config) throws ServletException {
        String allowedMethodsConfig;
        String[] allowedOrigins;
        String allowedOriginsConfig = config.getInitParameter(ALLOWED_ORIGINS_PARAM);
        if (allowedOriginsConfig == null) {
            allowedOriginsConfig = ANY_ORIGIN;
        }
        for (String allowedOrigin : allowedOrigins = allowedOriginsConfig.split(",")) {
            if ((allowedOrigin = allowedOrigin.trim()).length() <= 0) continue;
            if (ANY_ORIGIN.equals(allowedOrigin)) {
                this.anyOriginAllowed = true;
                this.allowedOrigins.clear();
                break;
            }
            this.allowedOrigins.add(allowedOrigin);
        }
        if ((allowedMethodsConfig = config.getInitParameter(ALLOWED_METHODS_PARAM)) == null) {
            allowedMethodsConfig = "GET,POST";
        }
        this.allowedMethods.addAll(Arrays.asList(allowedMethodsConfig.split(",")));
        String allowedHeadersConfig = config.getInitParameter(ALLOWED_HEADERS_PARAM);
        if (allowedHeadersConfig == null) {
            allowedHeadersConfig = "X-Requested-With,Content-Type,Accept";
        }
        this.allowedHeaders.addAll(Arrays.asList(allowedHeadersConfig.split(",")));
        String preflightMaxAgeConfig = config.getInitParameter(PREFLIGHT_MAX_AGE_PARAM);
        if (preflightMaxAgeConfig == null) {
            preflightMaxAgeConfig = "1800";
        }
        try {
            this.preflightMaxAge = Integer.parseInt(preflightMaxAgeConfig);
        }
        catch (NumberFormatException x) {
            Log.info((String)"Cross-origin filter, could not parse '{}' parameter as integer: {}", (Object)PREFLIGHT_MAX_AGE_PARAM, (Object)preflightMaxAgeConfig);
        }
        String allowedCredentialsConfig = config.getInitParameter(ALLOWED_CREDENTIALS_PARAM);
        if (allowedCredentialsConfig == null) {
            allowedCredentialsConfig = "false";
        }
        this.allowCredentials = Boolean.parseBoolean(allowedCredentialsConfig);
        Log.debug((String)("Cross-origin filter configuration: allowedOrigins = " + allowedOriginsConfig + ", " + ALLOWED_METHODS_PARAM + " = " + allowedMethodsConfig + ", " + ALLOWED_HEADERS_PARAM + " = " + allowedHeadersConfig + ", " + PREFLIGHT_MAX_AGE_PARAM + " = " + preflightMaxAgeConfig + ", " + ALLOWED_CREDENTIALS_PARAM + " = " + allowedCredentialsConfig));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.handle((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String origin = request.getHeader(ORIGIN_HEADER);
        if (origin != null && this.isEnabled(request)) {
            if (this.originMatches(origin)) {
                if (this.isSimpleRequest(request)) {
                    Log.debug((String)"Cross-origin request to {} is a simple cross-origin request", (Object)request.getRequestURI());
                    this.handleSimpleResponse(request, response, origin);
                } else {
                    Log.debug((String)"Cross-origin request to {} is a preflight cross-origin request", (Object)request.getRequestURI());
                    this.handlePreflightResponse(request, response, origin);
                }
            } else {
                Log.debug((String)("Cross-origin request to " + request.getRequestURI() + " with origin " + origin + " does not match allowed origins " + this.allowedOrigins));
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean isEnabled(HttpServletRequest request) {
        return !"Upgrade".equalsIgnoreCase(request.getHeader("Connection")) || !"WebSocket".equalsIgnoreCase(request.getHeader("Upgrade"));
    }

    private boolean originMatches(String origin) {
        if (this.anyOriginAllowed) {
            return true;
        }
        for (String allowedOrigin : this.allowedOrigins) {
            if (!allowedOrigin.equals(origin)) continue;
            return true;
        }
        return false;
    }

    private boolean isSimpleRequest(HttpServletRequest request) {
        String method = request.getMethod();
        if (SIMPLE_HTTP_METHODS.contains(method)) {
            return request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER) == null;
        }
        return false;
    }

    private void handleSimpleResponse(HttpServletRequest request, HttpServletResponse response, String origin) {
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, origin);
        if (this.allowCredentials) {
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, "true");
        }
    }

    private void handlePreflightResponse(HttpServletRequest request, HttpServletResponse response, String origin) {
        boolean methodAllowed = this.isMethodAllowed(request);
        if (!methodAllowed) {
            return;
        }
        boolean headersAllowed = this.areHeadersAllowed(request);
        if (!headersAllowed) {
            return;
        }
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, origin);
        if (this.allowCredentials) {
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, "true");
        }
        if (this.preflightMaxAge > 0) {
            response.setHeader(ACCESS_CONTROL_MAX_AGE_HEADER, String.valueOf(this.preflightMaxAge));
        }
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS_HEADER, this.commify(this.allowedMethods));
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS_HEADER, this.commify(this.allowedHeaders));
    }

    private boolean isMethodAllowed(HttpServletRequest request) {
        String accessControlRequestMethod = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER);
        Log.debug((String)"{} is {}", (Object)ACCESS_CONTROL_REQUEST_METHOD_HEADER, (Object)accessControlRequestMethod);
        boolean result = false;
        if (accessControlRequestMethod != null) {
            result = this.allowedMethods.contains(accessControlRequestMethod);
        }
        Log.debug((String)("Method {} is" + (result ? "" : " not") + " among allowed methods {}"), (Object)accessControlRequestMethod, this.allowedMethods);
        return result;
    }

    private boolean areHeadersAllowed(HttpServletRequest request) {
        String accessControlRequestHeaders = request.getHeader(ACCESS_CONTROL_REQUEST_HEADERS_HEADER);
        Log.debug((String)"{} is {}", (Object)ACCESS_CONTROL_REQUEST_HEADERS_HEADER, (Object)accessControlRequestHeaders);
        boolean result = true;
        if (accessControlRequestHeaders != null) {
            String[] headers;
            for (String header : headers = accessControlRequestHeaders.split(",")) {
                boolean headerAllowed = false;
                for (String allowedHeader : this.allowedHeaders) {
                    if (!header.trim().equalsIgnoreCase(allowedHeader.trim())) continue;
                    headerAllowed = true;
                    break;
                }
                if (headerAllowed) continue;
                result = false;
                break;
            }
        }
        Log.debug((String)("Headers [{}] are" + (result ? "" : " not") + " among allowed headers {}"), (Object)accessControlRequestHeaders, this.allowedHeaders);
        return result;
    }

    private String commify(List<String> strings) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            String string = strings.get(i);
            builder.append(string);
        }
        return builder.toString();
    }

    public void destroy() {
        this.anyOriginAllowed = false;
        this.allowedOrigins.clear();
        this.allowedMethods.clear();
        this.allowedHeaders.clear();
        this.preflightMaxAge = 0;
        this.allowCredentials = false;
    }
}

