/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SSLSelectChannelConnectorLoadTest {
    private static Server server;
    private static ServerConnector connector;
    private static SSLContext sslContext;

    @BeforeClass
    public static void startServer() throws Exception {
        String keystorePath = System.getProperty("basedir", ".") + "/src/test/resources/keystore";
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(keystorePath);
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setKeyManagerPassword("keypwd");
        sslContextFactory.setTrustStorePath(keystorePath);
        sslContextFactory.setTrustStorePassword("storepwd");
        server = new Server();
        connector = new ServerConnector(server, sslContextFactory);
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new EmptyHandler());
        server.start();
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream stream = new FileInputStream(keystorePath);){
            keystore.load(stream, "storepwd".toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
    }

    @AfterClass
    public static void stopServer() throws Exception {
        server.stop();
        server.join();
    }

    @Test
    public void testLongLivedConnections() throws Exception {
        boolean done;
        Worker.totalIterations.set(0L);
        int mebiByte = 1048510;
        int clients = 1;
        int iterations = 2;
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(clients, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        threadPool.prestartAllCoreThreads();
        Worker[] workers = new Worker[clients];
        Future[] tasks = new Future[clients];
        for (int i = 0; i < clients; ++i) {
            workers[i] = new Worker(sslContext, iterations, false, mebiByte, 64 * mebiByte);
            workers[i].open();
            tasks[i] = threadPool.submit(workers[i]);
        }
        long start = System.currentTimeMillis();
        do {
            Thread.sleep(1000L);
            done = true;
            for (Future task : tasks) {
                done &= task.isDone();
            }
        } while (!done);
        long end = System.currentTimeMillis();
        for (Worker worker : workers) {
            worker.close();
        }
        threadPool.shutdown();
        for (Future task : tasks) {
            task.get();
        }
    }

    @Test
    public void testShortLivedConnections() throws Exception {
        boolean done;
        Worker.totalIterations.set(0L);
        int mebiByte = 1048510;
        int clients = 1;
        int iterations = 2;
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(clients, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        threadPool.prestartAllCoreThreads();
        Worker[] workers = new Worker[clients];
        Future[] tasks = new Future[clients];
        for (int i = 0; i < clients; ++i) {
            workers[i] = new Worker(sslContext, iterations, true, mebiByte, 64 * mebiByte);
            tasks[i] = threadPool.submit(workers[i]);
        }
        long start = System.currentTimeMillis();
        do {
            Thread.sleep(1000L);
            done = true;
            for (Future task : tasks) {
                done &= task.isDone();
            }
        } while (!done);
        long end = System.currentTimeMillis();
        threadPool.shutdown();
        for (Future task : tasks) {
            task.get();
        }
    }

    private static class EmptyHandler
    extends AbstractHandler {
        private EmptyHandler() {
        }

        public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            int read;
            request.setHandled(true);
            ServletInputStream in = request.getInputStream();
            int total = 0;
            byte[] b = new byte[0x100000];
            while ((read = in.read(b)) >= 0) {
                total += read;
            }
            httpResponse.getOutputStream().write(String.valueOf(total).getBytes());
        }
    }

    private static class Worker
    implements Runnable {
        private static final AtomicLong totalIterations = new AtomicLong();
        private final SSLContext sslContext;
        private volatile SSLSocket sslSocket;
        private final int iterations;
        private final boolean closeConnection;
        private final int minContent;
        private final int maxContent;

        public Worker(SSLContext sslContext, int iterations, boolean closeConnection, int minContent, int maxContent) {
            this.sslContext = sslContext;
            this.iterations = iterations;
            this.closeConnection = closeConnection;
            this.minContent = minContent;
            this.maxContent = maxContent;
        }

        public void open() throws IOException {
            this.sslSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket("localhost", connector.getLocalPort());
        }

        public void close() throws IOException {
            this.sslSocket.close();
        }

        @Override
        public void run() {
            try {
                Random random = new Random();
                StringBuilder builder = new StringBuilder();
                OutputStream out = null;
                InputStream in = null;
                if (!this.closeConnection) {
                    this.open();
                    out = this.sslSocket.getOutputStream();
                    in = this.sslSocket.getInputStream();
                }
                for (int i = 0; i < this.iterations; ++i) {
                    String line;
                    int chunk;
                    if (this.closeConnection) {
                        this.open();
                        out = this.sslSocket.getOutputStream();
                        in = this.sslSocket.getInputStream();
                    }
                    int contentSize = random.nextInt(this.maxContent - this.minContent) + this.minContent;
                    out.write("POST / HTTP/1.1\r\n".getBytes());
                    out.write("Host: localhost\r\n".getBytes());
                    out.write(("Content-Length: " + contentSize + "\r\n").getBytes());
                    out.write("Content-Type: application/octect-stream\r\n".getBytes());
                    if (this.closeConnection) {
                        out.write("Connection: close\r\n".getBytes());
                    }
                    out.write("\r\n".getBytes());
                    out.flush();
                    byte[] contentChunk = new byte[this.minContent];
                    for (int content = contentSize; content > 0; content -= chunk) {
                        chunk = Math.min(content, contentChunk.length);
                        Arrays.fill(contentChunk, 0, chunk, (byte)120);
                        out.write(contentChunk, 0, chunk);
                    }
                    out.flush();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    int responseLength = 0;
                    while ((line = reader.readLine()) != null) {
                        String contentLength = "Content-Length:";
                        if (line.startsWith(contentLength)) {
                            responseLength = Integer.parseInt(line.substring(contentLength.length()).trim());
                            continue;
                        }
                        if (line.length() != 0) continue;
                        if (responseLength != 0) break;
                        line = reader.readLine();
                        break;
                    }
                    builder.setLength(0);
                    if (responseLength > 0) {
                        for (int j = 0; j < responseLength; ++j) {
                            builder.append((char)reader.read());
                        }
                    } else {
                        builder.append(line);
                    }
                    if (this.closeConnection) {
                        this.close();
                    }
                    if (contentSize != Integer.parseInt(builder.toString())) {
                        throw new IllegalStateException();
                    }
                    Thread.sleep(random.nextInt(1000));
                    totalIterations.incrementAndGet();
                }
                if (!this.closeConnection) {
                    this.close();
                }
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
    }
}

