/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SSLEngineTest {
    private static final String HELLO_WORLD = "Hello world. The quick brown fox jumped over the lazy dog. How now brown cow. The rain in spain falls mainly on the plain.\n";
    private static final String JETTY_VERSION = Server.getVersion();
    private static final String PROTOCOL_VERSION = "2.0";
    private static final String REQUEST0_HEADER = "POST /r0 HTTP/1.1\nHost: localhost\nContent-Type: text/xml\nContent-Length: ";
    private static final String REQUEST1_HEADER = "POST /r1 HTTP/1.1\nHost: localhost\nContent-Type: text/xml\nConnection: close\nContent-Length: ";
    private static final String REQUEST_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<requests xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"commander.xsd\" version=\"2.0\">\n</requests>";
    private static final String REQUEST0 = "POST /r0 HTTP/1.1\nHost: localhost\nContent-Type: text/xml\nContent-Length: " + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<requests xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"commander.xsd\" version=\"2.0\">\n</requests>".getBytes().length + "\n\n" + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<requests xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"commander.xsd\" version=\"2.0\">\n</requests>";
    private static final String REQUEST1 = "POST /r1 HTTP/1.1\nHost: localhost\nContent-Type: text/xml\nConnection: close\nContent-Length: " + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<requests xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"commander.xsd\" version=\"2.0\">\n</requests>".getBytes().length + "\n\n" + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<requests xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"commander.xsd\" version=\"2.0\">\n</requests>";
    private static final String RESPONSE0 = "HTTP/1.1 200 OK\nContent-Length: " + "Hello world. The quick brown fox jumped over the lazy dog. How now brown cow. The rain in spain falls mainly on the plain.\n".length() + "\n" + "Server: Jetty(" + JETTY_VERSION + ")\n" + '\n' + "Hello world. The quick brown fox jumped over the lazy dog. How now brown cow. The rain in spain falls mainly on the plain.\n";
    private static final String RESPONSE1 = "HTTP/1.1 200 OK\nConnection: close\nServer: Jetty(" + JETTY_VERSION + ")\n" + '\n' + "Hello world. The quick brown fox jumped over the lazy dog. How now brown cow. The rain in spain falls mainly on the plain.\n";
    private static final int BODY_SIZE = 300;
    private Server server;
    private ServerConnector connector;

    @Before
    public void startServer() throws Exception {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore").getAbsolutePath();
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setKeyManagerPassword("keypwd");
        this.server = new Server();
        HttpConnectionFactory http = new HttpConnectionFactory();
        http.setInputBufferSize(512);
        http.getHttpConfiguration().setRequestHeaderSize(512);
        this.connector = new ServerConnector(this.server, sslContextFactory, new ConnectionFactory[]{http});
        this.connector.setPort(0);
        ((HttpConnectionFactory)this.connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setSendDateHeader(false);
        this.server.addConnector((Connector)this.connector);
    }

    @After
    public void stopServer() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testHelloWorld() throws Exception {
        this.server.setHandler((Handler)new HelloWorldHandler());
        this.server.start();
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, SslContextFactory.TRUST_ALL_CERTS, new SecureRandom());
        int port = this.connector.getLocalPort();
        Socket client = ctx.getSocketFactory().createSocket("localhost", port);
        OutputStream os = client.getOutputStream();
        String request = "GET / HTTP/1.1\r\nHost: localhost:" + port + "\r\n" + "Connection: close\r\n" + "\r\n";
        os.write(request.getBytes());
        os.flush();
        String response = IO.toString((InputStream)client.getInputStream());
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)HELLO_WORLD));
    }

    @Test
    public void testBigResponse() throws Exception {
        this.server.setHandler((Handler)new HelloWorldHandler());
        this.server.start();
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, SslContextFactory.TRUST_ALL_CERTS, new SecureRandom());
        int port = this.connector.getLocalPort();
        Socket client = ctx.getSocketFactory().createSocket("localhost", port);
        OutputStream os = client.getOutputStream();
        String request = "GET /?dump=102400 HTTP/1.1\r\nHost: localhost:" + port + "\r\n" + "Connection: close\r\n" + "\r\n";
        os.write(request.getBytes());
        os.flush();
        String response = IO.toString((InputStream)client.getInputStream());
        Assert.assertThat((Object)response.length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(102400)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestJettyHttps() throws Exception {
        this.server.setHandler((Handler)new HelloWorldHandler());
        this.server.start();
        int loops = 10;
        int numConns = 20;
        Socket[] client = new Socket[20];
        SSLContext ctx = SSLContext.getInstance("SSLv3");
        ctx.init(null, SslContextFactory.TRUST_ALL_CERTS, new SecureRandom());
        int port = this.connector.getLocalPort();
        for (int l = 0; l < 10; ++l) {
            int i;
            try {
                OutputStream os;
                for (i = 0; i < 20; ++i) {
                    client[i] = ctx.getSocketFactory().createSocket("localhost", port);
                    os = client[i].getOutputStream();
                    os.write(REQUEST0.getBytes());
                    os.write(REQUEST0.getBytes());
                    os.flush();
                }
                for (i = 0; i < 20; ++i) {
                    os = client[i].getOutputStream();
                    os.write(REQUEST1.getBytes());
                    os.flush();
                }
                for (i = 0; i < 20; ++i) {
                    String responses = SSLEngineTest.readResponse(client[i]);
                    Assert.assertEquals((String)String.format("responses loop=%d connection=%d", l, i), (Object)(RESPONSE0 + RESPONSE0 + RESPONSE1), (Object)responses);
                }
                continue;
            }
            finally {
                for (i = 0; i < 20; ++i) {
                    if (client[i] == null) continue;
                    try {
                        Assert.assertEquals((long)-1L, (long)client[i].getInputStream().read());
                        continue;
                    }
                    catch (SocketException socketException) {}
                }
            }
        }
    }

    @Test
    public void testURLConnectionChunkedPost() throws Exception {
        StreamHandler handler = new StreamHandler();
        this.server.setHandler((Handler)handler);
        this.server.start();
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(null, SslContextFactory.TRUST_ALL_CERTS, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        URL url = new URL("https://localhost:" + this.connector.getLocalPort() + "/test");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            });
        }
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(100000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "text/plain");
        conn.setChunkedStreamingMode(128);
        conn.connect();
        byte[] b = new byte[300];
        for (int i = 0; i < 300; ++i) {
            b[i] = 120;
        }
        OutputStream os = conn.getOutputStream();
        os.write(b);
        os.flush();
        int len = 0;
        InputStream is = conn.getInputStream();
        int bytes = 0;
        while ((len = is.read(b)) > -1) {
            bytes += len;
        }
        is.close();
        Assert.assertEquals((long)300L, (long)handler.bytes);
        Assert.assertEquals((long)300L, (long)bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readResponse(Socket client) throws IOException {
        StringBuilder sb = new StringBuilder(1000);
        try (BufferedReader br = null;){
            String line;
            client.setSoTimeout(5000);
            br = new BufferedReader(new InputStreamReader(client.getInputStream()));
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private static class StreamHandler
    extends AbstractHandler {
        private int bytes = 0;

        private StreamHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setContentType("text/plain");
            response.setBufferSize(128);
            byte[] b = new byte[300];
            int len = 0;
            ServletInputStream is = request.getInputStream();
            while ((len = is.read(b)) > -1) {
                this.bytes += len;
            }
            ServletOutputStream os = response.getOutputStream();
            for (int i = 0; i < 300; ++i) {
                b[i] = 120;
            }
            os.write(b);
            response.flushBuffer();
        }
    }

    private static class HelloWorldHandler
    extends AbstractHandler {
        private HelloWorldHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String ssl_id = (String)request.getAttribute("javax.servlet.request.ssl_session_id");
            Assert.assertNotNull((Object)ssl_id);
            if (request.getParameter("dump") != null) {
                ServletOutputStream out = response.getOutputStream();
                byte[] buf = new byte[Integer.valueOf(request.getParameter("dump")).intValue()];
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = (byte)(48 + i % 10);
                }
                out.write(buf);
                out.close();
            } else {
                PrintWriter out = response.getWriter();
                out.print(SSLEngineTest.HELLO_WORLD);
                out.close();
            }
        }
    }
}

