/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.SimpleRequest;
import org.eclipse.jetty.toolchain.test.annotation.Slow;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResourceHandlerTest {
    private static String LN = System.getProperty("line.separator");
    private static Server _server;
    private static HttpConfiguration _config;
    private static ServerConnector _connector;
    private static ContextHandler _contextHandler;
    private static ResourceHandler _resourceHandler;

    @BeforeClass
    public static void setUp() throws Exception {
        File dir = MavenTestingUtils.getTargetFile((String)"test-classes/simple");
        File bigger = new File(dir, "bigger.txt");
        File big = new File(dir, "big.txt");
        try (FileOutputStream out = new FileOutputStream(bigger);){
            for (int i = 0; i < 100; ++i) {
                try (FileInputStream in = new FileInputStream(big);){
                    IO.copy((InputStream)in, (OutputStream)out);
                    continue;
                }
            }
        }
        bigger.deleteOnExit();
        LN = System.getProperty("line.separator");
        var4_4 = null;
        try (BufferedReader reader = Files.newBufferedReader(big.toPath(), StandardCharsets.UTF_8);){
            char[] cbuf = new char[128];
            reader.read(cbuf);
            String sample = new String(cbuf);
            LN = sample.contains("\r\n") ? "\r\n" : (sample.contains("\n\r") ? "\n\r" : "\n");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        _server = new Server();
        _config = new HttpConfiguration();
        _config.setOutputBufferSize(2048);
        _connector = new ServerConnector(_server, new ConnectionFactory[]{new HttpConnectionFactory(_config)});
        _server.setConnectors(new Connector[]{_connector});
        _resourceHandler = new ResourceHandler();
        _resourceHandler.setMinAsyncContentLength(4096);
        _resourceHandler.setMinMemoryMappedContentLength(8192);
        _resourceHandler.setResourceBase(MavenTestingUtils.getTargetFile((String)"test-classes/simple").getAbsolutePath());
        _contextHandler = new ContextHandler("/resource");
        _contextHandler.setHandler((Handler)_resourceHandler);
        _server.setHandler((Handler)_contextHandler);
        _server.start();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        _server.stop();
    }

    @Before
    public void before() {
        _config.setOutputBufferSize(4096);
    }

    @Test
    public void testMissing() throws Exception {
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        Assert.assertNotNull((String)"missing jetty.css", (Object)sr.getString("/resource/jetty-dir.css"));
    }

    @Test
    public void testSimple() throws Exception {
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        Assert.assertEquals((Object)"simple text", (Object)sr.getString("/resource/simple.txt"));
    }

    @Test
    public void testBigFile() throws Exception {
        _config.setOutputBufferSize(2048);
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        String response = sr.getString("/resource/big.txt");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"     1\tThis is a big file"));
        Assert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)("   400\tThis is a big file" + LN)));
    }

    @Test
    public void testBigFileBigBuffer() throws Exception {
        _config.setOutputBufferSize(16384);
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        String response = sr.getString("/resource/big.txt");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"     1\tThis is a big file"));
        Assert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)("   400\tThis is a big file" + LN)));
    }

    @Test
    public void testBigFileLittleBuffer() throws Exception {
        _config.setOutputBufferSize(8);
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        String response = sr.getString("/resource/big.txt");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"     1\tThis is a big file"));
        Assert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)("   400\tThis is a big file" + LN)));
    }

    @Test
    public void testBigger() throws Exception {
        try (Socket socket = new Socket("localhost", _connector.getLocalPort());){
            socket.getOutputStream().write("GET /resource/bigger.txt HTTP/1.0\n\n".getBytes());
            Thread.sleep(1000L);
            String response = IO.toString((InputStream)socket.getInputStream());
            Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)("   400\tThis is a big file" + LN + "     1\tThis is a big file")));
            Assert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)("   400\tThis is a big file" + LN)));
        }
    }

    @Test
    @Slow
    public void testSlowBiggest() throws Exception {
        _connector.setIdleTimeout(10000L);
        File dir = MavenTestingUtils.getTargetFile((String)"test-classes/simple");
        File biggest = new File(dir, "biggest.txt");
        try (FileOutputStream out = new FileOutputStream(biggest);){
            for (int i = 0; i < 10; ++i) {
                try (FileInputStream in = new FileInputStream(new File(dir, "bigger.txt"));){
                    IO.copy((InputStream)in, (OutputStream)out);
                    continue;
                }
            }
            ((OutputStream)out).write("\nTHE END\n".getBytes(StandardCharsets.ISO_8859_1));
        }
        biggest.deleteOnExit();
        var4_4 = null;
        try (Socket socket = new Socket("localhost", _connector.getLocalPort());
             OutputStream out = socket.getOutputStream();
             InputStream in = socket.getInputStream();){
            socket.getOutputStream().write("GET /resource/biggest.txt HTTP/1.0\n\n".getBytes());
            byte[] array = new byte[102400];
            Buffer buffer = null;
            boolean i = false;
            while (true) {
                Thread.sleep(100L);
                int len = in.read(array);
                if (len < 0) break;
                buffer = BufferUtil.toBuffer((byte[])array, (int)0, (int)len);
            }
            Assert.assertEquals((long)69L, (long)((ByteBuffer)buffer).get(buffer.limit() - 4));
            Assert.assertEquals((long)78L, (long)((ByteBuffer)buffer).get(buffer.limit() - 3));
            Assert.assertEquals((long)68L, (long)((ByteBuffer)buffer).get(buffer.limit() - 2));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }
}

