/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.junit.Assert;
import org.junit.Test;

public class ShutdownMonitorTest {
    @Test
    public void testShutdownMonitor() throws Exception {
        ShutdownMonitor.getInstance().setPort(0);
        ShutdownMonitor.getInstance().setExitVm(false);
        ShutdownMonitor.getInstance().start();
        String key = ShutdownMonitor.getInstance().getKey();
        int port = ShutdownMonitor.getInstance().getPort();
        ShutdownMonitor.getInstance().start();
        this.stop("stop", port, key, true);
        Assert.assertTrue((!ShutdownMonitor.getInstance().isAlive() ? 1 : 0) != 0);
        ShutdownMonitor.getInstance().setPort(0);
        ShutdownMonitor.getInstance().setKey("foo");
        ShutdownMonitor.getInstance().start();
        key = ShutdownMonitor.getInstance().getKey();
        port = ShutdownMonitor.getInstance().getPort();
        Assert.assertTrue((boolean)ShutdownMonitor.getInstance().isAlive());
        this.stop("stop", port, key, true);
        Assert.assertTrue((!ShutdownMonitor.getInstance().isAlive() ? 1 : 0) != 0);
    }

    @Test
    public void testForceStopCommand() throws Exception {
        System.setProperty("DEBUG", "true");
        ShutdownMonitor.getInstance().setPort(0);
        TestableServer server = new TestableServer();
        server.start();
        Assert.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ShutdownMonitor.isRegistered((LifeCycle)server));
        String key = ShutdownMonitor.getInstance().getKey();
        int port = ShutdownMonitor.getInstance().getPort();
        this.stop("forcestop", port, key, true);
        Assert.assertTrue((!ShutdownMonitor.getInstance().isAlive() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)server.stopped);
        Assert.assertTrue((!server.destroyed ? 1 : 0) != 0);
        Assert.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
        Assert.assertTrue((!ShutdownMonitor.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
    }

    @Test
    public void testOldStopCommandWithStopOnShutdownTrue() throws Exception {
        System.setProperty("DEBUG", "true");
        ShutdownMonitor.getInstance().setExitVm(false);
        ShutdownMonitor.getInstance().setPort(0);
        TestableServer server = new TestableServer();
        server.setStopAtShutdown(true);
        server.start();
        Assert.assertTrue((boolean)ShutdownThread.isRegistered((LifeCycle)server));
        Assert.assertTrue((boolean)ShutdownMonitor.isRegistered((LifeCycle)server));
        String key = ShutdownMonitor.getInstance().getKey();
        int port = ShutdownMonitor.getInstance().getPort();
        this.stop("stop", port, key, true);
        Assert.assertTrue((!ShutdownMonitor.getInstance().isAlive() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)server.stopped);
        Assert.assertTrue((!server.destroyed ? 1 : 0) != 0);
        Assert.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
        Assert.assertTrue((!ShutdownMonitor.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
    }

    @Test
    public void testOldStopCommandWithStopOnShutdownFalse() throws Exception {
        ShutdownMonitor.getInstance().setExitVm(false);
        System.setProperty("DEBUG", "true");
        ShutdownMonitor.getInstance().setPort(0);
        TestableServer server = new TestableServer();
        server.setStopAtShutdown(false);
        server.start();
        Assert.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ShutdownMonitor.isRegistered((LifeCycle)server));
        String key = ShutdownMonitor.getInstance().getKey();
        int port = ShutdownMonitor.getInstance().getPort();
        this.stop("stop", port, key, true);
        Assert.assertTrue((!ShutdownMonitor.getInstance().isAlive() ? 1 : 0) != 0);
        Assert.assertTrue((!server.stopped ? 1 : 0) != 0);
        Assert.assertTrue((!server.destroyed ? 1 : 0) != 0);
        Assert.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ShutdownMonitor.isRegistered((LifeCycle)server));
    }

    public void stop(String command, int port, String key, boolean check) throws Exception {
        block25: {
            System.out.printf("Attempting to send " + command + " to localhost:%d (%b)%n", port, check);
            try (Socket s = new Socket(InetAddress.getByName("127.0.0.1"), port);
                 OutputStream out = s.getOutputStream();){
                out.write((key + "\r\n" + command + "\r\n").getBytes());
                out.flush();
                if (!check) break block25;
                TimeUnit.MILLISECONDS.sleep(600L);
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                String response = lin.readLine();
                if (response != null) {
                    Assert.assertEquals((Object)"Stopped", (Object)response);
                    break block25;
                }
                throw new IllegalStateException("No stop confirmation");
            }
        }
    }

    public class TestableServer
    extends Server {
        boolean destroyed = false;
        boolean stopped = false;

        protected void doStop() throws Exception {
            this.stopped = true;
            super.doStop();
        }

        public void destroy() {
            this.destroyed = true;
            super.destroy();
        }

        protected void doStart() throws Exception {
            this.stopped = false;
            this.destroyed = false;
            super.doStart();
        }
    }
}

