/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ProxyProtocolTest {
    private Server server;
    private ServerConnector connector;

    private void start(Handler handler) throws Exception {
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler(handler);
        this.server.start();
    }

    @After
    public void destroy() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testProxyProtocol() throws Exception {
        String remoteAddr = "192.168.0.0";
        int remotePort = 12345;
        this.start((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if ("192.168.0.0".equals(request.getRemoteAddr()) && 12345 == request.getRemotePort()) {
                    baseRequest.setHandled(true);
                }
            }
        });
        try (Socket socket = new Socket("localhost", this.connector.getLocalPort());){
            String request1 = "PROXY TCP4 192.168.0.0 127.0.0.0 12345 8080\r\nGET /1 HTTP/1.1\r\nHost: localhost\r\n\r\n";
            OutputStream output = socket.getOutputStream();
            output.write(request1.getBytes(StandardCharsets.UTF_8));
            output.flush();
            InputStream input = socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String response1 = reader.readLine();
            Assert.assertTrue((boolean)response1.startsWith("HTTP/1.1 200 "));
            while (!reader.readLine().isEmpty()) {
            }
            String request2 = "GET /2 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
            output.write(request2.getBytes(StandardCharsets.UTF_8));
            output.flush();
            String response2 = reader.readLine();
            Assert.assertTrue((boolean)response2.startsWith("HTTP/1.1 200 "));
            while (reader.readLine() != null) {
            }
        }
    }
}

