/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpOutputTest {
    private Server _server;
    private LocalConnector _connector;
    private ContentHandler _handler;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        HttpConnectionFactory http = new HttpConnectionFactory();
        http.getHttpConfiguration().setRequestHeaderSize(1024);
        http.getHttpConfiguration().setResponseHeaderSize(1024);
        http.getHttpConfiguration().setOutputBufferSize(4096);
        this._connector = new LocalConnector(this._server, (ConnectionFactory)http, null);
        this._server.addConnector((Connector)this._connector);
        this._handler = new ContentHandler();
        this._server.setHandler((Handler)this._handler);
        this._server.start();
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testSimple() throws Exception {
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
    }

    @Test
    public void testByteUnknown() throws Exception {
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
    }

    @Test
    public void testSendArray() throws Exception {
        int i;
        byte[] buffer = new byte[16384];
        Arrays.fill(buffer, 0, 4096, (byte)-103);
        Arrays.fill(buffer, 4096, 12288, (byte)88);
        Arrays.fill(buffer, 12288, 16384, (byte)102);
        this._handler._content = ByteBuffer.wrap(buffer);
        this._handler._content.limit(12288);
        this._handler._content.position(4096);
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\nXXXXXXXXXXXXXXXXXXXXXXXXXXX"));
        for (i = 0; i < 4096; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)-103L, (long)buffer[i]);
        }
        for (i = 12288; i < 16384; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)102L, (long)buffer[i]);
        }
    }

    @Test
    public void testSendInputStreamSimple() throws Exception {
        Resource simple = Resource.newClassPathResource((String)"simple/simple.txt");
        this._handler._contentInputStream = simple.getInputStream();
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 11"));
    }

    @Test
    public void testSendInputStreamBig() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._contentInputStream = big.getInputStream();
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
    }

    @Test
    public void testSendInputStreamBigChunked() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._contentInputStream = new FilterInputStream(big.getInputStream()){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int filled = super.read(b, off, len > 2000 ? 2000 : len);
                return filled;
            }
        };
        String response = this._connector.getResponses("GET / HTTP/1.1\nHost: localhost:80\n\nGET / HTTP/1.1\nHost: localhost:80\nConnection: close\n\n");
        response = response.substring(0, response.lastIndexOf("HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0\r\n"));
    }

    @Test
    public void testSendChannelSimple() throws Exception {
        Resource simple = Resource.newClassPathResource((String)"simple/simple.txt");
        this._handler._contentChannel = simple.getReadableByteChannel();
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 11"));
    }

    @Test
    public void testSendChannelBig() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._contentChannel = big.getReadableByteChannel();
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testSendBigDirect() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)true);
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testSendBigInDirect() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testSendChannelBigChunked() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        final ReadableByteChannel channel = big.getReadableByteChannel();
        this._handler._contentChannel = new ReadableByteChannel(){

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                int filled = 0;
                if (dst.position() == 0 && dst.limit() > 2000) {
                    int limit = dst.limit();
                    dst.limit(2000);
                    filled = channel.read(dst);
                    dst.limit(limit);
                } else {
                    filled = channel.read(dst);
                }
                return filled;
            }
        };
        String response = this._connector.getResponses("GET / HTTP/1.1\nHost: localhost:80\n\nGET / HTTP/1.1\nHost: localhost:80\nConnection: close\n\n");
        response = response.substring(0, response.lastIndexOf("HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0\r\n"));
    }

    @Test
    public void testWriteByte() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[1];
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testWriteSmall() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8];
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testWriteMed() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[4000];
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testWriteLarge() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8192];
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testWriteByteKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[1];
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testWriteSmallKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8];
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testWriteMedKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[4000];
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testWriteLargeKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8192];
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testWriteHugeKnown() throws Exception {
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.allocate((int)0x400000);
        this._handler._content.limit(this._handler._content.capacity());
        int i = this._handler._content.capacity();
        while (i-- > 0) {
            this._handler._content.put(i, (byte)120);
        }
        this._handler._arrayBuffer = new byte[8192];
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
    }

    @Test
    public void testWriteBufferSmall() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8);
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testWriteBufferMed() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)4000);
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testWriteBufferLarge() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8192);
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testAsyncWriteByte() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[1];
        this._handler._async = true;
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testAsyncWriteSmall() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8];
        this._handler._async = true;
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testAsyncWriteMed() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[4000];
        this._handler._async = true;
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testAsyncWriteLarge() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8192];
        this._handler._async = true;
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testAsyncWriteHuge() throws Exception {
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.allocate((int)0x400000);
        this._handler._content.limit(this._handler._content.capacity());
        int i = this._handler._content.capacity();
        while (i-- > 0) {
            this._handler._content.put(i, (byte)120);
        }
        this._handler._arrayBuffer = new byte[8192];
        this._handler._async = true;
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
    }

    @Test
    public void testAsyncWriteBufferSmall() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8);
        this._handler._async = true;
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testAsyncWriteBufferMed() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)4000);
        this._handler._async = true;
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testAsyncWriteBufferLarge() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8192);
        this._handler._async = true;
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
    }

    @Test
    public void testAsyncWriteBufferLargeHEAD() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8192);
        this._handler._async = true;
        int start = this._handler._owp.get();
        String response = this._connector.getResponses("HEAD / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)(this._handler._owp.get() - start), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"400\tThis is a big file")));
    }

    @Test
    public void testAsyncWriteSimpleKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/simple.txt");
        this._handler._async = true;
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[4000];
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 11"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"simple text"));
    }

    @Test
    public void testAsyncWriteSimpleKnownHEAD() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/simple.txt");
        this._handler._async = true;
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[4000];
        int start = this._handler._owp.get();
        String response = this._connector.getResponses("HEAD / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)(this._handler._owp.get() - start), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 11"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"simple text")));
    }

    static class ContentHandler
    extends AbstractHandler {
        AtomicInteger _owp = new AtomicInteger();
        boolean _writeLengthIfKnown = true;
        boolean _async;
        ByteBuffer _byteBuffer;
        byte[] _arrayBuffer;
        InputStream _contentInputStream;
        ReadableByteChannel _contentChannel;
        ByteBuffer _content;

        ContentHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentType("text/plain");
            final HttpOutput out = (HttpOutput)response.getOutputStream();
            if (this._contentInputStream != null) {
                out.sendContent(this._contentInputStream);
                this._contentInputStream = null;
                return;
            }
            if (this._contentChannel != null) {
                out.sendContent(this._contentChannel);
                this._contentChannel = null;
                return;
            }
            if (this._content != null && this._writeLengthIfKnown) {
                response.setContentLength(this._content.remaining());
            }
            if (this._arrayBuffer != null) {
                if (this._async) {
                    final AsyncContext async = request.startAsync();
                    out.setWriteListener(new WriteListener(){

                        public void onWritePossible() throws IOException {
                            ContentHandler.this._owp.incrementAndGet();
                            while (out.isReady()) {
                                Assert.assertTrue((boolean)out.isReady());
                                int len = ContentHandler.this._content.remaining();
                                if (len > ContentHandler.this._arrayBuffer.length) {
                                    len = ContentHandler.this._arrayBuffer.length;
                                }
                                if (len == 0) {
                                    async.complete();
                                    break;
                                }
                                ContentHandler.this._content.get(ContentHandler.this._arrayBuffer, 0, len);
                                if (len == 1) {
                                    out.write((int)ContentHandler.this._arrayBuffer[0]);
                                    continue;
                                }
                                out.write(ContentHandler.this._arrayBuffer, 0, len);
                            }
                        }

                        public void onError(Throwable t) {
                            t.printStackTrace();
                            async.complete();
                        }
                    });
                    return;
                }
                while (BufferUtil.hasContent((ByteBuffer)this._content)) {
                    int len = this._content.remaining();
                    if (len > this._arrayBuffer.length) {
                        len = this._arrayBuffer.length;
                    }
                    this._content.get(this._arrayBuffer, 0, len);
                    if (len == 1) {
                        out.write((int)this._arrayBuffer[0]);
                        continue;
                    }
                    out.write(this._arrayBuffer, 0, len);
                }
                return;
            }
            if (this._byteBuffer != null) {
                if (this._async) {
                    final AsyncContext async = request.startAsync();
                    out.setWriteListener(new WriteListener(){

                        public void onWritePossible() throws IOException {
                            ContentHandler.this._owp.incrementAndGet();
                            while (out.isReady()) {
                                Assert.assertTrue((boolean)out.isReady());
                                if (BufferUtil.isEmpty((ByteBuffer)ContentHandler.this._content)) {
                                    async.complete();
                                    break;
                                }
                                BufferUtil.clearToFill((ByteBuffer)ContentHandler.this._byteBuffer);
                                BufferUtil.put((ByteBuffer)ContentHandler.this._content, (ByteBuffer)ContentHandler.this._byteBuffer);
                                BufferUtil.flipToFlush((ByteBuffer)ContentHandler.this._byteBuffer, (int)0);
                                out.write(ContentHandler.this._byteBuffer);
                            }
                        }

                        public void onError(Throwable t) {
                            t.printStackTrace();
                            async.complete();
                        }
                    });
                    return;
                }
                while (BufferUtil.hasContent((ByteBuffer)this._content)) {
                    BufferUtil.clearToFill((ByteBuffer)this._byteBuffer);
                    BufferUtil.put((ByteBuffer)this._content, (ByteBuffer)this._byteBuffer);
                    BufferUtil.flipToFlush((ByteBuffer)this._byteBuffer, (int)0);
                    out.write(this._byteBuffer);
                }
                return;
            }
            if (this._content != null) {
                if (this._content.hasArray()) {
                    out.write(this._content.array(), this._content.arrayOffset() + this._content.position(), this._content.remaining());
                } else {
                    out.sendContent(this._content);
                }
                this._content = null;
                return;
            }
        }
    }
}

