/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.AbstractHttpTest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HttpManyWaysToAsyncCommitBadBehaviourTest
extends AbstractHttpTest {
    private final String CONTEXT_ATTRIBUTE = this.getClass().getName() + ".asyncContext";
    private boolean dispatch;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{HttpVersion.HTTP_1_0.asString(), true}, {HttpVersion.HTTP_1_0.asString(), false}, {HttpVersion.HTTP_1_1.asString(), true}, {HttpVersion.HTTP_1_1.asString(), false}};
        return Arrays.asList(data);
    }

    public HttpManyWaysToAsyncCommitBadBehaviourTest(String httpVersion, boolean dispatch) {
        super(httpVersion);
        this.httpVersion = httpVersion;
        this.dispatch = dispatch;
    }

    @Test
    public void testHandlerSetsHandledAndWritesSomeContent() throws Exception {
        server.setHandler((Handler)new SetHandledWriteSomeDataHandler(false));
        server.start();
        SimpleHttpResponse response = this.executeRequest();
        Assert.assertThat((String)"response code is 500", (Object)response.getCode(), (Matcher)Matchers.is((Object)"500"));
    }

    private class SetHandledWriteSomeDataHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetHandledWriteSomeDataHandler(boolean throwException) {
            super(HttpManyWaysToAsyncCommitBadBehaviourTest.this, throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            final CyclicBarrier resumeBarrier = new CyclicBarrier(1);
            if (request.getAttribute(HttpManyWaysToAsyncCommitBadBehaviourTest.this.CONTEXT_ATTRIBUTE) == null) {
                final AsyncContext asyncContext = baseRequest.startAsync();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            asyncContext.getResponse().getWriter().write("foobar");
                            if (HttpManyWaysToAsyncCommitBadBehaviourTest.this.dispatch) {
                                asyncContext.dispatch();
                            } else {
                                asyncContext.complete();
                            }
                            resumeBarrier.await(5L, TimeUnit.SECONDS);
                        }
                        catch (IOException | InterruptedException | BrokenBarrierException | TimeoutException e) {
                            e.printStackTrace();
                        }
                    }
                }).run();
            }
            try {
                resumeBarrier.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | BrokenBarrierException | TimeoutException e) {
                e.printStackTrace();
            }
            throw new AbstractHttpTest.TestCommitException();
        }
    }
}

