/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import javax.servlet.SessionCookieConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.junit.Assert;
import org.junit.Test;

public class SessionCookieTest {
    @Test
    public void testSecureSessionCookie() throws Exception {
        MockSessionIdManager idMgr = new MockSessionIdManager();
        idMgr.setWorkerName("node1");
        MockSessionManager mgr = new MockSessionManager();
        mgr.setSessionIdManager((SessionIdManager)idMgr);
        MockSession session = new MockSession(mgr, System.currentTimeMillis(), System.currentTimeMillis(), "node1123");
        SessionCookieConfig sessionCookieConfig = mgr.getSessionCookieConfig();
        sessionCookieConfig.setSecure(true);
        HttpCookie cookie = mgr.getSessionCookie((HttpSession)session, "/foo", true);
        Assert.assertTrue((boolean)cookie.isSecure());
        cookie = mgr.getSessionCookie((HttpSession)session, "/foo", false);
        Assert.assertTrue((boolean)cookie.isSecure());
        sessionCookieConfig.setSecure(false);
        cookie = mgr.getSessionCookie((HttpSession)session, "/foo", true);
        Assert.assertTrue((boolean)cookie.isSecure());
        cookie = mgr.getSessionCookie((HttpSession)session, "/foo", false);
        Assert.assertFalse((boolean)cookie.isSecure());
        mgr.setSecureRequestOnly(false);
        cookie = mgr.getSessionCookie((HttpSession)session, "/foo", false);
        Assert.assertFalse((boolean)cookie.isSecure());
        cookie = mgr.getSessionCookie((HttpSession)session, "/foo", true);
        Assert.assertFalse((boolean)cookie.isSecure());
    }

    public class MockSessionManager
    extends AbstractSessionManager {
        protected void addSession(AbstractSession session) {
        }

        public AbstractSession getSession(String idInCluster) {
            return null;
        }

        protected void invalidateSessions() throws Exception {
        }

        protected AbstractSession newSession(HttpServletRequest request) {
            return null;
        }

        protected boolean removeSession(String idInCluster) {
            return false;
        }

        public void renewSessionId(String oldClusterId, String oldNodeId, String newClusterId, String newNodeId) {
        }
    }

    public class MockSessionIdManager
    extends AbstractSessionIdManager {
        public boolean idInUse(String id) {
            return false;
        }

        public void addSession(HttpSession session) {
        }

        public void removeSession(HttpSession session) {
        }

        public void invalidateAll(String id) {
        }

        public void renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
        }
    }

    public class MockSession
    extends AbstractSession {
        protected MockSession(AbstractSessionManager abstractSessionManager, long created, long accessed, String clusterId) {
            super(abstractSessionManager, created, accessed, clusterId);
        }
    }
}

