/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ConnectorStatistics;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatisticsHandlerTest {
    private Server _server;
    private ConnectorStatistics _statistics;
    private LocalConnector _connector;
    private LatchHandler _latchHandler;
    private StatisticsHandler _statsHandler;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._statistics = new ConnectorStatistics();
        this._connector.addBean((Object)this._statistics);
        this._server.addConnector((Connector)this._connector);
        this._latchHandler = new LatchHandler();
        this._statsHandler = new StatisticsHandler();
        this._server.setHandler((Handler)this._latchHandler);
        this._latchHandler.setHandler((Handler)this._statsHandler);
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testRequest() throws Exception {
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    barrier[1].await();
                }
                catch (Exception x) {
                    Thread.currentThread().interrupt();
                    throw (IOException)new IOException().initCause(x);
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._statistics.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActiveMax());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActiveMax());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getAsyncRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getAsyncDispatches());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getResponses2xx());
        this._latchHandler.reset();
        barrier[0].reset();
        barrier[1].reset();
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)2L, (long)this._statistics.getConnectionsOpen());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActiveMax());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActiveMax());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getAsyncRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getAsyncDispatches());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getResponses2xx());
        this._latchHandler.reset(2);
        barrier[0] = new CyclicBarrier(3);
        barrier[1] = new CyclicBarrier(3);
        this._connector.executeRequest(request);
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)4L, (long)this._statistics.getConnectionsOpen());
        Assert.assertEquals((long)4L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)4L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatchedActiveMax());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await());
        Assert.assertEquals((long)4L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getRequestsActiveMax());
        Assert.assertEquals((long)4L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatchedActiveMax());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getAsyncRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getAsyncDispatches());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)4L, (long)this._statsHandler.getResponses2xx());
    }

    @Test
    public void testSuspendResume() throws Exception {
        long dispatchTime = 10L;
        long requestTime = 50L;
        final AtomicReference asyncHolder = new AtomicReference();
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    Thread.sleep(10L);
                    if (asyncHolder.get() == null) {
                        asyncHolder.set(request.startAsync());
                    }
                }
                catch (Exception x) {
                    throw new ServletException((Throwable)x);
                }
                finally {
                    try {
                        barrier[1].await();
                    }
                    catch (Exception ignored) {}
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._statistics.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await());
        Assert.assertNotNull(asyncHolder.get());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        this._latchHandler.reset();
        barrier[0].reset();
        barrier[1].reset();
        Thread.sleep(50L);
        ((AsyncContext)asyncHolder.get()).addListener(new AsyncListener(){

            public void onTimeout(AsyncEvent event) throws IOException {
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onComplete(AsyncEvent event) throws IOException {
                try {
                    barrier[2].await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ((AsyncContext)asyncHolder.get()).dispatch();
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._statistics.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await());
        barrier[2].await();
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)2L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getAsyncRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getAsyncDispatches());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getResponses2xx());
        Assert.assertThat((Object)this._statsHandler.getRequestTimeTotal(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(37L)));
        Assert.assertEquals((long)this._statsHandler.getRequestTimeTotal(), (long)this._statsHandler.getRequestTimeMax());
        Assert.assertEquals((double)this._statsHandler.getRequestTimeTotal(), (double)this._statsHandler.getRequestTimeMean(), (double)0.01);
        Assert.assertThat((Object)this._statsHandler.getDispatchedTimeTotal(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(15L)));
        Assert.assertTrue((this._statsHandler.getDispatchedTimeMean() + 10.0 <= (double)this._statsHandler.getDispatchedTimeTotal() ? 1 : 0) != 0);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeMax() + 10L <= this._statsHandler.getDispatchedTimeTotal() ? 1 : 0) != 0);
    }

    @Test
    public void testSuspendExpire() throws Exception {
        long dispatchTime = 10L;
        long timeout = 100L;
        final AtomicReference asyncHolder = new AtomicReference();
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2), new CyclicBarrier(2)};
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    Thread.sleep(10L);
                    if (asyncHolder.get() == null) {
                        AsyncContext async = request.startAsync();
                        asyncHolder.set(async);
                        async.setTimeout(100L);
                    }
                }
                catch (Exception x) {
                    throw new ServletException((Throwable)x);
                }
                finally {
                    try {
                        barrier[1].await();
                    }
                    catch (Exception ignored) {}
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._statistics.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await());
        Assert.assertNotNull(asyncHolder.get());
        ((AsyncContext)asyncHolder.get()).addListener(new AsyncListener(){

            public void onTimeout(AsyncEvent event) throws IOException {
                event.getAsyncContext().complete();
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onComplete(AsyncEvent event) throws IOException {
                try {
                    barrier[2].await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        barrier[2].await();
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getAsyncRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getAsyncDispatches());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getResponses2xx());
        Assert.assertTrue((this._statsHandler.getRequestTimeTotal() >= 82L ? 1 : 0) != 0);
        Assert.assertEquals((long)this._statsHandler.getRequestTimeTotal(), (long)this._statsHandler.getRequestTimeMax());
        Assert.assertEquals((double)this._statsHandler.getRequestTimeTotal(), (double)this._statsHandler.getRequestTimeMean(), (double)0.01);
        Assert.assertThat((Object)this._statsHandler.getDispatchedTimeTotal(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(7L)));
    }

    @Test
    public void testSuspendComplete() throws Exception {
        long dispatchTime = 10L;
        final AtomicReference asyncHolder = new AtomicReference();
        final CyclicBarrier[] barrier = new CyclicBarrier[]{new CyclicBarrier(2), new CyclicBarrier(2)};
        final CountDownLatch latch = new CountDownLatch(1);
        this._statsHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                request.setHandled(true);
                try {
                    barrier[0].await();
                    Thread.sleep(10L);
                    if (asyncHolder.get() == null) {
                        AsyncContext async = request.startAsync();
                        asyncHolder.set(async);
                    }
                }
                catch (Exception x) {
                    throw new ServletException((Throwable)x);
                }
                finally {
                    try {
                        barrier[1].await();
                    }
                    catch (Exception ignored) {}
                }
            }
        });
        this._server.start();
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        this._connector.executeRequest(request);
        barrier[0].await();
        Assert.assertEquals((long)1L, (long)this._statistics.getConnectionsOpen());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatchedActive());
        barrier[1].await();
        Assert.assertTrue((boolean)this._latchHandler.await());
        Assert.assertNotNull(asyncHolder.get());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        ((AsyncContext)asyncHolder.get()).addListener(new AsyncListener(){

            public void onTimeout(AsyncEvent event) throws IOException {
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onComplete(AsyncEvent event) throws IOException {
                try {
                    latch.countDown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        long requestTime = 20L;
        Thread.sleep(requestTime);
        ((AsyncContext)asyncHolder.get()).complete();
        latch.await();
        Assert.assertEquals((long)1L, (long)this._statsHandler.getRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getRequestsActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getDispatched());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getDispatchedActive());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getAsyncRequests());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getAsyncDispatches());
        Assert.assertEquals((long)0L, (long)this._statsHandler.getExpires());
        Assert.assertEquals((long)1L, (long)this._statsHandler.getResponses2xx());
        Assert.assertTrue((this._statsHandler.getRequestTimeTotal() >= (10L + requestTime) * 3L / 4L ? 1 : 0) != 0);
        Assert.assertEquals((long)this._statsHandler.getRequestTimeTotal(), (long)this._statsHandler.getRequestTimeMax());
        Assert.assertEquals((double)this._statsHandler.getRequestTimeTotal(), (double)this._statsHandler.getRequestTimeMean(), (double)0.01);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeTotal() >= 7L ? 1 : 0) != 0);
        Assert.assertTrue((this._statsHandler.getDispatchedTimeTotal() < this._statsHandler.getRequestTimeTotal() ? 1 : 0) != 0);
        Assert.assertEquals((long)this._statsHandler.getDispatchedTimeTotal(), (long)this._statsHandler.getDispatchedTimeMax());
        Assert.assertEquals((double)this._statsHandler.getDispatchedTimeTotal(), (double)this._statsHandler.getDispatchedTimeMean(), (double)0.01);
    }

    private static class LatchHandler
    extends HandlerWrapper {
        private volatile CountDownLatch _latch = new CountDownLatch(1);

        private LatchHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            CountDownLatch latch = this._latch;
            try {
                super.handle(path, request, httpRequest, httpResponse);
            }
            finally {
                latch.countDown();
            }
        }

        private void reset() {
            this._latch = new CountDownLatch(1);
        }

        private void reset(int count) {
            this._latch = new CountDownLatch(count);
        }

        private boolean await() throws InterruptedException {
            return this._latch.await(10000L, TimeUnit.MILLISECONDS);
        }
    }
}

