/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ShutdownHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ShutdownHandlerTest {
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    private Server server = new Server(0);
    private String shutdownToken = "asdlnsldgnklns";
    private ShutdownHandler shutdownHandler;

    @Before
    public void startServer() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.shutdownHandler = new ShutdownHandler(this.shutdownToken);
        this.server.setHandler((Handler)this.shutdownHandler);
        this.server.start();
    }

    @Test
    public void shutdownServerWithCorrectTokenAndIPTest() throws Exception {
        this.setDefaultExpectations();
        final CountDownLatch countDown = new CountDownLatch(1);
        this.server.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarting(LifeCycle event) {
            }

            public void lifeCycleStarted(LifeCycle event) {
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
            }

            public void lifeCycleStopping(LifeCycle event) {
            }

            public void lifeCycleStopped(LifeCycle event) {
                countDown.countDown();
            }
        });
        this.shutdownHandler.handle("/shutdown", null, this.request, this.response);
        boolean stopped = countDown.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"Server lifecycle stop listener called", (boolean)stopped);
        Assert.assertEquals((String)"Server should be stopped", (Object)"STOPPED", (Object)this.server.getState());
    }

    @Test
    public void wrongTokenTest() throws Exception {
        this.setDefaultExpectations();
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)"anothertoken");
        this.shutdownHandler.handle("/shutdown", null, this.request, this.response);
        Assert.assertEquals((String)"Server should be running", (Object)"STARTED", (Object)this.server.getState());
    }

    @Test
    public void shutdownRequestNotFromLocalhostTest() throws Exception {
        this.setDefaultExpectations();
        Mockito.when((Object)this.request.getRemoteAddr()).thenReturn((Object)"192.168.3.3");
        this.shutdownHandler.handle("/shutdown", null, this.request, this.response);
        Assert.assertEquals((String)"Server should be running", (Object)"STARTED", (Object)this.server.getState());
    }

    private void setDefaultExpectations() {
        Mockito.when((Object)this.request.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)this.request.getParameter("token")).thenReturn((Object)this.shutdownToken);
        Mockito.when((Object)this.request.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
    }
}

