/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.SimpleRequest;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResourceHandlerTest {
    private static Server _server;
    private static HttpConfiguration _config;
    private static ServerConnector _connector;
    private static ContextHandler _contextHandler;
    private static ResourceHandler _resourceHandler;

    @BeforeClass
    public static void setUp() throws Exception {
        File dir = MavenTestingUtils.getTargetFile((String)"test-classes/simple");
        File huge = new File(dir, "huge.txt");
        File big = new File(dir, "big.txt");
        try (FileOutputStream out = new FileOutputStream(huge);){
            for (int i = 0; i < 100; ++i) {
                try (FileInputStream in = new FileInputStream(big);){
                    IO.copy((InputStream)in, (OutputStream)out);
                    continue;
                }
            }
        }
        huge.deleteOnExit();
        _server = new Server();
        _config = new HttpConfiguration();
        _config.setOutputBufferSize(2048);
        _connector = new ServerConnector(_server, new ConnectionFactory[]{new HttpConnectionFactory(_config)});
        _server.setConnectors(new Connector[]{_connector});
        _resourceHandler = new ResourceHandler();
        _resourceHandler.setMinAsyncContentLength(4096);
        _resourceHandler.setMinMemoryMappedContentLength(8192);
        _resourceHandler.setResourceBase(MavenTestingUtils.getTargetFile((String)"test-classes/simple").getAbsolutePath());
        _contextHandler = new ContextHandler("/resource");
        _contextHandler.setHandler((Handler)_resourceHandler);
        _server.setHandler((Handler)_contextHandler);
        _server.start();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        _server.stop();
    }

    @Before
    public void before() {
        _config.setOutputBufferSize(4096);
    }

    @Test
    public void testMissing() throws Exception {
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        Assert.assertNotNull((String)"missing jetty.css", (Object)sr.getString("/resource/jetty-dir.css"));
    }

    @Test
    public void testSimple() throws Exception {
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        Assert.assertEquals((Object)"simple text", (Object)sr.getString("/resource/simple.txt"));
    }

    @Test
    public void testBigFile() throws Exception {
        _config.setOutputBufferSize(2048);
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        String response = sr.getString("/resource/big.txt");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"     1\tThis is a big file"));
        Assert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"   400\tThis is a big file\n"));
    }

    @Test
    public void testBigFileBigBuffer() throws Exception {
        _config.setOutputBufferSize(16384);
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        String response = sr.getString("/resource/big.txt");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"     1\tThis is a big file"));
        Assert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"   400\tThis is a big file\n"));
    }

    @Test
    public void testBigFileLittleBuffer() throws Exception {
        _config.setOutputBufferSize(8);
        SimpleRequest sr = new SimpleRequest(new URI("http://localhost:" + _connector.getLocalPort()));
        String response = sr.getString("/resource/big.txt");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"     1\tThis is a big file"));
        Assert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"   400\tThis is a big file\n"));
    }

    @Test
    public void testHuge() throws Exception {
        try (Socket socket = new Socket("localhost", _connector.getLocalPort());){
            socket.getOutputStream().write("GET /resource/huge.txt HTTP/1.0\n\n".getBytes());
            Thread.sleep(1000L);
            String response = IO.toString((InputStream)socket.getInputStream());
            Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"   400\tThis is a big file\n     1\tThis is a big file"));
            Assert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"   400\tThis is a big file\n"));
        }
    }
}

