/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ContextHandlerTest {
    @Test
    public void testGetResourcePathsWhenSuppliedPathEndsInSlash() throws Exception {
        this.checkResourcePathsForExampleWebApp("/WEB-INF/");
    }

    @Test
    public void testGetResourcePathsWhenSuppliedPathDoesNotEndInSlash() throws Exception {
        this.checkResourcePathsForExampleWebApp("/WEB-INF");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHostNormalization() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandler contextA = new ContextHandler("/");
        contextA.setVirtualHosts(new String[]{"www.example.com"});
        IsHandledHandler handlerA = new IsHandledHandler();
        contextA.setHandler((Handler)handlerA);
        ContextHandler contextB = new ContextHandler("/");
        IsHandledHandler handlerB = new IsHandledHandler();
        contextB.setHandler((Handler)handlerB);
        contextB.setVirtualHosts(new String[]{"www.example2.com."});
        ContextHandler contextC = new ContextHandler("/");
        IsHandledHandler handlerC = new IsHandledHandler();
        contextC.setHandler((Handler)handlerC);
        HandlerCollection c = new HandlerCollection();
        c.addHandler((Handler)contextA);
        c.addHandler((Handler)contextB);
        c.addHandler((Handler)contextC);
        server.setHandler((Handler)c);
        try {
            server.start();
            connector.getResponses("GET / HTTP/1.0\nHost: www.example.com.\n\n");
            Assert.assertTrue((boolean)handlerA.isHandled());
            Assert.assertFalse((boolean)handlerB.isHandled());
            Assert.assertFalse((boolean)handlerC.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            connector.getResponses("GET / HTTP/1.0\nHost: www.example2.com\n\n");
            Assert.assertFalse((boolean)handlerA.isHandled());
            Assert.assertTrue((boolean)handlerB.isHandled());
            Assert.assertFalse((boolean)handlerC.isHandled());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamedConnector() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        LocalConnector connectorN = new LocalConnector(server);
        connectorN.setName("name");
        server.setConnectors(new Connector[]{connector, connectorN});
        ContextHandler contextA = new ContextHandler("/");
        contextA.setVirtualHosts(new String[]{"www.example.com"});
        IsHandledHandler handlerA = new IsHandledHandler();
        contextA.setHandler((Handler)handlerA);
        ContextHandler contextB = new ContextHandler("/");
        IsHandledHandler handlerB = new IsHandledHandler();
        contextB.setHandler((Handler)handlerB);
        contextB.setVirtualHosts(new String[]{"@name"});
        ContextHandler contextC = new ContextHandler("/");
        IsHandledHandler handlerC = new IsHandledHandler();
        contextC.setHandler((Handler)handlerC);
        HandlerCollection c = new HandlerCollection();
        c.addHandler((Handler)contextA);
        c.addHandler((Handler)contextB);
        c.addHandler((Handler)contextC);
        server.setHandler((Handler)c);
        server.start();
        try {
            connector.getResponses("GET / HTTP/1.0\nHost: www.example.com.\n\n");
            Assert.assertTrue((boolean)handlerA.isHandled());
            Assert.assertFalse((boolean)handlerB.isHandled());
            Assert.assertFalse((boolean)handlerC.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            connector.getResponses("GET / HTTP/1.0\nHost: localhost\n\n");
            Assert.assertFalse((boolean)handlerA.isHandled());
            Assert.assertFalse((boolean)handlerB.isHandled());
            Assert.assertTrue((boolean)handlerC.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            connectorN.getResponses("GET / HTTP/1.0\nHost: www.example.com.\n\n");
            Assert.assertTrue((boolean)handlerA.isHandled());
            Assert.assertFalse((boolean)handlerB.isHandled());
            Assert.assertFalse((boolean)handlerC.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
            connectorN.getResponses("GET / HTTP/1.0\nHost: localhost\n\n");
            Assert.assertFalse((boolean)handlerA.isHandled());
            Assert.assertTrue((boolean)handlerB.isHandled());
            Assert.assertFalse((boolean)handlerC.isHandled());
            handlerA.reset();
            handlerB.reset();
            handlerC.reset();
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testContextGetContext() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ContextHandler rootA = new ContextHandler((HandlerContainer)contexts, "/");
        ContextHandler fooA = new ContextHandler((HandlerContainer)contexts, "/foo");
        ContextHandler foobarA = new ContextHandler((HandlerContainer)contexts, "/foo/bar");
        server.start();
        Assert.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/"));
        Assert.assertEquals((Object)fooA._scontext, (Object)rootA._scontext.getContext("/foo"));
        Assert.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar"));
        Assert.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar/bob.jsp"));
        Assert.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/other"));
        Assert.assertEquals((Object)fooA._scontext, (Object)rootA._scontext.getContext("/foo/other"));
        Assert.assertEquals((Object)rootA._scontext, (Object)foobarA._scontext.getContext("/"));
        Assert.assertEquals((Object)fooA._scontext, (Object)foobarA._scontext.getContext("/foo"));
        Assert.assertEquals((Object)foobarA._scontext, (Object)foobarA._scontext.getContext("/foo/bar"));
        Assert.assertEquals((Object)foobarA._scontext, (Object)foobarA._scontext.getContext("/foo/bar/bob.jsp"));
        Assert.assertEquals((Object)rootA._scontext, (Object)foobarA._scontext.getContext("/other"));
        Assert.assertEquals((Object)fooA._scontext, (Object)foobarA._scontext.getContext("/foo/other"));
    }

    @Test
    public void testLifeCycle() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ContextHandler root = new ContextHandler((HandlerContainer)contexts, "/");
        root.setHandler((Handler)new ContextPathHandler());
        ContextHandler foo = new ContextHandler((HandlerContainer)contexts, "/foo");
        foo.setHandler((Handler)new ContextPathHandler());
        ContextHandler foobar = new ContextHandler((HandlerContainer)contexts, "/foo/bar");
        foobar.setHandler((Handler)new ContextPathHandler());
        server.start();
        Assert.assertThat((Object)connector.getResponses("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo/bar'"));
        foobar.stop();
        Assert.assertThat((Object)connector.getResponses("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        foo.shutdown().get();
        Assert.assertThat((Object)connector.getResponses("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"503"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"503"));
        foo.stop();
        Assert.assertThat((Object)connector.getResponses("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        foo.start();
        Assert.assertThat((Object)connector.getResponses("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        foobar.start();
        Assert.assertThat((Object)connector.getResponses("GET / HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx=''"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo'"));
        Assert.assertThat((Object)connector.getResponses("GET /foo/bar/xxx HTTP/1.0\n\n"), (Matcher)Matchers.containsString((String)"ctx='/foo/bar'"));
    }

    @Test
    public void testContextVirtualGetContext() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ContextHandler rootA = new ContextHandler((HandlerContainer)contexts, "/");
        rootA.setVirtualHosts(new String[]{"a.com"});
        ContextHandler rootB = new ContextHandler((HandlerContainer)contexts, "/");
        rootB.setVirtualHosts(new String[]{"b.com"});
        ContextHandler rootC = new ContextHandler((HandlerContainer)contexts, "/");
        rootC.setVirtualHosts(new String[]{"c.com"});
        ContextHandler fooA = new ContextHandler((HandlerContainer)contexts, "/foo");
        fooA.setVirtualHosts(new String[]{"a.com"});
        ContextHandler fooB = new ContextHandler((HandlerContainer)contexts, "/foo");
        fooB.setVirtualHosts(new String[]{"b.com"});
        ContextHandler foobarA = new ContextHandler((HandlerContainer)contexts, "/foo/bar");
        foobarA.setVirtualHosts(new String[]{"a.com"});
        server.start();
        Assert.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/"));
        Assert.assertEquals((Object)fooA._scontext, (Object)rootA._scontext.getContext("/foo"));
        Assert.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar"));
        Assert.assertEquals((Object)foobarA._scontext, (Object)rootA._scontext.getContext("/foo/bar/bob"));
        Assert.assertEquals((Object)rootA._scontext, (Object)rootA._scontext.getContext("/other"));
        Assert.assertEquals((Object)rootB._scontext, (Object)rootB._scontext.getContext("/other"));
        Assert.assertEquals((Object)rootC._scontext, (Object)rootC._scontext.getContext("/other"));
        Assert.assertEquals((Object)fooB._scontext, (Object)rootB._scontext.getContext("/foo/other"));
        Assert.assertEquals((Object)rootC._scontext, (Object)rootC._scontext.getContext("/foo/other"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHostWildcard() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.setConnectors(new Connector[]{connector});
        ContextHandler context = new ContextHandler("/");
        IsHandledHandler handler = new IsHandledHandler();
        context.setHandler((Handler)handler);
        server.setHandler((Handler)context);
        try {
            server.start();
            this.checkWildcardHost(true, server, null, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{null}, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(true, server, new String[]{"example.com", "*.example.com"}, new String[]{"example.com", ".example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{"example.com", "*.example.com"}, new String[]{"badexample.com", ".badexample.com", "vhost.badexample.com"});
            this.checkWildcardHost(false, server, new String[]{"*."}, new String[]{"anything.anything"});
            this.checkWildcardHost(true, server, new String[]{"*.example.com"}, new String[]{"vhost.example.com", ".example.com"});
            this.checkWildcardHost(false, server, new String[]{"*.example.com"}, new String[]{"vhost.www.example.com", "example.com", "www.vhost.example.com"});
            this.checkWildcardHost(true, server, new String[]{"*.sub.example.com"}, new String[]{"vhost.sub.example.com", ".sub.example.com"});
            this.checkWildcardHost(false, server, new String[]{"*.sub.example.com"}, new String[]{".example.com", "sub.example.com", "vhost.example.com"});
            this.checkWildcardHost(false, server, new String[]{"example.*.com", "example.com.*"}, new String[]{"example.vhost.com", "example.com.vhost", "example.com"});
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testVirtualHostManagement() throws Exception {
        ContextHandler context = new ContextHandler("/");
        context.setVirtualHosts(new String[]{"www.example.com"});
        Assert.assertEquals((long)1L, (long)context.getVirtualHosts().length);
        context.addVirtualHosts(new String[]{"www.example2.com", "www.example3.com"});
        Assert.assertEquals((long)3L, (long)context.getVirtualHosts().length);
        context.addVirtualHosts(new String[]{"www.example.com"});
        Assert.assertEquals((long)3L, (long)context.getVirtualHosts().length);
        context.removeVirtualHosts(new String[]{"www.example3.com"});
        Assert.assertEquals((long)2L, (long)context.getVirtualHosts().length);
        context.removeVirtualHosts(new String[]{"www.example3.com"});
        Assert.assertEquals((long)2L, (long)context.getVirtualHosts().length);
        context.removeVirtualHosts(new String[]{"www.example.com", "www.example2.com"});
        Assert.assertEquals(null, (Object[])context.getVirtualHosts());
    }

    @Test
    public void testAttributes() throws Exception {
        ContextHandler handler = new ContextHandler();
        handler.setAttribute("aaa", (Object)"111");
        Assert.assertEquals((Object)"111", (Object)handler.getServletContext().getAttribute("aaa"));
        Assert.assertEquals(null, (Object)handler.getAttribute("bbb"));
        handler.start();
        handler.getServletContext().setAttribute("aaa", (Object)"000");
        handler.setAttribute("ccc", (Object)"333");
        handler.getServletContext().setAttribute("ddd", (Object)"444");
        Assert.assertEquals((Object)"111", (Object)handler.getServletContext().getAttribute("aaa"));
        Assert.assertEquals(null, (Object)handler.getServletContext().getAttribute("bbb"));
        handler.getServletContext().setAttribute("bbb", (Object)"222");
        Assert.assertEquals((Object)"333", (Object)handler.getServletContext().getAttribute("ccc"));
        Assert.assertEquals((Object)"444", (Object)handler.getServletContext().getAttribute("ddd"));
        Assert.assertEquals((Object)"111", (Object)handler.getAttribute("aaa"));
        Assert.assertEquals(null, (Object)handler.getAttribute("bbb"));
        Assert.assertEquals((Object)"333", (Object)handler.getAttribute("ccc"));
        Assert.assertEquals(null, (Object)handler.getAttribute("ddd"));
        handler.stop();
        Assert.assertEquals((Object)"111", (Object)handler.getServletContext().getAttribute("aaa"));
        Assert.assertEquals(null, (Object)handler.getServletContext().getAttribute("bbb"));
        Assert.assertEquals((Object)"333", (Object)handler.getServletContext().getAttribute("ccc"));
        Assert.assertEquals(null, (Object)handler.getServletContext().getAttribute("ddd"));
    }

    @Test
    public void testProtected() throws Exception {
        ContextHandler handler = new ContextHandler();
        String[] protectedTargets = new String[]{"/foo-inf", "/bar-inf"};
        handler.setProtectedTargets(protectedTargets);
        Assert.assertTrue((boolean)handler.isProtectedTarget("/foo-inf/x/y/z"));
        Assert.assertFalse((boolean)handler.isProtectedTarget("/foo/x/y/z"));
        Assert.assertTrue((boolean)handler.isProtectedTarget("/foo-inf?x=y&z=1"));
        Assert.assertFalse((boolean)handler.isProtectedTarget("/foo-inf-bar"));
        protectedTargets = new String[4];
        System.arraycopy(handler.getProtectedTargets(), 0, protectedTargets, 0, 2);
        protectedTargets[2] = "/abc";
        protectedTargets[3] = "/def";
        handler.setProtectedTargets(protectedTargets);
        Assert.assertTrue((boolean)handler.isProtectedTarget("/foo-inf/x/y/z"));
        Assert.assertFalse((boolean)handler.isProtectedTarget("/foo/x/y/z"));
        Assert.assertTrue((boolean)handler.isProtectedTarget("/foo-inf?x=y&z=1"));
        Assert.assertTrue((boolean)handler.isProtectedTarget("/abc/124"));
        Assert.assertTrue((boolean)handler.isProtectedTarget("//def"));
        Assert.assertTrue((boolean)handler.isProtectedTarget("/ABC/7777"));
    }

    private void checkResourcePathsForExampleWebApp(String root) throws IOException {
        File testDirectory = this.setupTestDirectory();
        ContextHandler handler = new ContextHandler();
        Assert.assertTrue((String)("Not a directory " + testDirectory), (boolean)testDirectory.isDirectory());
        handler.setBaseResource(Resource.newResource((URL)Resource.toURL((File)testDirectory)));
        ArrayList paths = new ArrayList(handler.getResourcePaths(root));
        Assert.assertEquals((long)2L, (long)paths.size());
        Collections.sort(paths);
        Assert.assertEquals((Object)"/WEB-INF/jsp/", paths.get(0));
        Assert.assertEquals((Object)"/WEB-INF/web.xml", paths.get(1));
    }

    private File setupTestDirectory() throws IOException {
        File tmpDir = new File(System.getProperty("basedir", ".") + "/target/tmp/ContextHandlerTest");
        if (!(tmpDir = tmpDir.getCanonicalFile()).exists()) {
            Assert.assertTrue((boolean)tmpDir.mkdirs());
        }
        File tmp = File.createTempFile("cht", null, tmpDir);
        Assert.assertTrue((boolean)tmp.delete());
        Assert.assertTrue((boolean)tmp.mkdir());
        tmp.deleteOnExit();
        File root = new File(tmp, this.getClass().getName());
        Assert.assertTrue((boolean)root.mkdir());
        File webInf = new File(root, "WEB-INF");
        Assert.assertTrue((boolean)webInf.mkdir());
        Assert.assertTrue((boolean)new File(webInf, "jsp").mkdir());
        Assert.assertTrue((boolean)new File(webInf, "web.xml").createNewFile());
        return root;
    }

    private void checkWildcardHost(boolean succeed, Server server, String[] contextHosts, String[] requestHosts) throws Exception {
        LocalConnector connector = (LocalConnector)server.getConnectors()[0];
        ContextHandler context = (ContextHandler)server.getHandler();
        context.setVirtualHosts(contextHosts);
        IsHandledHandler handler = (IsHandledHandler)context.getHandler();
        for (String host : requestHosts) {
            connector.getResponses("GET / HTTP/1.1\nHost: " + host + "\nConnection:close\n\n");
            if (succeed) {
                Assert.assertTrue((String)("'" + host + "' should have been handled."), (boolean)handler.isHandled());
            } else {
                Assert.assertFalse((String)("'" + host + "' should not have been handled."), (boolean)handler.isHandled());
            }
            handler.reset();
        }
    }

    private static final class ContextPathHandler
    extends AbstractHandler {
        private ContextPathHandler() {
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.setContentType("text/plain; charset=utf-8");
            response.setHeader("Connection", "close");
            PrintWriter writer = response.getWriter();
            writer.println("ctx='" + request.getContextPath() + "'");
        }
    }

    private static final class IsHandledHandler
    extends AbstractHandler {
        private boolean handled;

        private IsHandledHandler() {
        }

        public boolean isHandled() {
            return this.handled;
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            this.handled = true;
        }

        public void reset() {
            this.handled = false;
        }
    }
}

