/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.junit.Assert;
import org.junit.Test;

public class ShutdownMonitorTest {
    @Test
    public void testShutdown() throws Exception {
        ShutdownMonitor.getInstance().setPort(0);
        ShutdownMonitor.getInstance().setExitVm(false);
        ShutdownMonitor.getInstance().start();
        String key = ShutdownMonitor.getInstance().getKey();
        int port = ShutdownMonitor.getInstance().getPort();
        ShutdownMonitor.getInstance().start();
        this.stop(port, key, true);
        Assert.assertTrue((!ShutdownMonitor.getInstance().isAlive() ? 1 : 0) != 0);
        ShutdownMonitor.getInstance().setPort(0);
        ShutdownMonitor.getInstance().setKey("foo");
        ShutdownMonitor.getInstance().start();
        key = ShutdownMonitor.getInstance().getKey();
        port = ShutdownMonitor.getInstance().getPort();
        Assert.assertTrue((boolean)ShutdownMonitor.getInstance().isAlive());
        this.stop(port, key, true);
        Assert.assertTrue((!ShutdownMonitor.getInstance().isAlive() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int port, String key, boolean check) throws Exception {
        block5: {
            try (Socket s = null;){
                s = new Socket(InetAddress.getByName("127.0.0.1"), port);
                OutputStream out = s.getOutputStream();
                out.write((key + "\r\nstop\r\n").getBytes());
                out.flush();
                if (!check) break block5;
                Thread.currentThread();
                Thread.sleep(600L);
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                String response = lin.readLine();
                if (response != null) {
                    Assert.assertEquals((Object)"Stopped", (Object)response);
                    break block5;
                }
                throw new IllegalStateException("No stop confirmation");
            }
        }
    }
}

