/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ByteBufferHttpInput;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.HashedSession;
import org.eclipse.jetty.util.BlockingCallback;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResponseTest {
    private Server _server;
    private HttpChannel<ByteBuffer> _channel;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        TimerScheduler _scheduler = new TimerScheduler();
        HttpConfiguration config = new HttpConfiguration();
        LocalConnector connector = new LocalConnector(this._server, null, (Scheduler)_scheduler, null, 1, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        this._server.addConnector((Connector)connector);
        this._server.setHandler((Handler)new DumpHandler());
        this._server.start();
        ByteArrayEndPoint endp = new ByteArrayEndPoint((Scheduler)_scheduler, 5000L);
        ByteBufferHttpInput input = new ByteBufferHttpInput();
        this._channel = new HttpChannel((Connector)connector, new HttpConfiguration(), (EndPoint)endp, new HttpTransport(){

            public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent) throws IOException {
                BlockingCallback cb = new BlockingCallback();
                this.send(info, content, lastContent, (Callback)cb);
                cb.block();
            }

            public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent, Callback callback) {
                callback.succeeded();
            }

            public void send(ByteBuffer responseBodyContent, boolean lastContent, Callback callback) {
                this.send(null, responseBodyContent, lastContent, callback);
            }

            public void completed() {
            }
        }, (HttpInput)input);
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testContentType() throws Exception {
        Response response = this.newResponse();
        Assert.assertEquals(null, (Object)response.getContentType());
        response.setHeader("Content-Type", "text/something");
        Assert.assertEquals((Object)"text/something", (Object)response.getContentType());
        response.setContentType("foo/bar");
        Assert.assertEquals((Object)"foo/bar", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar;charset=ISO-8859-1", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=ISO-8859-1", (Object)response.getContentType());
        response.setHeader("name", "foo");
        Iterator en = response.getHeaders("name").iterator();
        Assert.assertEquals((Object)"foo", en.next());
        Assert.assertFalse((boolean)en.hasNext());
        response.addHeader("name", "bar");
        en = response.getHeaders("name").iterator();
        Assert.assertEquals((Object)"foo", en.next());
        Assert.assertEquals((Object)"bar", en.next());
        Assert.assertFalse((boolean)en.hasNext());
        response.recycle();
        response.setContentType("text/html");
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html;charset=ISO-8859-1", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=ISO-8859-1", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/xml;charset=ISO-8859-7");
        response.getWriter();
        response.setContentType("text/html;charset=UTF-8");
        Assert.assertEquals((Object)"text/html;charset=ISO-8859-7", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/html;charset=US-ASCII");
        response.getWriter();
        Assert.assertEquals((Object)"text/html;charset=US-ASCII", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/json");
        response.getWriter();
        Assert.assertEquals((Object)"text/json;charset=UTF-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setContentType("foo/bar");
        Assert.assertEquals((Object)"foo/bar;charset=xyz", (Object)response.getContentType());
        response.recycle();
        response.setContentType("foo/bar");
        response.setCharacterEncoding("xyz");
        Assert.assertEquals((Object)"foo/bar;charset=xyz", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setContentType("foo/bar;charset=abc");
        Assert.assertEquals((Object)"foo/bar;charset=abc", (Object)response.getContentType());
        response.recycle();
        response.setContentType("foo/bar;charset=abc");
        response.setCharacterEncoding("xyz");
        Assert.assertEquals((Object)"foo/bar;charset=xyz", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setContentType("foo/bar");
        response.setCharacterEncoding(null);
        Assert.assertEquals((Object)"foo/bar", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("xyz");
        response.setCharacterEncoding(null);
        response.setContentType("foo/bar");
        Assert.assertEquals((Object)"foo/bar", (Object)response.getContentType());
        response.recycle();
        response.addHeader("Content-Type", "text/something");
        Assert.assertEquals((Object)"text/something", (Object)response.getContentType());
    }

    @Test
    public void testLocale() throws Exception {
        Response response = this.newResponse();
        ContextHandler context = new ContextHandler();
        context.addLocaleEncoding(Locale.ENGLISH.toString(), "ISO-8859-1");
        context.addLocaleEncoding(Locale.ITALIAN.toString(), "ISO-8859-2");
        response.getHttpChannel().getRequest().setContext(context.getServletContext());
        response.setLocale(Locale.ITALIAN);
        Assert.assertEquals(null, (Object)response.getContentType());
        response.setContentType("text/plain");
        Assert.assertEquals((Object)"text/plain;charset=ISO-8859-2", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/plain");
        response.setCharacterEncoding("utf-8");
        response.setLocale(Locale.ITALIAN);
        Assert.assertEquals((Object)"text/plain;charset=UTF-8", (Object)response.getContentType());
        Assert.assertTrue((response.toString().indexOf("charset=UTF-8") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContentTypeCharacterEncoding() throws Exception {
        Response response = this.newResponse();
        response.setContentType("foo/bar");
        response.setCharacterEncoding("utf-8");
        Assert.assertEquals((Object)"foo/bar;charset=UTF-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar;charset=UTF-8", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=UTF-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assert.assertEquals((Object)"foo2/bar2;charset=UTF-8", (Object)response.getContentType());
        response.recycle();
        response.setContentType("text/html");
        response.setCharacterEncoding("utf-8");
        Assert.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
    }

    @Test
    public void testCharacterEncodingContentType() throws Exception {
        Response response = this.newResponse();
        response.setCharacterEncoding("utf-8");
        response.setContentType("foo/bar");
        Assert.assertEquals((Object)"foo/bar;charset=UTF-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar;charset=UTF-8", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=UTF-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assert.assertEquals((Object)"foo2/bar2;charset=UTF-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        Assert.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
        response.setCharacterEncoding("iso-8859-1");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
    }

    @Test
    public void testContentTypeWithCharacterEncoding() throws Exception {
        Response response = this.newResponse();
        response.setCharacterEncoding("utf16");
        response.setContentType("foo/bar; charset=utf-8");
        Assert.assertEquals((Object)"foo/bar; charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar; charset=utf-8", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=UTF-8", (Object)response.getContentType());
        response.setCharacterEncoding("ISO-8859-1");
        Assert.assertEquals((Object)"foo2/bar2;charset=UTF-8", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf16");
        response.setContentType("text/html; charset=utf-8");
        Assert.assertEquals((Object)"text/html; charset=utf-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html; charset=utf-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
        response.setCharacterEncoding("iso-8859-1");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
    }

    @Test
    public void testContentTypeWithOther() throws Exception {
        Response response = this.newResponse();
        response.setContentType("foo/bar; other=xyz");
        Assert.assertEquals((Object)"foo/bar; other=xyz", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar; other=xyz;charset=ISO-8859-1", (Object)response.getContentType());
        response.setContentType("foo2/bar2");
        Assert.assertEquals((Object)"foo2/bar2;charset=ISO-8859-1", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html; other=xyz");
        Assert.assertEquals((Object)"text/html; other=xyz;charset=UTF-8", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html; other=xyz;charset=UTF-8", (Object)response.getContentType());
        response.setContentType("text/xml");
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)response.getContentType());
    }

    @Test
    public void testContentTypeWithCharacterEncodingAndOther() throws Exception {
        Response response = this.newResponse();
        response.setCharacterEncoding("utf16");
        response.setContentType("foo/bar; charset=utf-8 other=xyz");
        Assert.assertEquals((Object)"foo/bar; charset=utf-8 other=xyz", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar; charset=utf-8 other=xyz", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf16");
        response.setContentType("text/html; other=xyz charset=utf-8");
        Assert.assertEquals((Object)"text/html; other=xyz charset=utf-8;charset=UTF-16", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"text/html; other=xyz charset=utf-8;charset=UTF-16", (Object)response.getContentType());
        response.recycle();
        response.setCharacterEncoding("utf16");
        response.setContentType("foo/bar; other=pq charset=utf-8 other=xyz");
        Assert.assertEquals((Object)"foo/bar; other=pq charset=utf-8 other=xyz;charset=UTF-16", (Object)response.getContentType());
        response.getWriter();
        Assert.assertEquals((Object)"foo/bar; other=pq charset=utf-8 other=xyz;charset=UTF-16", (Object)response.getContentType());
    }

    @Test
    public void testStatusCodes() throws Exception {
        Response response = this.newResponse();
        response.sendError(404);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals(null, (Object)response.getReason());
        response = this.newResponse();
        response.sendError(500, "Database Error");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)"Database Error", (Object)response.getReason());
        Assert.assertEquals((Object)"must-revalidate,no-cache,no-store", (Object)response.getHeader(HttpHeader.CACHE_CONTROL.asString()));
        response = this.newResponse();
        response.setStatus(200);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(null, (Object)response.getReason());
        response = this.newResponse();
        response.sendError(406, "Super Nanny");
        Assert.assertEquals((long)406L, (long)response.getStatus());
        Assert.assertEquals((Object)"Super Nanny", (Object)response.getReason());
        Assert.assertEquals((Object)"must-revalidate,no-cache,no-store", (Object)response.getHeader(HttpHeader.CACHE_CONTROL.asString()));
    }

    @Test
    public void testEncodeRedirect() throws Exception {
        Response response = this.newResponse();
        Request request = response.getHttpChannel().getRequest();
        request.setServerName("myhost");
        request.setServerPort(8888);
        request.setContextPath("/path");
        Assert.assertEquals((Object)"http://myhost:8888/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/path/info;param?query=0&more=1#target"));
        request.setRequestedSessionId("12345");
        request.setRequestedSessionIdFromCookie(false);
        HashSessionManager manager = new HashSessionManager();
        manager.setSessionIdManager((SessionIdManager)new HashSessionIdManager());
        request.setSessionManager((SessionManager)manager);
        request.setSession((HttpSession)new TestSession(manager, "12345"));
        manager.setCheckingRemoteSessionIdEncoding(false);
        Assert.assertEquals((Object)"http://myhost:8888/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://other:8888/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://other:8888/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://myhost/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://myhost:8888/other/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/other/info;param?query=0&more=1#target"));
        manager.setCheckingRemoteSessionIdEncoding(true);
        Assert.assertEquals((Object)"http://myhost:8888/path/info;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://other:8888/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://other:8888/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://myhost/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://myhost/path/info;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://myhost:8888/other/info;param?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/other/info;param?query=0&more=1#target"));
        request.setContextPath("");
        Assert.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888"));
        Assert.assertEquals((Object)"https://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("https://myhost:8888"));
        Assert.assertEquals((Object)"mailto:/foo", (Object)response.encodeURL("mailto:/foo"));
        Assert.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888/"));
        Assert.assertEquals((Object)"http://myhost:8888/;jsessionid=12345", (Object)response.encodeURL("http://myhost:8888/;jsessionid=7777"));
        Assert.assertEquals((Object)"http://myhost:8888/;param;jsessionid=12345?query=0&more=1#target", (Object)response.encodeURL("http://myhost:8888/;param?query=0&more=1#target"));
        Assert.assertEquals((Object)"http://other:8888/path/info;param?query=0&more=1#target", (Object)response.encodeURL("http://other:8888/path/info;param?query=0&more=1#target"));
        manager.setCheckingRemoteSessionIdEncoding(false);
        Assert.assertEquals((Object)"/foo;jsessionid=12345", (Object)response.encodeURL("/foo"));
        Assert.assertEquals((Object)"/;jsessionid=12345", (Object)response.encodeURL("/"));
        Assert.assertEquals((Object)"/foo.html;jsessionid=12345#target", (Object)response.encodeURL("/foo.html#target"));
        Assert.assertEquals((Object)";jsessionid=12345", (Object)response.encodeURL(""));
    }

    @Test
    public void testSendRedirect() throws Exception {
        String[][] tests = new String[][]{{"http://myhost:8888/other/location;jsessionid=12345?name=value", "http://myhost:8888/other/location;jsessionid=12345?name=value"}, {"/other/location;jsessionid=12345?name=value", "http://@HOST@@PORT@/other/location;jsessionid=12345?name=value"}, {"./location;jsessionid=12345?name=value", "http://@HOST@@PORT@/path/location;jsessionid=12345?name=value"}, {"/other/location", "http://@HOST@@PORT@/other/location"}, {"/other/l%20cation", "http://@HOST@@PORT@/other/l%20cation"}, {"location", "http://@HOST@@PORT@/path/location"}, {"./location", "http://@HOST@@PORT@/path/location"}, {"../location", "http://@HOST@@PORT@/location"}, {"/other/l%20cation", "http://@HOST@@PORT@/other/l%20cation"}, {"l%20cation", "http://@HOST@@PORT@/path/l%20cation"}, {"./l%20cation", "http://@HOST@@PORT@/path/l%20cation"}, {"../l%20cation", "http://@HOST@@PORT@/l%20cation"}, {"../locati%C3%abn", "http://@HOST@@PORT@/locati%C3%ABn"}, {"http://somehost.com/other/location", "http://somehost.com/other/location"}};
        int[] ports = new int[]{8080, 80};
        String[] hosts = new String[]{"myhost", "192.168.0.1", "0::1"};
        for (int port : ports) {
            for (String host : hosts) {
                for (int i = 0; i < tests.length; ++i) {
                    Response response = this.newResponse();
                    Request request = response.getHttpChannel().getRequest();
                    request.setServerName(host);
                    request.setServerPort(port);
                    request.setUri(new HttpURI("/path/info;param;jsessionid=12345?query=0&more=1#target"));
                    request.setContextPath("/path");
                    request.setRequestedSessionId("12345");
                    request.setRequestedSessionIdFromCookie(i > 2);
                    HashSessionManager manager = new HashSessionManager();
                    manager.setSessionIdManager((SessionIdManager)new HashSessionIdManager());
                    request.setSessionManager((SessionManager)manager);
                    request.setSession((HttpSession)new TestSession(manager, "12345"));
                    manager.setCheckingRemoteSessionIdEncoding(false);
                    response.sendRedirect(tests[i][0]);
                    String location = response.getHeader("Location");
                    String expected = tests[i][1].replace("@HOST@", host.contains(":") ? "[" + host + "]" : host).replace("@PORT@", port == 80 ? "" : ":" + port);
                    Assert.assertEquals((String)("test-" + i + " " + host + ":" + port), (Object)expected, (Object)location);
                }
            }
        }
    }

    @Test
    public void testSetBufferSizeAfterHavingWrittenContent() throws Exception {
        Response response = this.newResponse();
        response.setBufferSize(20480);
        response.getWriter().print("hello");
        try {
            response.setBufferSize(21504);
            Assert.fail((String)"Expected IllegalStateException on Request.setBufferSize");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalStateException));
        }
    }

    @Test
    public void testZeroContent() throws Exception {
        Response response = this.newResponse();
        PrintWriter writer = response.getWriter();
        response.setContentLength(0);
        Assert.assertTrue((!response.isCommitted() ? 1 : 0) != 0);
        Assert.assertTrue((!writer.checkError() ? 1 : 0) != 0);
        writer.print("");
        Assert.assertTrue((!writer.checkError() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isCommitted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHead() throws Exception {
        Server server = new Server(0);
        try {
            server.setHandler((Handler)new AbstractHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    response.setStatus(200);
                    response.setContentType("text/plain");
                    PrintWriter w = response.getWriter();
                    w.flush();
                    w.println("Geht");
                    w.flush();
                    w.println("Doch");
                    w.flush();
                    ((Request)request).setHandled(true);
                }
            });
            server.start();
            Socket socket = new Socket("localhost", ((NetworkConnector)server.getConnectors()[0]).getLocalPort());
            socket.setSoTimeout(500000);
            socket.getOutputStream().write("HEAD / HTTP/1.1\r\nHost: localhost\r\n\r\n".getBytes());
            socket.getOutputStream().write("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n".getBytes());
            socket.getOutputStream().flush();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
            String line = reader.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            while (line != null && line.length() > 0) {
                line = reader.readLine();
            }
            line = reader.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            String last = null;
            while (line != null) {
                last = line;
                line = reader.readLine();
            }
            Assert.assertEquals((Object)"Doch", (Object)last);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testAddCookie() throws Exception {
        Response response = this.newResponse();
        Cookie cookie = new Cookie("name", "value");
        cookie.setDomain("domain");
        cookie.setPath("/path");
        cookie.setSecure(true);
        cookie.setComment("comment__HTTP_ONLY__");
        response.addCookie(cookie);
        String set = response.getHttpFields().getStringField("Set-Cookie");
        Assert.assertEquals((Object)"name=value;Version=1;Path=/path;Domain=domain;Secure;HttpOnly;Comment=comment", (Object)set);
    }

    @Test
    public void testCookiesWithReset() throws Exception {
        Response response = this.newResponse();
        Cookie cookie = new Cookie("name", "value");
        cookie.setDomain("domain");
        cookie.setPath("/path");
        cookie.setSecure(true);
        cookie.setComment("comment__HTTP_ONLY__");
        response.addCookie(cookie);
        Cookie cookie2 = new Cookie("name2", "value2");
        cookie2.setDomain("domain");
        cookie2.setPath("/path");
        response.addCookie(cookie2);
        response.reset(true);
        Enumeration set = response.getHttpFields().getValues("Set-Cookie");
        Assert.assertNotNull((Object)set);
        ArrayList list = Collections.list(set);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("name=value;Version=1;Path=/path;Domain=domain;Secure;HttpOnly;Comment=comment"));
        Assert.assertTrue((boolean)list.contains("name2=value2;Path=/path;Domain=domain"));
        response.reset();
        set = response.getHttpFields().getValues("Set-Cookie");
        Assert.assertFalse((boolean)set.hasMoreElements());
    }

    @Test
    public void testFlushAfterFullContent() throws Exception {
        Response response = this._channel.getResponse();
        byte[] data = new byte[]{-54, -2};
        ServletOutputStream output = response.getOutputStream();
        response.setContentLength(data.length);
        output.write(data);
        output.flush();
    }

    private Response newResponse() {
        this._channel.reset();
        return new Response(this._channel, this._channel.getResponse().getHttpOutput());
    }

    private static class TestSession
    extends HashedSession {
        protected TestSession(HashSessionManager hashSessionManager, String id) {
            super(hashSessionManager, 0L, 0L, id);
        }
    }
}

