/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Exchanger;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpServerTestFixture;
import org.eclipse.jetty.server.QuietServletException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SuspendHandler;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StdErrLog;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public abstract class HttpServerTestBase
extends HttpServerTestFixture {
    private static final String REQUEST1_HEADER = "POST / HTTP/1.0\nHost: localhost\nContent-Type: text/xml; charset=utf-8\nConnection: close\nContent-Length: ";
    private static final String REQUEST1_CONTENT = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n</nimbus>";
    private static final String REQUEST1 = "POST / HTTP/1.0\nHost: localhost\nContent-Type: text/xml; charset=utf-8\nConnection: close\nContent-Length: " + "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n</nimbus>".getBytes().length + "\n\n" + "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n</nimbus>";
    private static final String RESPONSE1 = "HTTP/1.1 200 OK\nContent-Length: 13\nServer: Jetty(" + Server.getVersion() + ")\n" + "\n" + "Hello world\n";
    private static final String FRAGMENT1 = REQUEST1.substring(0, 16);
    private static final String FRAGMENT2 = REQUEST1.substring(16, 34);
    private static final String FRAGMENT3 = REQUEST1.substring(34);
    protected static final String REQUEST2_HEADER = "POST / HTTP/1.0\nHost: localhost\nContent-Type: text/xml; charset=ISO-8859-1\nContent-Length: ";
    protected static final String REQUEST2_CONTENT = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>";
    protected static final String REQUEST2 = "POST / HTTP/1.0\nHost: localhost\nContent-Type: text/xml; charset=ISO-8859-1\nContent-Length: " + "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>".getBytes().length + "\n\n" + "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>";
    protected static final String RESPONSE2_CONTENT = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>\n";
    protected static final String RESPONSE2 = "HTTP/1.1 200 OK\nContent-Type: text/xml; charset=ISO-8859-1\nContent-Length: " + "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>\n".getBytes().length + "\n" + "Server: Jetty(" + Server.getVersion() + ")\n" + "\n" + "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>\n";

    @Test
    public void testSimple() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write("GET / HTTP/1.0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello world"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullMethod() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            ((StdErrLog)Log.getLogger(HttpConnection.class)).setHideStacks(true);
            ((StdErrLog)Log.getLogger(HttpConnection.class)).info("expect request is too large, then ISE extra data ...", new Object[0]);
            OutputStream os = client.getOutputStream();
            byte[] buffer = new byte[65536];
            Arrays.fill(buffer, (byte)65);
            os.write(buffer);
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 413 "));
        }
        finally {
            ((StdErrLog)Log.getLogger(HttpConnection.class)).setHideStacks(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullURI() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            ((StdErrLog)Log.getLogger(HttpConnection.class)).setHideStacks(true);
            ((StdErrLog)Log.getLogger(HttpConnection.class)).info("expect URI is too large, then ISE extra data ...", new Object[0]);
            OutputStream os = client.getOutputStream();
            byte[] buffer = new byte[65536];
            buffer[0] = 71;
            buffer[1] = 69;
            buffer[2] = 84;
            buffer[3] = 32;
            buffer[4] = 47;
            Arrays.fill(buffer, 5, buffer.length - 1, (byte)65);
            os.write(buffer);
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 414 "));
        }
        finally {
            ((StdErrLog)Log.getLogger(HttpConnection.class)).setHideStacks(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionThrownInHandler() throws Exception {
        this.configureServer((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                throw new QuietServletException("TEST handler exception");
            }
        });
        StringBuffer request = new StringBuffer("GET / HTTP/1.0\r\n");
        request.append("Host: localhost\r\n\r\n");
        Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        OutputStream os = client.getOutputStream();
        try {
            ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(true);
            Log.getLogger(HttpChannel.class).info("Expecting ServletException: TEST handler exception...", new Object[0]);
            os.write(request.toString().getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assert.assertThat((String)"response code is 500", (Object)response.contains("500"), (Matcher)Matchers.is((Object)true));
        }
        finally {
            ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(false);
        }
    }

    @Test
    public void testInterruptedRequest() throws Exception {
        final AtomicBoolean fourBytesRead = new AtomicBoolean(false);
        final AtomicBoolean earlyEOFException = new AtomicBoolean(false);
        this.configureServer((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                int contentLength = request.getContentLength();
                ServletInputStream inputStream = request.getInputStream();
                for (int i = 0; i < contentLength; ++i) {
                    try {
                        inputStream.read();
                    }
                    catch (EofException e) {
                        earlyEOFException.set(true);
                        throw e;
                    }
                    if (i != 3) continue;
                    fourBytesRead.set(true);
                }
            }
        });
        StringBuffer request = new StringBuffer("GET / HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("Content-length: 6\n\n");
        request.append("foo");
        Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        OutputStream os = client.getOutputStream();
        os.write(request.toString().getBytes());
        os.flush();
        client.shutdownOutput();
        String response = HttpServerTestBase.readResponse(client);
        client.close();
        Assert.assertThat((String)"response contains 500", (Object)response, (Matcher)Matchers.containsString((String)" 500 "));
        Assert.assertThat((String)"The 4th byte (-1) has not been passed to the handler", (Object)fourBytesRead.get(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((String)"EofException has been caught", (Object)earlyEOFException.get(), (Matcher)Matchers.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullHeader() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            ((StdErrLog)Log.getLogger(HttpConnection.class)).setHideStacks(true);
            ((StdErrLog)Log.getLogger(HttpConnection.class)).info("expect header is too large, then ISE extra data ...", new Object[0]);
            OutputStream os = client.getOutputStream();
            byte[] buffer = new byte[65536];
            buffer[0] = 71;
            buffer[1] = 69;
            buffer[2] = 84;
            buffer[3] = 32;
            buffer[4] = 47;
            buffer[5] = 32;
            buffer[6] = 72;
            buffer[7] = 84;
            buffer[8] = 84;
            buffer[9] = 80;
            buffer[10] = 47;
            buffer[11] = 49;
            buffer[12] = 46;
            buffer[13] = 48;
            buffer[14] = 10;
            buffer[15] = 72;
            buffer[16] = 58;
            Arrays.fill(buffer, 17, buffer.length - 1, (byte)65);
            os.write(buffer);
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 413 "));
        }
        finally {
            ((StdErrLog)Log.getLogger(HttpConnection.class)).setHideStacks(true);
        }
    }

    @Test
    public void testRequest1() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write(REQUEST1.getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assert.assertEquals((String)"response", (Object)RESPONSE1, (Object)response);
        }
    }

    @Test
    public void testFragmentedChunk() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write("GET /R2 HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\n".getBytes());
            os.flush();
            Thread.sleep(10L);
            os.write("5\r\n".getBytes());
            os.flush();
            Thread.sleep(10L);
            os.write("ABCDE\r\n0;\r\n\r\n".getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTrailingContent() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write("GET /R2 HTTP/1.1\r\nHost: localhost\r\nContent-Length: 5\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\nABCDE\r\n\r\n".getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRequest1Fragments() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write(FRAGMENT1.getBytes());
            os.flush();
            Thread.sleep(10L);
            os.write(FRAGMENT2.getBytes());
            os.flush();
            Thread.sleep(10L);
            os.write(FRAGMENT3.getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assert.assertEquals((String)"response", (Object)RESPONSE1, (Object)response);
        }
    }

    @Test
    public void testRequest2() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        byte[] bytes = REQUEST2.getBytes();
        for (int i = 0; i < LOOPS; ++i) {
            try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
                OutputStream os = client.getOutputStream();
                os.write(bytes);
                os.flush();
                String response = HttpServerTestBase.readResponse(client);
                Assert.assertEquals((String)("response " + i), (Object)RESPONSE2, (Object)response);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                this._server.dumpStdErr();
                throw e;
            }
        }
    }

    @Test
    public void testRequest2Fragments() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        byte[] bytes = REQUEST2.getBytes();
        int pointCount = 2;
        Random random = new Random(System.currentTimeMillis());
        for (int i = 0; i < LOOPS; ++i) {
            int[] points = new int[2];
            StringBuilder message = new StringBuilder();
            message.append("iteration #").append(i + 1);
            for (int j = 0; j < points.length; ++j) {
                points[j] = random.nextInt(bytes.length);
            }
            Arrays.sort(points);
            try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
                OutputStream os = client.getOutputStream();
                this.writeFragments(bytes, points, message, os);
                String response = HttpServerTestBase.readResponse(client);
                Assert.assertEquals((String)("response for " + i + " " + message.toString()), (Object)RESPONSE2, (Object)response);
                continue;
            }
        }
    }

    @Test
    public void testRequest2Iterate() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        byte[] bytes = REQUEST2.getBytes();
        for (int i = 0; i < bytes.length; i += 3) {
            int[] points = new int[]{i};
            StringBuilder message = new StringBuilder();
            message.append("iteration #").append(i + 1);
            Arrays.sort(points);
            try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
                OutputStream os = client.getOutputStream();
                this.writeFragments(bytes, points, message, os);
                String response = HttpServerTestBase.readResponse(client);
                Assert.assertEquals((String)("response for " + i + " " + message.toString()), (Object)RESPONSE2, (Object)response);
                continue;
            }
        }
    }

    @Test
    public void testFlush() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.DataHandler());
        String[] encoding = new String[]{"NONE", "UTF-8", "ISO-8859-1", "ISO-8859-2"};
        for (int e = 0; e < encoding.length; ++e) {
            int b = 1;
            while (b <= 128) {
                for (int w = 41; w < 42; w += 4096) {
                    for (int c = 0; c < 1; ++c) {
                        String test = encoding[e] + "x" + b + "x" + w + "x" + c;
                        try {
                            URL url = new URL(this._scheme + "://" + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "/?writes=" + w + "&block=" + b + (e == 0 ? "" : "&encoding=" + encoding[e]) + (c == 0 ? "&chars=true" : ""));
                            InputStream in = (InputStream)url.getContent();
                            String response = IO.toString((InputStream)in, e == 0 ? null : encoding[e]);
                            Assert.assertEquals((String)test, (long)(b * w), (long)response.length());
                            continue;
                        }
                        catch (Exception x) {
                            System.err.println(test);
                            x.printStackTrace();
                            throw x;
                        }
                    }
                }
                b = b == 1 ? 2 : (b == 2 ? 32 : (b == 32 ? 128 : 129));
            }
        }
    }

    @Test
    public void testBlockingWhileReadingRequestContent() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.DataHandler());
        long start = System.currentTimeMillis();
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET /data?writes=1024&block=256 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "connection: close\r\n" + "content-type: unknown\r\n" + "content-length: 30\r\n" + "\r\n").getBytes());
            os.flush();
            Thread.sleep(200L);
            os.write("\r\n23456890".getBytes());
            os.flush();
            Thread.sleep(1000L);
            os.write("abcdefghij".getBytes());
            os.flush();
            Thread.sleep(1000L);
            os.write("0987654321\r\n".getBytes());
            os.flush();
            int total = 0;
            int len = 0;
            byte[] buf = new byte[65536];
            int sleeps = 0;
            while (len >= 0) {
                len = is.read(buf);
                if (len <= 0 || (total += len) / 10240 <= sleeps) continue;
                ++sleeps;
                Thread.sleep(100L);
            }
            Assert.assertTrue((total > 262144 ? 1 : 0) != 0);
            Assert.assertTrue((30000L > System.currentTimeMillis() - start ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBlockingWhileWritingResponseContent() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.DataHandler());
        long start = System.currentTimeMillis();
        int total = 0;
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET /data?writes=256&block=1024 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "connection: close\r\n" + "content-type: unknown\r\n" + "\r\n").getBytes());
            os.flush();
            int len = 0;
            byte[] buf = new byte[32768];
            int sleeps = 0;
            while (len >= 0) {
                len = is.read(buf);
                if (len <= 0 || (total += len) / 10240 <= sleeps) continue;
                Thread.sleep(200L);
                ++sleeps;
            }
            Assert.assertTrue((total > 262144 ? 1 : 0) != 0);
            Assert.assertTrue((30000L > System.currentTimeMillis() - start ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCloseWhileWriteBlocked() throws Exception {
        InputStream is;
        OutputStream os;
        this.configureServer((Handler)new HttpServerTestFixture.DataHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            os = client.getOutputStream();
            is = client.getInputStream();
            os.write(("GET /data?encoding=iso-8859-1&writes=100&block=100000 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "connection: close\r\n" + "content-type: unknown\r\n" + "\r\n").getBytes());
            os.flush();
            byte[] buf = new byte[8192];
            is.read(buf);
            Thread.sleep(500L);
            client.close();
        }
        Thread.sleep(200L);
        client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        var2_2 = null;
        try {
            client.setSoTimeout(500);
            os = client.getOutputStream();
            is = client.getInputStream();
            os.write(("GET /data?writes=1&block=1024 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "connection: close\r\n" + "content-type: unknown\r\n" + "\r\n").getBytes());
            os.flush();
            String response = IO.toString((InputStream)is);
            Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var2_2 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable x2) {
                        var2_2.addSuppressed(x2);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    @Test
    public void testBigBlocks() throws Exception {
        this.configureServer((Handler)new BigBlockHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            String line;
            String[] times;
            String line2;
            client.setSoTimeout(20000);
            OutputStream os = client.getOutputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
            os.write(("GET /r1 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "\r\n" + "GET /r2 HTTP/1.1\r\n" + "host: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "connection: close\r\n" + "\r\n").getBytes());
            os.flush();
            boolean chunked = false;
            boolean closed = false;
            while ((line2 = in.readLine()) != null && line2.length() != 0) {
                chunked |= "Transfer-Encoding: chunked".equals(line2);
                closed |= "Connection: close".equals(line2);
            }
            Assert.assertTrue((boolean)chunked);
            Assert.assertFalse((boolean)closed);
            int max = Integer.MIN_VALUE;
            while (true) {
                String chunk = in.readLine();
                String line3 = in.readLine();
                if (line3.length() == 0) break;
                int len = line3.length();
                Assert.assertEquals((long)Integer.valueOf(chunk, 16).intValue(), (long)len);
                if (max >= len) continue;
                max = len;
            }
            Assert.assertEquals((long)131072L, (long)max);
            for (String t : times = in.readLine().split(",")) {
                Assert.assertTrue((Integer.valueOf(t) < 999 ? 1 : 0) != 0);
            }
            String end = in.readLine();
            Assert.assertEquals((Object)"0", (Object)end);
            end = in.readLine();
            Assert.assertEquals((long)0L, (long)end.length());
            chunked = false;
            closed = false;
            while ((line = in.readLine()) != null && line.length() != 0) {
                chunked |= "Transfer-Encoding: chunked".equals(line);
                closed |= "Connection: close".equals(line);
            }
            Assert.assertFalse((boolean)chunked);
            Assert.assertTrue((boolean)closed);
            String bigline = in.readLine();
            Assert.assertEquals((long)0x140000L, (long)bigline.length());
            for (String t : times = in.readLine().split(",")) {
                Assert.assertTrue((String)t, (Integer.valueOf(t) < 999 ? 1 : 0) != 0);
            }
            Assert.assertTrue((in.readLine() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPipeline() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        for (int pipeline = 1; pipeline < 32; ++pipeline) {
            try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
                client.setSoTimeout(5000);
                OutputStream os = client.getOutputStream();
                String request = "";
                for (int i = 1; i < pipeline; ++i) {
                    request = request + "GET /data?writes=1&block=16&id=" + i + " HTTP/1.1\r\n" + "host: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "user-agent: testharness/1.0 (blah foo/bar)\r\n" + "accept-encoding: nothing\r\n" + "cookie: aaa=1234567890\r\n" + "\r\n";
                }
                request = request + "GET /data?writes=1&block=16 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "user-agent: testharness/1.0 (blah foo/bar)\r\n" + "accept-encoding: nothing\r\n" + "cookie: aaa=bbbbbb\r\n" + "Connection: close\r\n" + "\r\n";
                os.write(request.getBytes());
                os.flush();
                LineNumberReader in = new LineNumberReader(new InputStreamReader(client.getInputStream()));
                String line = in.readLine();
                int count = 0;
                while (line != null) {
                    if ("HTTP/1.1 200 OK".equals(line)) {
                        ++count;
                    }
                    line = in.readLine();
                }
                Assert.assertEquals((long)pipeline, (long)count);
                continue;
            }
        }
    }

    @Test
    public void testRecycledWriters() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("POST /echo?charset=utf-8 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: 10\r\n" + "\r\n").getBytes("iso-8859-1"));
            os.write("123456789\n".getBytes("utf-8"));
            os.write(("POST /echo?charset=utf-8 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: 10\r\n" + "\r\n").getBytes("iso-8859-1"));
            os.write("abcdefghZ\n".getBytes("utf-8"));
            String content = "Wibble";
            byte[] contentB = content.getBytes("utf-8");
            os.write(("POST /echo?charset=utf-16 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: " + contentB.length + "\r\n" + "connection: close\r\n" + "\r\n").getBytes("iso-8859-1"));
            os.write(contentB);
            os.flush();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IO.copy((InputStream)is, (OutputStream)bout);
            byte[] b = bout.toByteArray();
            int i = 0;
            while (b[i] != 90) {
                ++i;
            }
            int state = 0;
            block14: while (state != 4) {
                switch (b[i++]) {
                    case 13: {
                        if (state != 0 && state != 2) continue block14;
                        ++state;
                        continue block14;
                    }
                    case 10: {
                        if (state != 1 && state != 3) continue block14;
                        ++state;
                        continue block14;
                    }
                }
                state = 0;
            }
            String in = new String(b, 0, i, StandardCharsets.UTF_8);
            Assert.assertTrue((boolean)in.contains("123456789"));
            Assert.assertTrue((boolean)in.contains("abcdefghZ"));
            Assert.assertFalse((boolean)in.contains("Wibble"));
            in = new String(b, i, b.length - i, StandardCharsets.UTF_16);
            Assert.assertEquals((Object)"Wibble\n", (Object)in);
        }
    }

    @Test
    public void testHead() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler(false));
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("POST /R1 HTTP/1.1\r\nHost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: 10\r\n" + "\r\n" + "123456789\n" + "HEAD /R1 HTTP/1.1\r\n" + "Host: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: 10\r\n" + "\r\n" + "123456789\n" + "POST /R1 HTTP/1.1\r\n" + "Host: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: 10\r\n" + "Connection: close\r\n" + "\r\n" + "123456789\n").getBytes("iso-8859-1"));
            String in = IO.toString((InputStream)is);
            int index = in.indexOf("123456789");
            Assert.assertTrue((index > 0 ? 1 : 0) != 0);
            index = in.indexOf("123456789", index + 1);
            Assert.assertTrue((index > 0 ? 1 : 0) != 0);
            index = in.indexOf("123456789", index + 1);
            Assert.assertTrue((index == -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRecycledReaders() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("POST /echo?charset=utf-8 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: 10\r\n" + "\r\n").getBytes("iso-8859-1"));
            os.write("123456789\n".getBytes("utf-8"));
            os.write(("POST /echo?charset=utf-8 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "content-type: text/plain; charset=utf-8\r\n" + "content-length: 10\r\n" + "\r\n").getBytes("iso-8859-1"));
            os.write("abcdefghi\n".getBytes("utf-8"));
            String content = "Wibble";
            byte[] contentB = content.getBytes("utf-16");
            os.write(("POST /echo?charset=utf-8 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "content-type: text/plain; charset=utf-16\r\n" + "content-length: " + contentB.length + "\r\n" + "connection: close\r\n" + "\r\n").getBytes("iso-8859-1"));
            os.write(contentB);
            os.flush();
            String in = IO.toString((InputStream)is);
            Assert.assertTrue((boolean)in.contains("123456789"));
            Assert.assertTrue((boolean)in.contains("abcdefghi"));
            Assert.assertTrue((boolean)in.contains("Wibble"));
        }
    }

    @Test
    public void testBlockedClient() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET / HTTP/1.1\r\nHost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "Transfer-Encoding: chunked\r\n" + "Expect: 100-continue\r\n" + "Connection: Keep-Alive\r\n" + "\r\n").getBytes());
            os.flush();
            client.setSoTimeout(2000);
            long start = System.currentTimeMillis();
            String in = IO.toString((InputStream)is);
            Assert.assertTrue((System.currentTimeMillis() - start < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((in.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
            Assert.assertTrue((in.indexOf("Hello world") > 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommittedError() throws Exception {
        CommittedErrorHandler handler = new CommittedErrorHandler();
        this.configureServer((Handler)handler);
        Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        try {
            ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(true);
            ((StdErrLog)Log.getLogger(HttpChannel.class)).info("Expecting exception after commit then could not send 500....", new Object[0]);
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET / HTTP/1.1\r\nHost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "\r\n").getBytes());
            os.flush();
            client.setSoTimeout(2000);
            String in = IO.toString((InputStream)is);
            Assert.assertEquals((long)-1L, (long)is.read());
            Assert.assertTrue((boolean)in.contains("HTTP/1.1 200 OK"));
            Assert.assertTrue((in.indexOf("Transfer-Encoding: chunked") > 0 ? 1 : 0) != 0);
            Assert.assertTrue((in.indexOf("Now is the time for all good men to come to the aid of the party") > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)in.contains("\r\n0\r\n"));
            client.close();
            Thread.sleep(200L);
            Assert.assertTrue((!handler._endp.isOpen() ? 1 : 0) != 0);
        }
        finally {
            ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(false);
            if (!client.isClosed()) {
                client.close();
            }
        }
    }

    @Test
    public void testAvailable() throws Exception {
        AvailableHandler ah = new AvailableHandler();
        this.configureServer((Handler)ah);
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET /data?writes=1024&block=256 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "connection: close\r\n" + "content-type: unknown\r\n" + "content-length: 30\r\n" + "\r\n").getBytes());
            os.flush();
            Thread.sleep(500L);
            os.write("1234567890".getBytes());
            os.flush();
            ah._ex.exchange(null);
            os.write("abcdefghijklmnopqrst".getBytes());
            os.flush();
            Thread.sleep(500L);
            ah._ex.exchange(null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while (reader.readLine().length() > 0) {
            }
            Assert.assertThat((Object)Integer.parseInt(reader.readLine()), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)Integer.parseInt(reader.readLine()), (Matcher)Matchers.equalTo((Object)9));
            Assert.assertThat((Object)Integer.parseInt(reader.readLine()), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)Integer.parseInt(reader.readLine()), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            Assert.assertThat((Object)Integer.parseInt(reader.readLine()), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertEquals((Object)"1234567890abcdefghijklmnopqrst", (Object)reader.readLine());
        }
    }

    @Test
    public void testDualRequest1() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client1 = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
             Socket client2 = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os1 = client1.getOutputStream();
            OutputStream os2 = client2.getOutputStream();
            os1.write(REQUEST1.getBytes());
            os2.write(REQUEST1.getBytes());
            os1.flush();
            os2.flush();
            String response1 = HttpServerTestBase.readResponse(client1);
            String response2 = HttpServerTestBase.readResponse(client2);
            Assert.assertEquals((String)"client1", (Object)RESPONSE1, (Object)response1);
            Assert.assertEquals((String)"client2", (Object)RESPONSE1, (Object)response2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String readResponse(Socket client) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(client.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            System.err.println(e + " while reading '" + sb + "'");
            throw e;
        }
    }

    private void writeFragments(byte[] bytes, int[] points, StringBuilder message, OutputStream os) throws IOException, InterruptedException {
        int last = 0;
        for (int j = 0; j < points.length; ++j) {
            int point = points[j];
            os.write(bytes, last, point - last);
            last = point;
            os.flush();
            Thread.sleep(10L);
            message.append(" point #").append(j + 1).append(": ").append(point);
        }
        os.write(bytes, last, bytes.length - last);
        os.flush();
        Thread.sleep(10L);
    }

    @Test
    public void testUnreadInput() throws Exception {
        this.configureServer((Handler)new NoopHandler());
        int REQS = 2;
        char[] fill = new char[66560];
        Arrays.fill(fill, '.');
        String content = "This is a loooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooonnnnnnnnnnnnnnnnggggggggg content" + new String(fill);
        final byte[] bytes = content.getBytes();
        Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        final OutputStream out = client.getOutputStream();
        new Thread(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 2; ++i) {
                        out.write("GET / HTTP/1.1\r\nHost: localhost\r\n".getBytes(StandardCharsets.ISO_8859_1));
                        out.write(("Content-Length: " + bytes.length + "\r\n" + "\r\n").getBytes(StandardCharsets.ISO_8859_1));
                        out.write(bytes, 0, bytes.length);
                    }
                    out.write("GET / HTTP/1.1\r\nHost: last\r\nConnection: close\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
                    out.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        String resps = HttpServerTestBase.readResponse(client);
        int offset = 0;
        for (int i = 0; i < 3; ++i) {
            int ok = resps.indexOf("HTTP/1.1 200 OK", offset);
            Assert.assertThat((String)("resp" + i), (Object)ok, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(offset)));
            offset = ok + 15;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuspendedPipeline() throws Exception {
        SuspendHandler suspend = new SuspendHandler();
        suspend.setSuspendFor(30000L);
        suspend.setResumeAfter(1000L);
        this.configureServer((Handler)suspend);
        long start = System.currentTimeMillis();
        client.setSoTimeout(5000);
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write(("GET / HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "\r\n").getBytes());
            os.flush();
            Thread.sleep(200L);
            os.write(("GET / HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n" + "connection: close\r\n" + "\r\n").getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"RESUMEDHTTP/1.1 200 OK"));
            Assert.assertThat((Object)(System.currentTimeMillis() - start), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1999L)));
        }
    }

    public class NoopHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            response.setStatus(200);
        }
    }

    protected static class AvailableHandler
    extends AbstractHandler {
        public Exchanger<Object> _ex = new Exchanger();

        protected AvailableHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.setContentType("text/plain");
            ServletInputStream in = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            int avail = in.available();
            out.println(avail);
            String buf = "";
            buf = buf + (char)in.read();
            avail = in.available();
            out.println(avail);
            for (int i = 0; i < avail; ++i) {
                buf = buf + (char)in.read();
            }
            avail = in.available();
            out.println(avail);
            try {
                this._ex.exchange(null);
                this._ex.exchange(null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            avail = in.available();
            if (avail == 0) {
                buf = buf + (char)in.read();
                avail = in.available();
                out.println(avail + 1);
            } else if (avail == 1) {
                buf = buf + (char)in.read();
                avail = in.available();
                out.println(avail + 1);
            } else {
                out.println(avail);
            }
            while (avail > 0) {
                buf = buf + (char)in.read();
                avail = in.available();
            }
            out.println(avail);
            int b = in.read();
            while (b >= 0) {
                buf = buf + (char)b;
                b = in.read();
            }
            out.println(buf);
            out.close();
        }
    }

    public static class CommittedErrorHandler
    extends AbstractHandler {
        public EndPoint _endp;

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this._endp = baseRequest.getHttpChannel().getEndPoint();
            response.setHeader("test", "value");
            response.setStatus(200);
            response.setContentType("text/plain");
            response.getWriter().println("Now is the time for all good men to come to the aid of the party");
            response.getWriter().flush();
            response.flushBuffer();
            throw new ServletException((Throwable)new Exception("exception after commit"));
        }
    }

    protected static class BigBlockHandler
    extends AbstractHandler {
        protected BigBlockHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            byte[] buf = new byte[131072];
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_".charAt(i % 63);
            }
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.setContentType("text/plain");
            ServletOutputStream out = response.getOutputStream();
            long[] times = new long[10];
            for (int i = 0; i < times.length; ++i) {
                long start = System.currentTimeMillis();
                out.write(buf);
                long end = System.currentTimeMillis();
                times[i] = end - start;
            }
            out.println();
            for (long t : times) {
                out.print(t);
                out.print(",");
            }
            out.close();
        }
    }
}

