/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StdErrLog;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpConnectionTest {
    private Server server;
    private LocalConnector connector;

    @Before
    public void init() throws Exception {
        this.server = new Server();
        HttpConnectionFactory http = new HttpConnectionFactory();
        http.getHttpConfiguration().setRequestHeaderSize(1024);
        http.getHttpConfiguration().setResponseHeaderSize(1024);
        this.connector = new LocalConnector(this.server, (ConnectionFactory)http, null);
        this.connector.setIdleTimeout(500L);
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler((Handler)new DumpHandler());
        this.server.start();
    }

    @After
    public void destroy() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testFragmentedChunk() throws Exception {
        String response = null;
        try {
            int offset = 0;
            offset = 0;
            response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\nConnection: close\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200");
            offset = this.checkContains(response, offset, "/R1");
            offset = this.checkContains(response, offset, "12345");
            offset = 0;
            response = this.connector.getResponses("GET /R2 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\nConnection: close\n\r\n5;\r\nABCDE\r\n0;\r\n\r\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200");
            offset = this.checkContains(response, offset, "/R2");
            offset = this.checkContains(response, offset, "ABCDE");
        }
        catch (Exception e) {
            if (response != null) {
                System.err.println(response);
            }
            throw e;
        }
    }

    @Test
    public void testNoPath() throws Exception {
        String response = this.connector.getResponses("GET http://localhost:80 HTTP/1.1\nHost: localhost:80\nConnection: close\n\n");
        int offset = 0;
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        this.checkContains(response, offset, "pathInfo=/");
    }

    @Test
    public void testBadNoPath() throws Exception {
        String response = this.connector.getResponses("GET http://localhost:80/../cheat HTTP/1.1\nHost: localhost:80\n\n");
        int offset = 0;
        offset = this.checkContains(response, offset, "HTTP/1.1 400");
    }

    @Test
    public void testOKPathDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET /ooops/../path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 200 OK");
        this.checkContains(response, 0, "pathInfo=/path");
    }

    @Test
    public void testBadPathDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET /ooops/../../path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 400 Bad Request");
    }

    @Test
    public void testOKPathEncodedDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET /ooops/%2e%2e/path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 200 OK");
        this.checkContains(response, 0, "pathInfo=/path");
    }

    @Test
    public void testBadPathEncodedDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET /ooops/%2e%2e/%2e%2e/path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 400 Bad Request");
    }

    @Test
    public void testBadDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET ../path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 400 Bad Request");
    }

    @Test
    public void testBadSlashDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET /../path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 400 Bad Request");
    }

    @Test
    public void testEncodedBadDotDotPath() throws Exception {
        String response = this.connector.getResponses("GET %2e%2e/path HTTP/1.0\nHost: localhost:80\n\n");
        this.checkContains(response, 0, "HTTP/1.1 400 Bad Request");
    }

    @Test
    public void testEmpty() throws Exception {
        String response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\nConnection: close\n\r\n0\r\n\r\n");
        int offset = 0;
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        this.checkContains(response, offset, "/R1");
    }

    @Test
    public void testHead() throws Exception {
        String responsePOST = this.connector.getResponses("POST /R1 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        String responseHEAD = this.connector.getResponses("HEAD /R1 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)responsePOST, (Matcher)Matchers.startsWith((String)responseHEAD.substring(0, responseHEAD.length() - 2)));
        Assert.assertThat((Object)responsePOST.length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(responseHEAD.length())));
        responsePOST = this.connector.getResponses("POST /R1 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)responsePOST, (Matcher)Matchers.startsWith((String)responseHEAD.substring(0, responseHEAD.length() - 2)));
        Assert.assertThat((Object)responsePOST.length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(responseHEAD.length())));
    }

    @Test
    public void testBadHostPort() throws Exception {
        Log.getLogger(HttpParser.class).info("badMessage: Number formate exception expected ...", new Object[0]);
        String response = this.connector.getResponses("GET http://localhost:EXPECTED_NUMBER_FORMAT_EXCEPTION/ HTTP/1.1\nHost: localhost\nConnection: close\r\n\r\n");
        this.checkContains(response, 0, "HTTP/1.1 400");
    }

    @Test
    public void testBadURIencoding() throws Exception {
        Log.getLogger(HttpParser.class).info("badMessage: bad encoding expected ...", new Object[0]);
        String response = this.connector.getResponses("GET /bad/encoding%1 HTTP/1.1\nHost: localhost\nConnection: close\n\r\n");
        this.checkContains(response, 0, "HTTP/1.1 400");
    }

    @Test
    public void testBadUTF8FallsbackTo8859() throws Exception {
        Log.getLogger(HttpParser.class).info("badMessage: bad encoding expected ...", new Object[0]);
        String response = this.connector.getResponses("GET /foo/bar%c0%00 HTTP/1.1\nHost: localhost\nConnection: close\n\r\n");
        this.checkContains(response, 0, "HTTP/1.1 200");
        response = this.connector.getResponses("GET /bad/utf8%c1 HTTP/1.1\nHost: localhost\nConnection: close\n\r\n");
        this.checkContains(response, 0, "HTTP/1.1 200");
    }

    @Test
    public void testAutoFlush() throws Exception {
        String response = null;
        int offset = 0;
        offset = 0;
        response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\nConnection: close\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        this.checkNotContained(response, offset, "IgnoreMe");
        offset = this.checkContains(response, offset, "/R1");
        offset = this.checkContains(response, offset, "12345");
    }

    @Test
    public void testCharset() throws Exception {
        String response = null;
        try {
            int offset = 0;
            offset = 0;
            response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\nConnection: close\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200");
            offset = this.checkContains(response, offset, "/R1");
            offset = this.checkContains(response, offset, "encoding=UTF-8");
            offset = this.checkContains(response, offset, "12345");
            offset = 0;
            response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset =  iso-8859-1 ; other=value\nConnection: close\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200");
            offset = this.checkContains(response, offset, "encoding=ISO-8859-1");
            offset = this.checkContains(response, offset, "/R1");
            offset = this.checkContains(response, offset, "12345");
            offset = 0;
            response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=unknown\nConnection: close\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200");
            offset = this.checkContains(response, offset, "encoding=unknown");
            offset = this.checkContains(response, offset, "/R1");
            offset = this.checkContains(response, offset, "UnsupportedEncodingException");
        }
        catch (Exception e) {
            if (response != null) {
                System.err.println(response);
            }
            throw e;
        }
    }

    @Test
    public void testUnconsumed() throws Exception {
        String response = null;
        String requests = null;
        int offset = 0;
        offset = 0;
        requests = "GET /R1?read=4 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n5;\r\n67890\r\n0;\r\n\r\nGET /R2 HTTP/1.1\nHost: localhost\nContent-Type: text/plain; charset=utf-8\nContent-Length: 10\nConnection: close\n\nabcdefghij\n";
        response = this.connector.getResponses(requests);
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        offset = this.checkContains(response, offset, "pathInfo=/R1");
        offset = this.checkContains(response, offset, "1234");
        this.checkNotContained(response, offset, "56789");
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        offset = this.checkContains(response, offset, "pathInfo=/R2");
        offset = this.checkContains(response, offset, "encoding=UTF-8");
        offset = this.checkContains(response, offset, "abcdefghij");
    }

    @Test
    public void testUnconsumedTimeout() throws Exception {
        String response = null;
        String requests = null;
        int offset = 0;
        offset = 0;
        requests = "GET /R1?read=4 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n";
        long start = System.currentTimeMillis();
        response = this.connector.getResponses(requests, 2000L, TimeUnit.MILLISECONDS);
        if (System.currentTimeMillis() - start >= 2000L) {
            Assert.fail();
        }
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        offset = this.checkContains(response, offset, "pathInfo=/R1");
        offset = this.checkContains(response, offset, "1234");
        this.checkNotContained(response, offset, "56789");
    }

    @Test
    public void testUnconsumedError() throws Exception {
        String response = null;
        String requests = null;
        int offset = 0;
        offset = 0;
        requests = "GET /R1?read=1&error=499 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n5;\r\n67890\r\n0;\r\n\r\nGET /R2 HTTP/1.1\nHost: localhost\nContent-Type: text/plain; charset=utf-8\nContent-Length: 10\nConnection: close\n\nabcdefghij\n";
        response = this.connector.getResponses(requests);
        offset = this.checkContains(response, offset, "HTTP/1.1 499");
        offset = this.checkContains(response, offset, "HTTP/1.1 200");
        offset = this.checkContains(response, offset, "/R2");
        offset = this.checkContains(response, offset, "encoding=UTF-8");
        offset = this.checkContains(response, offset, "abcdefghij");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnconsumedException() throws Exception {
        String response = null;
        String requests = null;
        int offset = 0;
        offset = 0;
        requests = "GET /R1?read=1&ISE=true HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n5;\r\n67890\r\n0;\r\n\r\nGET /R2 HTTP/1.1\nHost: localhost\nContent-Type: text/plain; charset=utf-8\nContent-Length: 10\n\nabcdefghij\n";
        Logger logger = Log.getLogger(HttpChannel.class);
        try {
            logger.info("EXPECTING: java.lang.IllegalStateException...", new Object[0]);
            ((StdErrLog)logger).setHideStacks(true);
            response = this.connector.getResponses(requests);
            offset = this.checkContains(response, offset, "HTTP/1.1 500");
            offset = this.checkContains(response, offset, "Connection: close");
            this.checkNotContained(response, offset, "HTTP/1.1 200");
        }
        finally {
            ((StdErrLog)logger).setHideStacks(false);
        }
    }

    @Test
    public void testConnection() throws Exception {
        String response = null;
        try {
            int offset = 0;
            offset = 0;
            response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nConnection: TE, close\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
            this.checkContains(response, offset, "Connection: close");
        }
        catch (Exception e) {
            if (response != null) {
                System.err.println(response);
            }
            throw e;
        }
    }

    @Test
    public void testOversizedBuffer() throws Exception {
        String response = null;
        try {
            int offset = 0;
            String cookie = "thisisastringthatshouldreachover1kbytes";
            for (int i = 0; i < 100; ++i) {
                cookie = cookie + "xxxxxxxxxxxx";
            }
            response = this.connector.getResponses("GET / HTTP/1.1\nHost: localhost\nCookie: " + cookie + "\n" + "\r\n");
            this.checkContains(response, offset, "HTTP/1.1 413");
        }
        catch (Exception e) {
            if (response != null) {
                System.err.println(response);
            }
            throw e;
        }
    }

    @Test
    public void testExcessiveHeader() throws Exception {
        String response = null;
        int offset = 0;
        StringBuilder request = new StringBuilder();
        request.append("GET / HTTP/1.1\n");
        request.append("Host: localhost\n");
        request.append("Cookie: thisisastring\n");
        for (int i = 0; i < 1000; ++i) {
            request.append(String.format("X-Header-%04d: %08x\n", i, i));
        }
        request.append("\r\n");
        response = this.connector.getResponses(request.toString());
        this.checkContains(response, offset, "HTTP/1.1 413");
    }

    @Test
    public void testOversizedResponse() throws Exception {
        String str = "thisisastringthatshouldreachover1kbytes-";
        for (int i = 0; i < 500; ++i) {
            str = str + "xxxxxxxxxxxx";
        }
        final String longstr = str;
        final CountDownLatch checkError = new CountDownLatch(1);
        String response = null;
        this.server.stop();
        this.server.setHandler((Handler)new DumpHandler(){

            @Override
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setHeader(HttpHeader.CONTENT_TYPE.toString(), MimeTypes.Type.TEXT_HTML.toString());
                response.setHeader("LongStr", longstr);
                PrintWriter writer = response.getWriter();
                writer.write("<html><h1>FOO</h1></html>");
                writer.flush();
                if (writer.checkError()) {
                    checkError.countDown();
                }
                response.flushBuffer();
            }
        });
        this.server.start();
        try {
            ((StdErrLog)Log.getLogger(HttpChannel.class)).info("Excpect IOException: Response header too large...", new Object[0]);
            ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(true);
            int offset = 0;
            response = this.connector.getResponses("GET / HTTP/1.1\nHost: localhost\n\r\n");
            this.checkContains(response, offset, "HTTP/1.1 500");
            Assert.assertTrue((boolean)checkError.await(1L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            if (response != null) {
                System.err.println(response);
            }
            throw e;
        }
        finally {
            ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(false);
        }
    }

    @Test
    public void testAsterisk() throws Exception {
        String response = null;
        try {
            ((StdErrLog)HttpParser.LOG).setHideStacks(true);
            int offset = 0;
            response = this.connector.getResponses("OPTIONS * HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\nConnection: close\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200");
            offset = this.checkContains(response, offset, "Allow: GET,POST,HEAD");
            offset = 0;
            response = this.connector.getResponses("GET * HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\nConnection: close\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 400");
            offset = 0;
            response = this.connector.getResponses("GET ** HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8\nConnection: close\n\r\n5;\r\n12345\r\n0;\r\n\r\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 400 Bad Request");
        }
        catch (Exception e) {
            if (response != null) {
                System.err.println(response);
            }
            throw e;
        }
        finally {
            ((StdErrLog)HttpParser.LOG).setHideStacks(false);
        }
    }

    @Test
    public void testCONNECT() throws Exception {
        String response = null;
        try {
            int offset = 0;
            response = this.connector.getResponses("CONNECT www.webtide.com:8080 HTTP/1.1\nHost: myproxy:8888\r\n\r\n", 200L, TimeUnit.MILLISECONDS);
            this.checkContains(response, offset, "HTTP/1.1 200");
        }
        catch (Exception e) {
            if (response != null) {
                System.err.println(response);
            }
            throw e;
        }
    }

    private int checkContains(String s, int offset, String c) {
        Assert.assertThat((Object)s.substring(offset), (Matcher)Matchers.containsString((String)c));
        return s.indexOf(c, offset);
    }

    private void checkNotContained(String s, int offset, String c) {
        Assert.assertThat((Object)s.substring(offset), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)c)));
    }
}

