/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpServerTestBase;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExtendedServerTest
extends HttpServerTestBase {
    @Before
    public void init() throws Exception {
        this.startServer((NetworkConnector)new ServerConnector(this._server, new ConnectionFactory[]{new HttpConnectionFactory(){

            public Connection newConnection(Connector connector, EndPoint endPoint) {
                return this.configure((AbstractConnection)new ExtendedHttpConnection(this.getHttpConfiguration(), connector, endPoint), connector, endPoint);
            }
        }}){

            protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selectSet, SelectionKey key) throws IOException {
                return new ExtendedEndPoint(channel, selectSet, key, this.getScheduler(), this.getIdleTimeout());
            }
        });
    }

    @Test
    public void testExtended() throws Exception {
        this.configureServer((Handler)new DispatchedAtHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            long start = System.currentTimeMillis();
            os.write("GET / HTTP/1.0\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            Thread.sleep(200L);
            long end = System.currentTimeMillis();
            os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
            String response = ExtendedServerTest.readResponse(client);
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"DispatchedAt="));
            String s = response.substring(response.indexOf("DispatchedAt=") + 13);
            s = s.substring(0, s.indexOf(10));
            long dispatched = Long.valueOf(s);
            Assert.assertThat((Object)dispatched, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(start)));
            Assert.assertThat((Object)dispatched, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(end)));
        }
    }

    protected static class DispatchedAtHandler
    extends AbstractHandler {
        protected DispatchedAtHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.getOutputStream().print("DispatchedAt=" + request.getAttribute("DispatchedAt") + "\r\n");
        }
    }

    private static class ExtendedHttpConnection
    extends HttpConnection {
        public ExtendedHttpConnection(HttpConfiguration config, Connector connector, EndPoint endPoint) {
            super(config, connector, endPoint);
        }

        protected HttpConnection.HttpChannelOverHttp newHttpChannel(HttpInput<ByteBuffer> httpInput) {
            return new HttpConnection.HttpChannelOverHttp(this.getConnector(), this.getHttpConfiguration(), this.getEndPoint(), (HttpTransport)this, httpInput){

                public boolean startRequest(HttpMethod httpMethod, String method, ByteBuffer uri, HttpVersion version) {
                    this.getRequest().setAttribute("DispatchedAt", (Object)((ExtendedEndPoint)this.getEndPoint()).getLastSelected());
                    return super.startRequest(httpMethod, method, uri, version);
                }
            };
        }
    }

    private static class ExtendedEndPoint
    extends SelectChannelEndPoint {
        private volatile long _lastSelected;

        public ExtendedEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selector, SelectionKey key, Scheduler scheduler, long idleTimeout) {
            super(channel, selector, key, scheduler, idleTimeout);
        }

        public void onSelected() {
            this._lastSelected = System.currentTimeMillis();
            super.onSelected();
        }

        long getLastSelected() {
            return this._lastSelected;
        }
    }
}

