/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

@ManagedObject
public class RoundRobinConnectionPool
extends AbstractConnectionPool {
    private final List<Entry> entries;
    private int index;

    public RoundRobinConnectionPool(Destination destination, int maxConnections, Callback requester) {
        super(destination, maxConnections, requester);
        this.entries = new ArrayList<Entry>(maxConnections);
        for (int i = 0; i < maxConnections; ++i) {
            this.entries.add(new Entry());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCreated(Connection connection) {
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            for (Entry entry : this.entries) {
                if (entry.connection != null) continue;
                entry.connection = connection;
                break;
            }
        }
        this.idle(connection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Connection activate() {
        Connection connection = null;
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            int capacity = this.getMaxConnectionCount();
            for (int offset = 0; offset < capacity; ++offset) {
                Entry entry;
                int idx = this.index + offset;
                if (idx >= capacity) {
                    idx -= capacity;
                }
                if ((entry = this.entries.get(idx)).connection == null) break;
                if (entry.active) continue;
                entry.active = true;
                entry.used++;
                connection = entry.connection;
                this.index += offset + 1;
                if (this.index < capacity) break;
                this.index -= capacity;
                break;
            }
        }
        return connection == null ? null : this.active(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive(Connection connection) {
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            for (Entry entry : this.entries) {
                if (entry.connection != connection) continue;
                return entry.active;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(Connection connection) {
        boolean active = false;
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            for (Entry entry : this.entries) {
                if (entry.connection != connection) continue;
                entry.active = false;
                active = true;
                break;
            }
        }
        if (active) {
            this.released(connection);
        }
        return this.idle(connection, this.isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Connection connection) {
        boolean active = false;
        boolean removed = false;
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            for (Entry entry : this.entries) {
                if (entry.connection != connection) continue;
                active = entry.active;
                entry.reset();
                removed = true;
                break;
            }
        }
        if (active) {
            this.released(connection);
        }
        if (removed) {
            this.removed(connection);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Entry> connections = new ArrayList<Entry>();
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            connections.addAll(this.entries);
        }
        ContainerLifeCycle.dumpObject(out, this);
        ContainerLifeCycle.dump(out, indent, connections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int present = 0;
        int active = 0;
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            for (Entry entry : this.entries) {
                if (entry.connection == null) continue;
                ++present;
                if (!entry.active) continue;
                ++active;
            }
        }
        return String.format("%s@%x[c=%d/%d,a=%d]", this.getClass().getSimpleName(), this.hashCode(), present, this.getMaxConnectionCount(), active);
    }

    private static class Entry {
        private Connection connection;
        private boolean active;
        private long used;

        private Entry() {
        }

        private void reset() {
            this.connection = null;
            this.active = false;
            this.used = 0L;
        }

        public String toString() {
            return String.format("{u=%d,c=%s}", this.used, this.connection);
        }
    }
}

