/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.ConfigurationParameters;

class DisplayNameGeneratorParameterConverter {
    private static final Logger logger = LoggerFactory.getLogger(DisplayNameGeneratorParameterConverter.class);

    DisplayNameGeneratorParameterConverter() {
    }

    DisplayNameGenerator get(ConfigurationParameters configurationParameters, String key, Supplier<? extends DisplayNameGenerator> defaultValueSupplier) {
        return configurationParameters.get(key).map(String::trim).filter(className -> !className.isEmpty()).flatMap(className -> this.instantiateGenerator((String)className, key)).orElseGet(defaultValueSupplier);
    }

    private Optional<DisplayNameGenerator> instantiateGenerator(String className, String key) {
        return ReflectionUtils.tryToLoadClass(className).andThenTry(x$0 -> ReflectionUtils.newInstance(x$0, new Object[0])).andThenTry(DisplayNameGenerator.class::cast).ifSuccess(generator -> this.logGeneratorClassMessage(className, key)).ifFailure(cause -> this.logFailureMessage(className, key, (Exception)cause)).toOptional();
    }

    private void logFailureMessage(String className, String key, Exception cause) {
        logger.warn(cause, () -> String.format("Failed to load default display name generator class '%s' set via the '%s' configuration parameter. Falling back to default behavior.", className, key));
    }

    private void logGeneratorClassMessage(String className, String key) {
        logger.info(() -> String.format("Using default display name generator '%s' set via the '%s' configuration parameter.", className, key));
    }
}

