/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SearchPattern {
    static final int alphabetSize = 256;
    private int[] table;
    private byte[] pattern;

    public static SearchPattern compile(byte[] pattern) {
        return new SearchPattern(Arrays.copyOf(pattern, pattern.length));
    }

    public static SearchPattern compile(String pattern) {
        return new SearchPattern(pattern.getBytes(StandardCharsets.UTF_8));
    }

    private SearchPattern(byte[] pattern) {
        int i2;
        this.pattern = pattern;
        if (pattern.length == 0) {
            throw new IllegalArgumentException("Empty Pattern");
        }
        this.table = new int[256];
        for (i2 = 0; i2 < this.table.length; ++i2) {
            this.table[i2] = pattern.length;
        }
        for (i2 = 0; i2 < pattern.length - 1; ++i2) {
            this.table[0xFF & pattern[i2]] = pattern.length - 1 - i2;
        }
    }

    public int match(byte[] data, int offset, int length) {
        this.validate(data, offset, length);
        for (int skip = offset; skip <= offset + length - this.pattern.length; skip += this.table[0xFF & data[skip + this.pattern.length - 1]]) {
            int i2 = this.pattern.length - 1;
            while (data[skip + i2] == this.pattern[i2]) {
                if (i2 == 0) {
                    return skip;
                }
                --i2;
            }
        }
        return -1;
    }

    public int endsWith(byte[] data, int offset, int length) {
        int skip;
        this.validate(data, offset, length);
        int n = skip = this.pattern.length <= length ? offset + length - this.pattern.length : offset;
        while (skip < offset + length) {
            int i2 = offset + length - 1 - skip;
            while (data[skip + i2] == this.pattern[i2]) {
                if (i2 == 0) {
                    return offset + length - skip;
                }
                --i2;
            }
            if (skip + this.pattern.length - 1 < data.length) {
                skip += this.table[0xFF & data[skip + this.pattern.length - 1]];
                continue;
            }
            ++skip;
        }
        return 0;
    }

    public int startsWith(byte[] data, int offset, int length, int matched) {
        this.validate(data, offset, length);
        int matchedCount = 0;
        for (int i2 = 0; i2 < this.pattern.length - matched && i2 < length; ++i2) {
            if (data[offset + i2] == this.pattern[i2 + matched]) {
                ++matchedCount;
                continue;
            }
            return 0;
        }
        return matched + matchedCount;
    }

    private void validate(byte[] data, int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset was negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length was negative");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("(offset+length) out of bounds of data[]");
        }
    }

    public int getLength() {
        return this.pattern.length;
    }
}

