/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Logger;

public class ContextFactory
implements ObjectFactory {
    private static Logger __log = NamingUtil.__log;
    private static final WeakHashMap __contextMap = new WeakHashMap();
    private static final ThreadLocal<Context> __threadContext = new ThreadLocal();
    private static final ThreadLocal<ClassLoader> __threadClassLoader = new ThreadLocal();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Context ctx = __threadContext.get();
        if (ctx != null) {
            if (__log.isDebugEnabled()) {
                __log.debug("Using the Context that is bound on the thread", new Object[0]);
            }
            return ctx;
        }
        ClassLoader loader = __threadClassLoader.get();
        if (loader != null) {
            if (__log.isDebugEnabled() && loader != null) {
                __log.debug("Using threadlocal classloader", new Object[0]);
            }
            if ((ctx = this.getContextForClassLoader(loader)) == null) {
                ctx = this.newNamingContext(obj, loader, env, name, nameCtx);
                __contextMap.put(loader, ctx);
                if (__log.isDebugEnabled()) {
                    __log.debug("Made context " + name.get(0) + " for classloader: " + loader, new Object[0]);
                }
            }
            return ctx;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        loader = tccl;
        if (loader != null) {
            if (__log.isDebugEnabled() && loader != null) {
                __log.debug("Trying thread context classloader", new Object[0]);
            }
            while (ctx == null && loader != null) {
                ctx = this.getContextForClassLoader(loader);
                if (ctx != null || loader == null) continue;
                loader = loader.getParent();
            }
            if (ctx == null) {
                ctx = this.newNamingContext(obj, tccl, env, name, nameCtx);
                __contextMap.put(tccl, ctx);
                if (__log.isDebugEnabled()) {
                    __log.debug("Made context " + name.get(0) + " for classloader: " + tccl, new Object[0]);
                }
            }
            return ctx;
        }
        if (ContextHandler.getCurrentContext() != null) {
            if (__log.isDebugEnabled() && loader != null) {
                __log.debug("Trying classloader of current org.eclipse.jetty.server.handler.ContextHandler", new Object[0]);
            }
            if ((ctx = (Context)__contextMap.get(loader = ContextHandler.getCurrentContext().getContextHandler().getClassLoader())) == null && loader != null) {
                ctx = this.newNamingContext(obj, loader, env, name, nameCtx);
                __contextMap.put(loader, ctx);
                if (__log.isDebugEnabled()) {
                    __log.debug("Made context " + name.get(0) + " for classloader: " + loader, new Object[0]);
                }
            }
            return ctx;
        }
        return null;
    }

    public NamingContext newNamingContext(Object obj, ClassLoader loader, Hashtable env, Name name, Context parentCtx) throws Exception {
        Reference ref = (Reference)obj;
        StringRefAddr parserAddr = (StringRefAddr)ref.get("parser");
        String parserClassName = parserAddr == null ? null : (String)parserAddr.getContent();
        NameParser parser = parserClassName == null ? null : loader.loadClass(parserClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return new NamingContext(env, name.get(0), (NamingContext)parentCtx, parser);
    }

    public Context getContextForClassLoader(ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        return (Context)__contextMap.get(loader);
    }

    public static Context associateContext(Context ctx) {
        Context previous = __threadContext.get();
        __threadContext.set(ctx);
        return previous;
    }

    public static void disassociateContext(Context ctx) {
        __threadContext.set(null);
    }

    public static ClassLoader associateClassLoader(ClassLoader loader) {
        ClassLoader prev = __threadClassLoader.get();
        __threadClassLoader.set(loader);
        return prev;
    }

    public static void disassociateClassLoader() {
        __threadClassLoader.set(null);
    }

    public static void dump(Appendable out, String indent) throws IOException {
        out.append("o.e.j.jndi.ContextFactory@").append(Long.toHexString(__contextMap.hashCode())).append("\n");
        int size = __contextMap.size();
        int i2 = 0;
        for (Map.Entry entry : __contextMap.entrySet()) {
            boolean last = ++i2 == size;
            ClassLoader loader = (ClassLoader)entry.getKey();
            out.append(indent).append(" +- ").append(loader.getClass().getSimpleName()).append("@").append(Long.toHexString(loader.hashCode())).append(": ");
            NamingContext context = (NamingContext)entry.getValue();
            context.dump(out, indent + (last ? "    " : " |  "));
        }
    }
}

