/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.jaas.JAASUserPrincipal;
import org.eclipse.jetty.jaas.callback.ObjectCallback;
import org.eclipse.jetty.jaas.callback.RequestParameterCallback;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JAASLoginService
extends AbstractLifeCycle
implements LoginService {
    private static final Logger LOG = Log.getLogger(JAASLoginService.class);
    public static final String DEFAULT_ROLE_CLASS_NAME = "org.eclipse.jetty.jaas.JAASRole";
    public static final String[] DEFAULT_ROLE_CLASS_NAMES = new String[]{"org.eclipse.jetty.jaas.JAASRole"};
    protected String[] _roleClassNames = DEFAULT_ROLE_CLASS_NAMES;
    protected String _callbackHandlerClass;
    protected String _realmName;
    protected String _loginModuleName;
    protected JAASUserPrincipal _defaultUser = new JAASUserPrincipal(null, null, null);
    protected IdentityService _identityService;

    public JAASLoginService() {
    }

    public JAASLoginService(String name) {
        this();
        this._realmName = name;
        this._loginModuleName = name;
    }

    @Override
    public String getName() {
        return this._realmName;
    }

    public void setName(String name) {
        this._realmName = name;
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    @Override
    public void setIdentityService(IdentityService identityService) {
        this._identityService = identityService;
    }

    public void setLoginModuleName(String name) {
        this._loginModuleName = name;
    }

    public void setCallbackHandlerClass(String classname) {
        this._callbackHandlerClass = classname;
    }

    public void setRoleClassNames(String[] classnames) {
        if (classnames == null || classnames.length == 0) {
            this._roleClassNames = DEFAULT_ROLE_CLASS_NAMES;
            return;
        }
        this._roleClassNames = ArrayUtil.addToArray(classnames, DEFAULT_ROLE_CLASS_NAME, String.class);
    }

    public String[] getRoleClassNames() {
        return this._roleClassNames;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._identityService == null) {
            this._identityService = new DefaultIdentityService();
        }
        super.doStart();
    }

    @Override
    public UserIdentity login(final String username, final Object credentials, final ServletRequest request) {
        try {
            CallbackHandler callbackHandler = null;
            if (this._callbackHandlerClass == null) {
                callbackHandler = new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        for (Callback callback : callbacks) {
                            if (callback instanceof NameCallback) {
                                ((NameCallback)callback).setName(username);
                                continue;
                            }
                            if (callback instanceof PasswordCallback) {
                                ((PasswordCallback)callback).setPassword(credentials.toString().toCharArray());
                                continue;
                            }
                            if (callback instanceof ObjectCallback) {
                                ((ObjectCallback)callback).setObject(credentials);
                                continue;
                            }
                            if (callback instanceof RequestParameterCallback) {
                                RequestParameterCallback rpc = (RequestParameterCallback)callback;
                                if (request == null) continue;
                                rpc.setParameterValues(Arrays.asList(request.getParameterValues(rpc.getParameterName())));
                                continue;
                            }
                            throw new UnsupportedCallbackException(callback);
                        }
                    }
                };
            } else {
                Class clazz = Loader.loadClass(this._callbackHandlerClass);
                callbackHandler = (CallbackHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this._loginModuleName, subject, callbackHandler);
            loginContext.login();
            JAASUserPrincipal userPrincipal = new JAASUserPrincipal(this.getUserName(callbackHandler), subject, loginContext);
            subject.getPrincipals().add(userPrincipal);
            return this._identityService.newUserIdentity(subject, userPrincipal, this.getGroups(subject));
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    @Override
    public boolean validate(UserIdentity user) {
        return true;
    }

    private String getUserName(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        NameCallback nameCallback = new NameCallback("foo");
        callbackHandler.handle(new Callback[]{nameCallback});
        return nameCallback.getName();
    }

    @Override
    public void logout(UserIdentity user) {
        Set<JAASUserPrincipal> userPrincipals = user.getSubject().getPrincipals(JAASUserPrincipal.class);
        LoginContext loginContext = userPrincipals.iterator().next().getLoginContext();
        try {
            loginContext.logout();
        }
        catch (LoginException e) {
            LOG.warn(e);
        }
    }

    protected String[] getGroups(Subject subject) {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        Set<Principal> principals = subject.getPrincipals();
        block0: for (Principal principal : principals) {
            for (Class<?> c = principal.getClass(); c != null; c = c.getSuperclass()) {
                if (this.roleClassNameMatches(c.getName())) {
                    groups.add(principal.getName());
                    continue block0;
                }
                boolean added = false;
                for (Class<?> ci : c.getInterfaces()) {
                    if (!this.roleClassNameMatches(ci.getName())) continue;
                    groups.add(principal.getName());
                    added = true;
                    break;
                }
                if (added) continue block0;
            }
        }
        return groups.toArray(new String[groups.size()]);
    }

    private boolean roleClassNameMatches(String classname) {
        boolean result = false;
        for (String roleClassName : this.getRoleClassNames()) {
            if (!roleClassName.equals(classname)) continue;
            result = true;
            break;
        }
        return result;
    }
}

