/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceContentFactory
implements HttpContent.Factory {
    private final ResourceFactory _factory;
    private final MimeTypes _mimeTypes;
    private final int _maxBufferSize;
    private final boolean _gzip;

    public ResourceContentFactory(ResourceFactory factory, MimeTypes mimeTypes, int maxBufferSize, boolean gzip) {
        this._factory = factory;
        this._mimeTypes = mimeTypes;
        this._maxBufferSize = maxBufferSize;
        this._gzip = gzip;
    }

    @Override
    public HttpContent getContent(String pathInContext) throws IOException {
        Resource resource = this._factory.getResource(pathInContext);
        HttpContent loaded = this.load(pathInContext, resource);
        return loaded;
    }

    private HttpContent load(String pathInContext, Resource resource) throws IOException {
        String pathInContextGz;
        Resource resourceGz;
        if (resource == null || !resource.exists()) {
            return null;
        }
        if (resource.isDirectory()) {
            return new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), this._maxBufferSize);
        }
        String mt = this._mimeTypes.getMimeByExtension(pathInContext);
        if (this._gzip && (resourceGz = this._factory.getResource(pathInContextGz = pathInContext + ".gz")).exists() && resourceGz.lastModified() >= resource.lastModified() && resourceGz.length() < resource.length()) {
            return new ResourceHttpContent(resource, mt, this._maxBufferSize, new ResourceHttpContent(resourceGz, this._mimeTypes.getMimeByExtension(pathInContextGz), this._maxBufferSize));
        }
        return new ResourceHttpContent(resource, mt, this._maxBufferSize);
    }

    public String toString() {
        return "ResourceContentFactory[" + this._factory + "]@" + this.hashCode();
    }
}

