/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.JarScanner;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class AnnotationParser {
    private static final Logger LOG = Log.getLogger(AnnotationParser.class);
    protected Set<String> _parsedClassNames = new ConcurrentHashSet<String>();
    protected static int ASM_OPCODE_VERSION = 327680;

    public static String normalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        return name.replace('/', '.');
    }

    public static String[] normalize(String[] list) {
        if (list == null) {
            return null;
        }
        String[] normalList = new String[list.length];
        int i = 0;
        for (String s : list) {
            normalList[i++] = AnnotationParser.normalize(s);
        }
        return normalList;
    }

    public boolean isParsed(String className) {
        return this._parsedClassNames.contains(className);
    }

    public void parse(Set<? extends Handler> handlers, String className, ClassNameResolver resolver) throws Exception {
        if (className == null) {
            return;
        }
        if (!(resolver.isExcluded(className) || this.isParsed(className) && !resolver.shouldOverride(className))) {
            className = className.replace('.', '/') + ".class";
            URL resource = Loader.getResource(this.getClass(), className);
            if (resource != null) {
                Resource r = Resource.newResource(resource);
                this.scanClass(handlers, null, r.getInputStream());
            }
        }
    }

    public void parse(Set<? extends Handler> handlers, Class<?> clazz, ClassNameResolver resolver, boolean visitSuperClasses) throws Exception {
        Class<?> cz = clazz;
        while (cz != null) {
            if (!(resolver.isExcluded(cz.getName()) || this.isParsed(cz.getName()) && !resolver.shouldOverride(cz.getName()))) {
                String nameAsResource = cz.getName().replace('.', '/') + ".class";
                URL resource = Loader.getResource(this.getClass(), nameAsResource);
                if (resource != null) {
                    Resource r = Resource.newResource(resource);
                    this.scanClass(handlers, null, r.getInputStream());
                }
            }
            if (visitSuperClasses) {
                cz = cz.getSuperclass();
                continue;
            }
            cz = null;
        }
    }

    public void parse(Set<? extends Handler> handlers, String[] classNames, ClassNameResolver resolver) throws Exception {
        if (classNames == null) {
            return;
        }
        this.parse(handlers, Arrays.asList(classNames), resolver);
    }

    public void parse(Set<? extends Handler> handlers, List<String> classNames, ClassNameResolver resolver) throws Exception {
        MultiException me = new MultiException();
        for (String s : classNames) {
            try {
                if (resolver != null && (resolver.isExcluded(s) || this.isParsed(s) && !resolver.shouldOverride(s))) continue;
                s = s.replace('.', '/') + ".class";
                URL resource = Loader.getResource(this.getClass(), s);
                if (resource == null) continue;
                Resource r = Resource.newResource(resource);
                this.scanClass(handlers, null, r.getInputStream());
            }
            catch (Exception e) {
                me.add(new RuntimeException("Error scanning class " + s, e));
            }
        }
        me.ifExceptionThrow();
    }

    protected void parseDir(Set<? extends Handler> handlers, Resource dir, ClassNameResolver resolver) throws Exception {
        if (!dir.isDirectory() || !dir.exists() || dir.getName().startsWith(".")) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanning dir {}", dir);
        }
        MultiException me = new MultiException();
        String[] files = dir.list();
        for (int f = 0; files != null && f < files.length; ++f) {
            Resource res = dir.addPath(files[f]);
            if (res.isDirectory()) {
                this.parseDir(handlers, res, resolver);
                continue;
            }
            File file = res.getFile();
            if (this.isValidClassFileName(file == null ? null : file.getName())) {
                try {
                    String name = res.getName();
                    if (resolver != null && (resolver.isExcluded(name) || this.isParsed(name) && !resolver.shouldOverride(name))) continue;
                    Resource r = Resource.newResource(res.getURL());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scanning class {}", r);
                    }
                    try (InputStream is = r.getInputStream();){
                        this.scanClass(handlers, dir, is);
                    }
                }
                catch (Exception ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Error scanning file " + files[f], ex);
                    }
                    me.add(new RuntimeException("Error scanning file " + files[f], ex));
                }
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skipping scan on invalid file {}", res);
        }
        me.ifExceptionThrow();
    }

    public void parse(final Set<? extends Handler> handlers, ClassLoader loader, boolean visitParents, boolean nullInclusive, final ClassNameResolver resolver) throws Exception {
        if (loader == null) {
            return;
        }
        if (!(loader instanceof URLClassLoader)) {
            return;
        }
        final MultiException me = new MultiException();
        JarScanner scanner = new JarScanner(){

            @Override
            public void processEntry(URI jarUri, JarEntry entry) {
                try {
                    AnnotationParser.this.parseJarEntry(handlers, Resource.newResource(jarUri), entry, resolver);
                }
                catch (Exception e) {
                    me.add(new RuntimeException("Error parsing entry " + entry.getName() + " from jar " + jarUri, e));
                }
            }
        };
        scanner.scan(null, loader, nullInclusive, visitParents);
        me.ifExceptionThrow();
    }

    public void parse(Set<? extends Handler> handlers, URI[] uris, ClassNameResolver resolver) throws Exception {
        if (uris == null) {
            return;
        }
        MultiException me = new MultiException();
        for (URI uri : uris) {
            try {
                this.parse(handlers, uri, resolver);
            }
            catch (Exception e) {
                me.add(new RuntimeException("Problem parsing classes from " + uri, e));
            }
        }
        me.ifExceptionThrow();
    }

    public void parse(Set<? extends Handler> handlers, URI uri, ClassNameResolver resolver) throws Exception {
        if (uri == null) {
            return;
        }
        this.parse(handlers, Resource.newResource(uri), resolver);
    }

    public void parse(Set<? extends Handler> handlers, Resource r, ClassNameResolver resolver) throws Exception {
        if (r == null) {
            return;
        }
        if (r.exists() && r.isDirectory()) {
            this.parseDir(handlers, r, resolver);
            return;
        }
        String fullname = r.toString();
        if (fullname.endsWith(".jar")) {
            this.parseJar(handlers, r, resolver);
            return;
        }
        if (fullname.endsWith(".class")) {
            this.scanClass(handlers, null, r.getInputStream());
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.warn("Resource not scannable for classes: {}", r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseJar(Set<? extends Handler> handlers, Resource jarResource, ClassNameResolver resolver) throws Exception {
        if (jarResource == null) {
            return;
        }
        if (jarResource.toString().endsWith(".jar")) {
            InputStream in;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scanning jar {}", jarResource);
            }
            if ((in = jarResource.getInputStream()) == null) {
                return;
            }
            MultiException me = new MultiException();
            try (JarInputStream jar_in = new JarInputStream(in);){
                JarEntry entry = jar_in.getNextJarEntry();
                while (entry != null) {
                    try {
                        this.parseJarEntry(handlers, jarResource, entry, resolver);
                    }
                    catch (Exception e) {
                        me.add(new RuntimeException("Error scanning entry " + entry.getName() + " from jar " + jarResource, e));
                    }
                    entry = jar_in.getNextJarEntry();
                }
            }
            me.ifExceptionThrow();
        }
    }

    protected void parseJarEntry(Set<? extends Handler> handlers, Resource jar, JarEntry entry, ClassNameResolver resolver) throws Exception {
        if (jar == null || entry == null) {
            return;
        }
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        if (this.isValidClassFileName(name) && this.isValidClassFilePath(name)) {
            String shortName = name.replace('/', '.').substring(0, name.length() - 6);
            if (resolver == null || !resolver.isExcluded(shortName) && (!this.isParsed(shortName) || resolver.shouldOverride(shortName))) {
                Resource clazz = Resource.newResource("jar:" + jar.getURI() + "!/" + name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanning class from jar {}", clazz);
                }
                this.scanClass(handlers, jar, clazz.getInputStream());
            }
        }
    }

    protected void scanClass(Set<? extends Handler> handlers, Resource containingResource, InputStream is) throws IOException {
        ClassReader reader = new ClassReader(is);
        reader.accept(new MyClassVisitor(handlers, containingResource), 7);
    }

    private boolean isValidClassFileName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!name.toLowerCase(Locale.ENGLISH).endsWith(".class")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not a class: {}", name);
            }
            return false;
        }
        int c0 = 0;
        int ldir = name.lastIndexOf(47, name.length() - 6);
        int n = c0 = ldir > -1 ? ldir + 1 : c0;
        if (!Character.isJavaIdentifierStart(name.charAt(c0))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not a java identifier: {}" + name, new Object[0]);
            }
            return false;
        }
        return true;
    }

    private boolean isValidClassFilePath(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.startsWith(".") || path.contains("/.")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Contains hidden dirs: {}" + path, new Object[0]);
            }
            return false;
        }
        return true;
    }

    public class MyClassVisitor
    extends ClassVisitor {
        final Resource _containingResource;
        final Set<? extends Handler> _handlers;
        ClassInfo _ci;

        public MyClassVisitor(Set<? extends Handler> handlers, Resource containingResource) {
            super(ASM_OPCODE_VERSION);
            this._handlers = handlers;
            this._containingResource = containingResource;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this._ci = new ClassInfo(this._containingResource, AnnotationParser.normalize(name), version, access, signature, AnnotationParser.normalize(superName), AnnotationParser.normalize(interfaces));
            AnnotationParser.this._parsedClassNames.add(this._ci.getClassName());
            for (Handler handler : this._handlers) {
                handler.handle(this._ci);
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String annotationName = AnnotationParser.normalize(desc);
            for (Handler handler : this._handlers) {
                handler.handle(this._ci, annotationName);
            }
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String methodDesc, String signature, String[] exceptions) {
            return new MyMethodVisitor(this._handlers, this._ci, access, name, methodDesc, signature, exceptions);
        }

        @Override
        public FieldVisitor visitField(int access, String fieldName, String fieldType, String signature, Object value) {
            return new MyFieldVisitor(this._handlers, this._ci, access, fieldName, fieldType, signature, value);
        }
    }

    public class MyFieldVisitor
    extends FieldVisitor {
        final FieldInfo _fieldInfo;
        final Set<? extends Handler> _handlers;

        public MyFieldVisitor(Set<? extends Handler> handlers, ClassInfo classInfo, int access, String fieldName, String fieldType, String signature, Object value) {
            super(ASM_OPCODE_VERSION);
            this._handlers = handlers;
            this._fieldInfo = new FieldInfo(classInfo, fieldName, access, fieldType, signature, value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String annotationName = AnnotationParser.normalize(desc);
            for (Handler handler : this._handlers) {
                handler.handle(this._fieldInfo, annotationName);
            }
            return null;
        }
    }

    public class MyMethodVisitor
    extends MethodVisitor {
        final MethodInfo _mi;
        final Set<? extends Handler> _handlers;

        public MyMethodVisitor(Set<? extends Handler> handlers, ClassInfo classInfo, int access, String name, String methodDesc, String signature, String[] exceptions) {
            super(ASM_OPCODE_VERSION);
            this._handlers = handlers;
            this._mi = new MethodInfo(classInfo, name, access, methodDesc, signature, exceptions);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String annotationName = AnnotationParser.normalize(desc);
            for (Handler handler : this._handlers) {
                handler.handle(this._mi, annotationName);
            }
            return null;
        }
    }

    public static abstract class AbstractHandler
    implements Handler {
        @Override
        public void handle(ClassInfo classInfo) {
        }

        @Override
        public void handle(MethodInfo methodInfo) {
        }

        @Override
        public void handle(FieldInfo fieldInfo) {
        }

        @Override
        public void handle(ClassInfo info, String annotationName) {
        }

        @Override
        public void handle(MethodInfo info, String annotationName) {
        }

        @Override
        public void handle(FieldInfo info, String annotationName) {
        }
    }

    public static interface Handler {
        public void handle(ClassInfo var1);

        public void handle(MethodInfo var1);

        public void handle(FieldInfo var1);

        public void handle(ClassInfo var1, String var2);

        public void handle(MethodInfo var1, String var2);

        public void handle(FieldInfo var1, String var2);
    }

    public class FieldInfo {
        final ClassInfo _classInfo;
        final String _fieldName;
        final int _access;
        final String _fieldType;
        final String _signature;
        final Object _value;

        public FieldInfo(ClassInfo classInfo, String fieldName, int access, String fieldType, String signature, Object value) {
            this._classInfo = classInfo;
            this._fieldName = fieldName;
            this._access = access;
            this._fieldType = fieldType;
            this._signature = signature;
            this._value = value;
        }

        public ClassInfo getClassInfo() {
            return this._classInfo;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public int getAccess() {
            return this._access;
        }

        public String getFieldType() {
            return this._fieldType;
        }

        public String getSignature() {
            return this._signature;
        }

        public Object getValue() {
            return this._value;
        }
    }

    public class MethodInfo {
        final ClassInfo _classInfo;
        final String _methodName;
        final int _access;
        final String _desc;
        final String _signature;
        final String[] _exceptions;

        public MethodInfo(ClassInfo classInfo, String methodName, int access, String desc, String signature, String[] exceptions) {
            this._classInfo = classInfo;
            this._methodName = methodName;
            this._access = access;
            this._desc = desc;
            this._signature = signature;
            this._exceptions = exceptions;
        }

        public ClassInfo getClassInfo() {
            return this._classInfo;
        }

        public String getMethodName() {
            return this._methodName;
        }

        public int getAccess() {
            return this._access;
        }

        public String getDesc() {
            return this._desc;
        }

        public String getSignature() {
            return this._signature;
        }

        public String[] getExceptions() {
            return this._exceptions;
        }
    }

    public class ClassInfo {
        final Resource _containingResource;
        final String _className;
        final int _version;
        final int _access;
        final String _signature;
        final String _superName;
        final String[] _interfaces;

        public ClassInfo(Resource resource, String className, int version, int access, String signature, String superName, String[] interfaces) {
            this._containingResource = resource;
            this._className = className;
            this._version = version;
            this._access = access;
            this._signature = signature;
            this._superName = superName;
            this._interfaces = interfaces;
        }

        public String getClassName() {
            return this._className;
        }

        public int getVersion() {
            return this._version;
        }

        public int getAccess() {
            return this._access;
        }

        public String getSignature() {
            return this._signature;
        }

        public String getSuperName() {
            return this._superName;
        }

        public String[] getInterfaces() {
            return this._interfaces;
        }

        public Resource getContainingResource() {
            return this._containingResource;
        }
    }
}

