/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import org.eclipse.jetty.toolchain.test.PropertyFlag;
import org.eclipse.jetty.toolchain.test.annotation.Slow;
import org.eclipse.jetty.toolchain.test.annotation.Stress;
import org.junit.Ignore;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class AdvancedRunner
extends BlockJUnit4ClassRunner {
    private boolean slowTestsEnabled = false;
    private boolean stressTestsEnabled = false;

    public AdvancedRunner(Class<?> klass) throws InitializationError {
        super(klass);
        boolean isFast = PropertyFlag.isEnabled("test.fast");
        this.slowTestsEnabled = this.isEnabled("test.slow", !isFast);
        this.stressTestsEnabled = this.isEnabled("test.stress", false);
    }

    private boolean isEnabled(String key, boolean def) {
        String val = System.getProperty(key);
        if (val == null) {
            return def;
        }
        if (val.length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(val);
    }

    @Override
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        if (!this.slowTestsEnabled && method.getAnnotation(Slow.class) != null) {
            this.notify("@Slow (Ignored)", description);
            eachNotifier.fireTestIgnored();
            return;
        }
        if (!this.stressTestsEnabled && method.getAnnotation(Stress.class) != null) {
            Stress stress = method.getAnnotation(Stress.class);
            this.notify("@Stress (Ignored - " + stress.value() + ")", description);
            eachNotifier.fireTestIgnored();
            return;
        }
        if (method.getAnnotation(Ignore.class) != null) {
            this.notify("@Ignore", description);
            notifier.fireTestIgnored(description);
            return;
        }
        this.notify("Running", description);
        super.runChild(method, notifier);
    }

    private void notify(String msg, Description description) {
        System.err.printf("[AdvancedRunner] %s %s.%s()%n", msg, description.getClassName(), description.getMethodName());
    }
}

