/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.server.pathmap.PathMappings;
import org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class WebSocketUpgradeHandlerWrapper
extends HandlerWrapper
implements MappedWebSocketCreator {
    private PathMappings<WebSocketCreator> pathmap = new PathMappings();
    private final WebSocketServerFactory factory = new WebSocketServerFactory();

    @Override
    public void addMapping(PathSpec spec, WebSocketCreator creator) {
        this.pathmap.put(spec, creator);
    }

    @Override
    public PathMappings<WebSocketCreator> getMappings() {
        return this.pathmap;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.factory.isUpgradeRequest(request, response)) {
            PathMappings.MappedResource<WebSocketCreator> resource = this.pathmap.getMatch(target);
            if (resource == null) {
                response.sendError(404, "No websocket endpoint matching path: " + target);
                return;
            }
            WebSocketCreator creator = resource.getResource();
            request.setAttribute(PathSpec.class.getName(), resource);
            if (this.factory.acceptWebSocket(creator, request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }
}

