/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public class PerMessageDeflateExtension
extends AbstractExtension {
    private static final boolean BFINAL_HACK = Boolean.parseBoolean(System.getProperty("jetty.websocket.bfinal.hack", "true"));
    private static final Logger LOG = Log.getLogger(PerMessageDeflateExtension.class);
    private static final int OVERHEAD = 64;
    private static final byte[] TAIL = new byte[]{0, 0, -1, -1};
    private ExtensionConfig configRequested;
    private ExtensionConfig configNegotiated;
    private Deflater compressor;
    private Inflater decompressor;
    private boolean incomingCompressed = false;
    private boolean outgoingCompressed = false;
    private boolean incomingContextTakeover = true;
    private boolean outgoingContextTakeover = true;

    @Override
    public String getName() {
        return "permessage-deflate";
    }

    @Override
    public synchronized void incomingFrame(Frame frame) {
        switch (frame.getOpCode()) {
            case 1: 
            case 2: {
                this.incomingCompressed = frame.isRsv1();
                break;
            }
            case 0: {
                if (this.incomingCompressed) break;
                this.nextIncomingFrame(frame);
                break;
            }
            default: {
                this.nextIncomingFrame(frame);
                return;
            }
        }
        if (!this.incomingCompressed || !frame.hasPayload()) {
            this.nextIncomingFrame(frame);
            return;
        }
        ByteBuffer payload = frame.getPayload();
        int inlen = payload.remaining();
        byte[] compressed = null;
        if (frame.isFin()) {
            compressed = new byte[inlen + TAIL.length];
            payload.get(compressed, 0, inlen);
            System.arraycopy(TAIL, 0, compressed, inlen, TAIL.length);
            this.incomingCompressed = false;
        } else {
            compressed = new byte[inlen];
            payload.get(compressed, 0, inlen);
        }
        this.decompressor.setInput(compressed, 0, compressed.length);
        int maxSize = Math.max(this.getPolicy().getMaxTextMessageSize(), this.getPolicy().getMaxBinaryMessageBufferSize());
        ByteAccumulator accumulator = new ByteAccumulator(maxSize);
        DataFrame out = new DataFrame(frame);
        out.setRsv1(false);
        while (this.decompressor.getRemaining() > 0 && !this.decompressor.finished()) {
            byte[] outbuf = new byte[inlen];
            try {
                int len = this.decompressor.inflate(outbuf);
                if (len == 0) {
                    if (this.decompressor.needsInput()) {
                        throw new BadPayloadException("Unable to inflate frame, not enough input on frame");
                    }
                    if (this.decompressor.needsDictionary()) {
                        throw new BadPayloadException("Unable to inflate frame, frame erroneously says it needs a dictionary");
                    }
                }
                if (len <= 0) continue;
                accumulator.addBuffer(outbuf, 0, len);
            }
            catch (DataFormatException e) {
                LOG.warn(e);
                throw new BadPayloadException(e);
            }
        }
        out.setPayload(accumulator.getByteBuffer(this.getBufferPool()));
        this.nextIncomingFrame(out);
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    @Override
    public synchronized void outgoingFrame(Frame frame, WriteCallback callback) {
        if (OpCode.isControlFrame(frame.getOpCode())) {
            this.nextOutgoingFrame(frame, callback);
            return;
        }
        if (!frame.hasPayload()) {
            this.nextOutgoingFrame(frame, callback);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("outgoingFrame({}, {}) - {}", OpCode.name(frame.getOpCode()), callback != null ? callback.getClass().getSimpleName() : "<null>", BufferUtil.toDetailString(frame.getPayload()));
        }
        byte[] uncompressed = BufferUtil.toArray(frame.getPayload());
        if (!this.compressor.finished()) {
            this.compressor.setInput(uncompressed, 0, uncompressed.length);
            byte[] compressed = new byte[uncompressed.length + 64];
            while (!this.compressor.needsInput()) {
                byte b0;
                int len = this.compressor.deflate(compressed, 0, compressed.length, 2);
                ByteBuffer outbuf = this.getBufferPool().acquire(len, true);
                BufferUtil.clearToFill(outbuf);
                if (len > 0) {
                    if (len > 4) {
                        int idx = len - 4;
                        boolean found = true;
                        for (int n = 0; n < TAIL.length; ++n) {
                            if (compressed[idx + n] == TAIL[n]) continue;
                            found = false;
                            break;
                        }
                        if (found) {
                            len -= 4;
                        }
                    }
                    outbuf.put(compressed, 0, len);
                }
                BufferUtil.flipToFlush(outbuf, 0);
                if (len > 0 && BFINAL_HACK && ((b0 = outbuf.get(0)) & 1) != 0) {
                    b0 = (byte)(b0 ^ 1);
                    outbuf.put(0, b0);
                }
                DataFrame out = new DataFrame(frame, this.outgoingCompressed);
                out.setRsv1(true);
                out.setBufferPool(this.getBufferPool());
                out.setPayload(outbuf);
                if (!this.compressor.needsInput()) {
                    out.setFin(false);
                    this.nextOutgoingFrame(out, null);
                } else {
                    this.nextOutgoingFrame(out, callback);
                }
                this.outgoingCompressed = !out.isFin();
            }
        }
    }

    @Override
    protected void nextIncomingFrame(Frame frame) {
        if (frame.isFin() && !this.incomingContextTakeover) {
            LOG.debug("Incoming Context Reset", new Object[0]);
            this.decompressor.reset();
        }
        super.nextIncomingFrame(frame);
    }

    @Override
    protected void nextOutgoingFrame(Frame frame, WriteCallback callback) {
        if (frame.isFin() && !this.outgoingContextTakeover) {
            LOG.debug("Outgoing Context Reset", new Object[0]);
            this.compressor.reset();
        }
        super.nextOutgoingFrame(frame, callback);
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        this.configRequested = new ExtensionConfig(config);
        this.configNegotiated = new ExtensionConfig(config.getName());
        boolean nowrap = true;
        this.compressor = new Deflater(9, nowrap);
        this.compressor.setStrategy(0);
        this.decompressor = new Inflater(nowrap);
        for (String key : config.getParameterKeys()) {
            block6 : switch (key = key.trim()) {
                case "client_max_window_bits": 
                case "server_max_window_bits": {
                    break;
                }
                case "client_no_context_takeover": {
                    this.configNegotiated.setParameter("client_no_context_takeover");
                    switch (this.getPolicy().getBehavior()) {
                        case CLIENT: {
                            this.incomingContextTakeover = false;
                            break block6;
                        }
                        case SERVER: {
                            this.outgoingContextTakeover = false;
                        }
                    }
                    break;
                }
                case "server_no_context_takeover": {
                    this.configNegotiated.setParameter("server_no_context_takeover");
                    switch (this.getPolicy().getBehavior()) {
                        case CLIENT: {
                            this.outgoingContextTakeover = false;
                            break block6;
                        }
                        case SERVER: {
                            this.incomingContextTakeover = false;
                        }
                    }
                }
            }
        }
        super.setConfig(this.configNegotiated);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName());
        str.append("[requested=").append(this.configRequested.getParameterizedName());
        str.append(",negotiated=").append(this.configNegotiated.getParameterizedName());
        str.append(']');
        return str.toString();
    }
}

