/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

public class ServletContainerInitializersStarter
extends AbstractLifeCycle {
    private static final Logger LOG = Log.getLogger(ServletContainerInitializersStarter.class);
    WebAppContext _context;

    public ServletContainerInitializersStarter(WebAppContext context) {
        this._context = context;
    }

    @Override
    public void doStart() {
        List initializers = (List)this._context.getAttribute("org.eclipse.jetty.containerInitializers");
        if (initializers == null) {
            return;
        }
        ConcurrentHashMap map = (ConcurrentHashMap)this._context.getAttribute("org.eclipse.jetty.classInheritanceMap");
        for (ContainerInitializer i : initializers) {
            this.configureHandlesTypes(this._context, i, map);
            try {
                i.callStartup(this._context);
            }
            catch (Exception e) {
                LOG.warn(e);
                throw new RuntimeException(e);
            }
        }
    }

    private void configureHandlesTypes(WebAppContext context, ContainerInitializer initializer, ConcurrentHashMap<String, ConcurrentHashSet<String>> classMap) {
        this.doHandlesTypesAnnotations(context, initializer, classMap);
        this.doHandlesTypesClasses(context, initializer, classMap);
    }

    private void doHandlesTypesAnnotations(WebAppContext context, ContainerInitializer initializer, ConcurrentHashMap<String, ConcurrentHashSet<String>> classMap) {
        if (initializer == null) {
            return;
        }
        if (context == null) {
            throw new IllegalArgumentException("WebAppContext null");
        }
        Set<String> annotatedClassNames = initializer.getAnnotatedTypeNames();
        if (annotatedClassNames != null && !annotatedClassNames.isEmpty()) {
            if (classMap == null) {
                throw new IllegalStateException("No class hierarchy");
            }
            for (String name : annotatedClassNames) {
                initializer.addApplicableTypeName(name);
                this.addInheritedTypes(classMap, initializer, classMap.get(name));
            }
        }
    }

    private void doHandlesTypesClasses(WebAppContext context, ContainerInitializer initializer, ConcurrentHashMap<String, ConcurrentHashSet<String>> classMap) {
        if (initializer == null) {
            return;
        }
        if (context == null) {
            throw new IllegalArgumentException("WebAppContext null");
        }
        if (initializer.getInterestedTypes() != null) {
            if (classMap == null) {
                throw new IllegalStateException("No class hierarchy");
            }
            for (Class c : initializer.getInterestedTypes()) {
                if (c.isAnnotation()) continue;
                this.addInheritedTypes(classMap, initializer, classMap.get(c.getName()));
            }
        }
    }

    private void addInheritedTypes(ConcurrentHashMap<String, ConcurrentHashSet<String>> classMap, ContainerInitializer initializer, ConcurrentHashSet<String> names) {
        if (names == null || names.isEmpty()) {
            return;
        }
        for (String s : names) {
            initializer.addApplicableTypeName(s);
            this.addInheritedTypes(classMap, initializer, classMap.get(s));
        }
    }
}

