/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationDecorator;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.annotations.ContainerInitializerAnnotationHandler;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.annotations.WebFilterAnnotationHandler;
import org.eclipse.jetty.annotations.WebListenerAnnotationHandler;
import org.eclipse.jetty.annotations.WebServletAnnotationHandler;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.MetaDataComplete;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;

public class AnnotationConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(AnnotationConfiguration.class);
    public static final String CLASS_INHERITANCE_MAP = "org.eclipse.jetty.classInheritanceMap";
    public static final String CONTAINER_INITIALIZERS = "org.eclipse.jetty.containerInitializers";
    public static final String CONTAINER_INITIALIZER_STARTER = "org.eclipse.jetty.containerInitializerStarter";
    public static final String MULTI_THREADED = "org.eclipse.jetty.annotations.multiThreaded";
    public static final String MAX_SCAN_WAIT = "org.eclipse.jetty.annotations.maxWait";
    public static final int DEFAULT_MAX_SCAN_WAIT = 60;
    public static final boolean DEFAULT_MULTI_THREADED = true;
    protected List<AbstractDiscoverableAnnotationHandler> _discoverableAnnotationHandlers = new ArrayList<AbstractDiscoverableAnnotationHandler>();
    protected ClassInheritanceHandler _classInheritanceHandler;
    protected List<ContainerInitializerAnnotationHandler> _containerInitializerAnnotationHandlers = new ArrayList<ContainerInitializerAnnotationHandler>();
    protected List<ParserTask> _parserTasks;
    protected WebAppClassNameResolver _webAppClassNameResolver;
    protected ContainerClassNameResolver _containerClassNameResolver;

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this._webAppClassNameResolver = new WebAppClassNameResolver(context);
        this._containerClassNameResolver = new ContainerClassNameResolver(context);
    }

    public void addDiscoverableAnnotationHandler(AbstractDiscoverableAnnotationHandler handler) {
        this._discoverableAnnotationHandlers.add(handler);
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        context.removeAttribute(CLASS_INHERITANCE_MAP);
        context.removeAttribute(CONTAINER_INITIALIZERS);
        ServletContainerInitializersStarter starter = (ServletContainerInitializersStarter)context.getAttribute(CONTAINER_INITIALIZER_STARTER);
        if (starter != null) {
            context.removeBean(starter);
            context.removeAttribute(CONTAINER_INITIALIZER_STARTER);
        }
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        context.addDecorator(new AnnotationDecorator(context));
        if (!context.getMetaData().isMetaDataComplete() && (context.getServletContext().getEffectiveMajorVersion() >= 3 || context.isConfigurationDiscovered())) {
            this._discoverableAnnotationHandlers.add(new WebServletAnnotationHandler(context));
            this._discoverableAnnotationHandlers.add(new WebFilterAnnotationHandler(context));
            this._discoverableAnnotationHandlers.add(new WebListenerAnnotationHandler(context));
        }
        this.createServletContainerInitializerAnnotationHandlers(context, this.getNonExcludedInitializers(context));
        if (!this._discoverableAnnotationHandlers.isEmpty() || this._classInheritanceHandler != null || !this._containerInitializerAnnotationHandlers.isEmpty()) {
            this.scanForAnnotations(context);
        }
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        ConcurrentHashMap classMap = (ConcurrentHashMap)context.getAttribute(CLASS_INHERITANCE_MAP);
        List initializers = (List)context.getAttribute(CONTAINER_INITIALIZERS);
        context.removeAttribute(CLASS_INHERITANCE_MAP);
        if (classMap != null) {
            classMap.clear();
        }
        context.removeAttribute(CONTAINER_INITIALIZERS);
        if (initializers != null) {
            initializers.clear();
        }
        if (this._discoverableAnnotationHandlers != null) {
            this._discoverableAnnotationHandlers.clear();
        }
        this._classInheritanceHandler = null;
        if (this._containerInitializerAnnotationHandlers != null) {
            this._containerInitializerAnnotationHandlers.clear();
        }
        if (this._parserTasks != null) {
            this._parserTasks.clear();
            this._parserTasks = null;
        }
        super.postConfigure(context);
    }

    protected void scanForAnnotations(WebAppContext context) throws Exception {
        boolean timeout;
        AnnotationParser parser = this.createAnnotationParser();
        boolean multiThreadedScan = this.isUseMultiThreading(context);
        int maxScanWait = 0;
        if (multiThreadedScan) {
            this._parserTasks = new ArrayList<ParserTask>();
            maxScanWait = this.getMaxScanWait(context);
        }
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.nanoTime();
            LOG.debug("Scanning for annotations: webxml={}, metadatacomplete={}, configurationDiscovered={}, multiThreaded={}", context.getServletContext().getEffectiveMajorVersion(), context.getMetaData().isMetaDataComplete(), context.isConfigurationDiscovered(), multiThreadedScan);
        }
        this.parseContainerPath(context, parser);
        this.parseWebInfClasses(context, parser);
        this.parseWebInfLib(context, parser);
        if (!multiThreadedScan) {
            if (LOG.isDebugEnabled()) {
                long end = System.nanoTime();
                LOG.debug("Annotation parsing millisec={}", TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS));
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            start = System.nanoTime();
        }
        final CountDownLatch latch = new CountDownLatch(this._parserTasks.size());
        final MultiException me = new MultiException();
        final Semaphore task_limit = new Semaphore(Runtime.getRuntime().availableProcessors());
        for (final ParserTask p : this._parserTasks) {
            task_limit.acquire();
            context.getServer().getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        p.call();
                    }
                    catch (Exception e) {
                        me.add(e);
                    }
                    finally {
                        task_limit.release();
                        latch.countDown();
                    }
                }
            });
        }
        boolean bl = timeout = !latch.await(maxScanWait, TimeUnit.SECONDS);
        if (LOG.isDebugEnabled()) {
            long end = System.nanoTime();
            LOG.debug("Annotation parsing millisec={}", TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS));
        }
        if (timeout) {
            me.add(new Exception("Timeout scanning annotations"));
        }
        me.ifExceptionThrow();
    }

    protected AnnotationParser createAnnotationParser() {
        return new AnnotationParser();
    }

    protected boolean isUseMultiThreading(WebAppContext context) {
        Object o = context.getAttribute(MULTI_THREADED);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        o = context.getServer().getAttribute(MULTI_THREADED);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.valueOf(System.getProperty(MULTI_THREADED, Boolean.toString(true)));
    }

    protected int getMaxScanWait(WebAppContext context) {
        Object o = context.getAttribute(MAX_SCAN_WAIT);
        if (o != null && o instanceof Number) {
            return ((Number)o).intValue();
        }
        o = context.getServer().getAttribute(MAX_SCAN_WAIT);
        if (o != null && o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Integer.getInteger(MAX_SCAN_WAIT, 60);
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.addDecorator(new AnnotationDecorator(context));
    }

    public void createServletContainerInitializerAnnotationHandlers(WebAppContext context, List<ServletContainerInitializer> scis) throws Exception {
        if (scis == null || scis.isEmpty()) {
            return;
        }
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        context.setAttribute(CONTAINER_INITIALIZERS, initializers);
        for (ServletContainerInitializer service : scis) {
            HandlesTypes annotation = service.getClass().getAnnotation(HandlesTypes.class);
            ContainerInitializer initializer = null;
            if (annotation != null) {
                Class[] classes = annotation.value();
                if (classes != null) {
                    initializer = new ContainerInitializer(service, classes);
                    if (context.getAttribute(CLASS_INHERITANCE_MAP) == null) {
                        ConcurrentHashMap<String, ConcurrentHashSet<String>> map = new ConcurrentHashMap<String, ConcurrentHashSet<String>>();
                        context.setAttribute(CLASS_INHERITANCE_MAP, map);
                        this._classInheritanceHandler = new ClassInheritanceHandler(map);
                    }
                    for (Class c : classes) {
                        if (!c.isAnnotation()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Registering annotation handler for " + c.getName(), new Object[0]);
                        }
                        this._containerInitializerAnnotationHandlers.add(new ContainerInitializerAnnotationHandler(initializer, c));
                    }
                } else {
                    initializer = new ContainerInitializer(service, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No classes in HandlesTypes on initializer " + service.getClass(), new Object[0]);
                    }
                }
            } else {
                initializer = new ContainerInitializer(service, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No annotation on initializer " + service.getClass(), new Object[0]);
                }
            }
            initializers.add(initializer);
        }
        ServletContainerInitializersStarter starter = (ServletContainerInitializersStarter)context.getAttribute(CONTAINER_INITIALIZER_STARTER);
        if (starter != null) {
            throw new IllegalStateException("ServletContainerInitializersStarter already exists");
        }
        starter = new ServletContainerInitializersStarter(context);
        context.setAttribute(CONTAINER_INITIALIZER_STARTER, starter);
        context.addBean((Object)starter, true);
    }

    public boolean isFromExcludedJar(WebAppContext context, ServletContainerInitializer service) throws Exception {
        List<Resource> orderedJars = context.getMetaData().getOrderedWebInfJars();
        if (context.getMetaData().getOrdering() == null) {
            return false;
        }
        if (orderedJars.isEmpty()) {
            return true;
        }
        String loadingJarName = Thread.currentThread().getContextClassLoader().getResource(service.getClass().getName().replace('.', '/') + ".class").toString();
        int i = loadingJarName.indexOf(".jar");
        if (i < 0) {
            return false;
        }
        loadingJarName = (loadingJarName = loadingJarName.substring(0, i + 4)).startsWith("jar:") ? loadingJarName.substring(4) : loadingJarName;
        URI loadingJarURI = Resource.newResource(loadingJarName).getURI();
        boolean found = false;
        Iterator<Resource> itor = orderedJars.iterator();
        while (!found && itor.hasNext()) {
            Resource r = itor.next();
            found = r.getURI().equals(loadingJarURI);
        }
        return !found;
    }

    public List<ServletContainerInitializer> getNonExcludedInitializers(WebAppContext context) throws Exception {
        ArrayList<ServletContainerInitializer> nonExcludedInitializers = new ArrayList<ServletContainerInitializer>();
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.nanoTime();
        }
        ServiceLoader<ServletContainerInitializer> loadedInitializers = ServiceLoader.load(ServletContainerInitializer.class, context.getClassLoader());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Service loaders found in {}ms", TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        }
        if (loadedInitializers != null) {
            for (ServletContainerInitializer service : loadedInitializers) {
                if (this.isFromExcludedJar(context, service)) continue;
                nonExcludedInitializers.add(service);
            }
        }
        return nonExcludedInitializers;
    }

    public void parseContainerPath(WebAppContext context, AnnotationParser parser) throws Exception {
        LOG.debug("Scanning container jars", new Object[0]);
        HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
        handlers.addAll(this._discoverableAnnotationHandlers);
        handlers.addAll(this._containerInitializerAnnotationHandlers);
        if (this._classInheritanceHandler != null) {
            handlers.add(this._classInheritanceHandler);
        }
        for (Resource r : context.getMetaData().getContainerResources()) {
            if (this._parserTasks != null) {
                this._parserTasks.add(new ParserTask(parser, handlers, r, this._containerClassNameResolver));
                continue;
            }
            parser.parse(handlers, r, (ClassNameResolver)this._containerClassNameResolver);
        }
    }

    public void parseWebInfLib(WebAppContext context, AnnotationParser parser) throws Exception {
        LOG.debug("Scanning WEB-INF/lib jars", new Object[0]);
        List<FragmentDescriptor> frags = context.getMetaData().getFragments();
        ArrayList webInfUris = new ArrayList();
        List<Resource> jars = context.getMetaData().getOrderedWebInfJars();
        if (jars == null || jars.isEmpty()) {
            jars = context.getMetaData().getWebInfJars();
        }
        for (Resource r : jars) {
            HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
            FragmentDescriptor f = this.getFragmentFromJar(r, frags);
            if (f != null && this.isMetaDataComplete(f) && this._classInheritanceHandler == null && this._containerInitializerAnnotationHandlers.isEmpty()) continue;
            if (this._classInheritanceHandler != null) {
                handlers.add(this._classInheritanceHandler);
            }
            handlers.addAll(this._containerInitializerAnnotationHandlers);
            if (f == null || !this.isMetaDataComplete(f)) {
                handlers.addAll(this._discoverableAnnotationHandlers);
            }
            if (this._parserTasks != null) {
                this._parserTasks.add(new ParserTask(parser, handlers, r, this._webAppClassNameResolver));
                continue;
            }
            parser.parse(handlers, r, (ClassNameResolver)this._webAppClassNameResolver);
        }
    }

    public void parseWebInfClasses(WebAppContext context, AnnotationParser parser) throws Exception {
        LOG.debug("Scanning WEB-INF/classes", new Object[0]);
        HashSet<AnnotationParser.AbstractHandler> handlers = new HashSet<AnnotationParser.AbstractHandler>();
        handlers.addAll(this._discoverableAnnotationHandlers);
        if (this._classInheritanceHandler != null) {
            handlers.add(this._classInheritanceHandler);
        }
        handlers.addAll(this._containerInitializerAnnotationHandlers);
        for (Resource dir : context.getMetaData().getWebInfClassesDirs()) {
            if (this._parserTasks != null) {
                this._parserTasks.add(new ParserTask(parser, handlers, dir, this._webAppClassNameResolver));
                continue;
            }
            parser.parse(handlers, dir, (ClassNameResolver)this._webAppClassNameResolver);
        }
    }

    public FragmentDescriptor getFragmentFromJar(Resource jar, List<FragmentDescriptor> frags) throws Exception {
        FragmentDescriptor d = null;
        for (FragmentDescriptor frag : frags) {
            Resource fragResource = frag.getResource();
            if (!Resource.isContainedIn(fragResource, jar)) continue;
            d = frag;
            break;
        }
        return d;
    }

    public boolean isMetaDataComplete(WebDescriptor d) {
        return d != null && d.getMetaDataComplete() == MetaDataComplete.True;
    }

    public class ContainerClassNameResolver
    implements ClassNameResolver {
        private WebAppContext _context;

        public ContainerClassNameResolver(WebAppContext context) {
            this._context = context;
        }

        @Override
        public boolean isExcluded(String name) {
            if (this._context.isSystemClass(name)) {
                return false;
            }
            return this._context.isServerClass(name);
        }

        @Override
        public boolean shouldOverride(String name) {
            return this._context.isParentLoaderPriority();
        }
    }

    public class WebAppClassNameResolver
    implements ClassNameResolver {
        private WebAppContext _context;

        public WebAppClassNameResolver(WebAppContext context) {
            this._context = context;
        }

        @Override
        public boolean isExcluded(String name) {
            if (this._context.isSystemClass(name)) {
                return true;
            }
            if (this._context.isServerClass(name)) {
                return false;
            }
            return false;
        }

        @Override
        public boolean shouldOverride(String name) {
            return !this._context.isParentLoaderPriority();
        }
    }

    public class ParserTask
    implements Callable<Void> {
        protected Exception _exception;
        protected final AnnotationParser _parser;
        protected final Set<? extends AnnotationParser.Handler> _handlers;
        protected final ClassNameResolver _resolver;
        protected final Resource _resource;

        public ParserTask(AnnotationParser parser, Set<? extends AnnotationParser.Handler> handlers, Resource resource, ClassNameResolver resolver) {
            this._parser = parser;
            this._handlers = handlers;
            this._resolver = resolver;
            this._resource = resource;
        }

        @Override
        public Void call() throws Exception {
            if (this._parser != null) {
                this._parser.parse(this._handlers, this._resource, this._resolver);
            }
            return null;
        }
    }
}

