/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadPendingException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.Callback;

public abstract class FillInterest {
    private final AtomicBoolean _interested = new AtomicBoolean(false);
    private volatile Callback _callback;

    protected FillInterest() {
    }

    public <C> void register(Callback callback) throws ReadPendingException {
        if (!this._interested.compareAndSet(false, true)) {
            throw new ReadPendingException();
        }
        this._callback = callback;
        try {
            if (this.needsFill()) {
                this.fillable();
            }
        }
        catch (IOException e) {
            this.onFail(e);
        }
    }

    public void fillable() {
        if (this._interested.compareAndSet(true, false)) {
            Callback callback = this._callback;
            this._callback = null;
            callback.succeeded();
        }
    }

    public boolean isInterested() {
        return this._interested.get();
    }

    public void onFail(Throwable cause) {
        if (this._interested.compareAndSet(true, false)) {
            Callback callback = this._callback;
            this._callback = null;
            callback.failed(cause);
        }
    }

    public void onClose() {
        if (this._interested.compareAndSet(true, false)) {
            Callback callback = this._callback;
            this._callback = null;
            callback.failed(new ClosedChannelException());
        }
    }

    public String toString() {
        return String.format("FillInterest@%x{%b,%s}", this.hashCode(), this._interested.get(), this._callback);
    }

    protected abstract boolean needsFill() throws IOException;
}

