/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.ConnectionState;

public class IOState {
    private static final Logger LOG = Log.getLogger(IOState.class);
    private ConnectionState state = ConnectionState.CONNECTING;
    private final AtomicBoolean inputClosed = new AtomicBoolean(false);
    private final AtomicBoolean outputClosed = new AtomicBoolean(false);
    private final AtomicBoolean cleanClose;
    private final AtomicBoolean remoteCloseInitiated = new AtomicBoolean(false);
    private final AtomicBoolean localCloseInitiated = new AtomicBoolean(false);

    public IOState() {
        this.cleanClose = new AtomicBoolean(false);
    }

    public void assertInputOpen() throws IOException {
        if (this.isInputClosed()) {
            throw new IOException("Connection input is closed");
        }
    }

    public void assertOutputOpen() throws IOException {
        if (this.isOutputClosed()) {
            throw new IOException("Connection output is closed");
        }
    }

    public boolean awaitClosed(long duration) {
        return this.isInputClosed() && this.isOutputClosed();
    }

    public ConnectionState getConnectionState() {
        return this.state;
    }

    public ConnectionState getState() {
        return this.state;
    }

    public boolean isClosed() {
        return this.isInputClosed() && this.isOutputClosed();
    }

    public boolean isCloseInitiated() {
        return this.remoteCloseInitiated.get() || this.localCloseInitiated.get();
    }

    public boolean isInputClosed() {
        return this.inputClosed.get();
    }

    public boolean isOpen() {
        return this.getState() != ConnectionState.CLOSED;
    }

    public boolean isOutputClosed() {
        return this.outputClosed.get();
    }

    public boolean onCloseHandshake(boolean incoming) {
        boolean in = this.inputClosed.get();
        boolean out = this.outputClosed.get();
        if (incoming) {
            in = true;
            this.inputClosed.set(true);
            if (!this.localCloseInitiated.get()) {
                this.remoteCloseInitiated.set(true);
            }
        } else {
            out = true;
            this.outputClosed.set(true);
            if (!this.remoteCloseInitiated.get()) {
                this.localCloseInitiated.set(true);
            }
        }
        LOG.debug("onCloseHandshake({}), input={}, output={}", incoming, in, out);
        if (in && out) {
            LOG.debug("Close Handshake satisfied, disconnecting", new Object[0]);
            this.cleanClose.set(true);
            return true;
        }
        return false;
    }

    public void setConnectionState(ConnectionState connectionState) {
        this.state = connectionState;
    }

    public void setState(ConnectionState state) {
        this.state = state;
    }

    public boolean wasCleanClose() {
        return this.cleanClose.get();
    }

    public boolean wasLocalCloseInitiated() {
        return this.localCloseInitiated.get();
    }

    public boolean wasRemoteCloseInitiated() {
        return this.remoteCloseInitiated.get();
    }
}

