/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ForkInvoker;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.io.IOState;
import org.eclipse.jetty.websocket.common.io.WriteBytesProvider;
import org.eclipse.jetty.websocket.common.io.WriteCallbackWrapper;

public abstract class AbstractWebSocketConnection
extends AbstractConnection
implements LogicalConnection {
    private static final Logger LOG = Log.getLogger(AbstractWebSocketConnection.class);
    private static final int MIN_BUFFER_SIZE = 28;
    private final ForkInvoker<Callback> invoker = new FlushInvoker();
    private final ByteBufferPool bufferPool;
    private final Scheduler scheduler;
    private final Generator generator;
    private final Parser parser;
    private final WebSocketPolicy policy;
    private final WriteBytesProvider writeBytes;
    private final AtomicBoolean suspendToken;
    private WebSocketSession session;
    private List<ExtensionConfig> extensions;
    private boolean flushing;
    private boolean isFilling;
    private IOState ioState;
    private Stats stats = new Stats();

    public AbstractWebSocketConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy policy, ByteBufferPool bufferPool) {
        super(endp, executor, true);
        this.policy = policy;
        this.bufferPool = bufferPool;
        this.generator = new Generator(policy, bufferPool);
        this.parser = new Parser(policy, bufferPool);
        this.scheduler = scheduler;
        this.extensions = new ArrayList<ExtensionConfig>();
        this.suspendToken = new AtomicBoolean(false);
        this.ioState = new IOState();
        this.ioState.setState(ConnectionState.CONNECTING);
        this.writeBytes = new WriteBytesProvider(this.generator, new FlushCallback());
        this.setInputBufferSize(policy.getInputBufferSize());
    }

    @Override
    public void close() {
        this.close(1000, null);
    }

    @Override
    public void close(int statusCode, String reason) {
        this.enqueClose(statusCode, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(Callback callback) {
        LOG.debug("complete({})", callback);
        WriteBytesProvider writeBytesProvider = this.writeBytes;
        synchronized (writeBytesProvider) {
            this.flushing = false;
        }
        if (!this.ioState.isOpen() || callback == null) {
            return;
        }
        this.invoker.invoke(callback);
    }

    @Override
    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean onlyOutput) {
        this.ioState.setState(ConnectionState.CLOSED);
        EndPoint endPoint = this.getEndPoint();
        LOG.debug("Shutting down output {}", endPoint);
        endPoint.shutdownOutput();
        if (!onlyOutput) {
            LOG.debug("Closing {}", endPoint);
            endPoint.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueClose(int statusCode, String reason) {
        WriteBytesProvider writeBytesProvider = this.writeBytes;
        synchronized (writeBytesProvider) {
            if (this.writeBytes.isClosed()) {
                return;
            }
        }
        CloseInfo close = new CloseInfo(statusCode, reason);
        this.outgoingFrame(close.asFrame(), new OnCloseCallback());
    }

    private void execute(Runnable task) {
        try {
            this.getExecutor().execute(task);
        }
        catch (RejectedExecutionException e) {
            LOG.debug("Job not dispatched: {}", task);
        }
    }

    @Override
    public void fillInterested() {
        this.stats.countFillInterestedEvents.incrementAndGet();
        super.fillInterested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ByteBuffer buffer = null;
        WriteBytesProvider writeBytesProvider = this.writeBytes;
        synchronized (writeBytesProvider) {
            if (this.writeBytes.isFailed()) {
                LOG.debug(".flush() - queue is in failed state", new Object[0]);
                return;
            }
            if (this.flushing) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(".flush() - flushing={} - writeBytes={}", this.flushing, this.writeBytes);
            }
            if (!this.isOpen()) {
                this.writeBytes.failAll(new WebSocketException("Connection closed"));
                return;
            }
            buffer = this.writeBytes.getByteBuffer();
            if (buffer == null) {
                return;
            }
            this.flushing = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushing {} - {}", BufferUtil.toDetailString(buffer), this.writeBytes);
            }
        }
        this.write(buffer);
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    @Override
    public IOState getIOState() {
        return this.ioState;
    }

    public Parser getParser() {
        return this.parser;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public WebSocketSession getSession() {
        return this.session;
    }

    public Stats getStats() {
        return this.stats;
    }

    @Override
    public boolean isOpen() {
        return this.getIOState().isOpen() && this.getEndPoint().isOpen();
    }

    @Override
    public boolean isReading() {
        return this.isFilling;
    }

    @Override
    public void onClose() {
        super.onClose();
        this.getIOState().setState(ConnectionState.CLOSED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillable() {
        LOG.debug("{} onFillable()", new Object[]{this.policy.getBehavior()});
        this.stats.countOnFillableEvents.incrementAndGet();
        ByteBuffer buffer = this.bufferPool.acquire(this.getInputBufferSize(), false);
        BufferUtil.clear(buffer);
        boolean readMore = false;
        try {
            this.isFilling = true;
            readMore = this.read(buffer) != -1;
        }
        finally {
            this.bufferPool.release(buffer);
        }
        if (readMore && !this.suspendToken.get()) {
            this.fillInterested();
        } else {
            this.isFilling = false;
        }
    }

    @Override
    protected void onFillInterestedFailed(Throwable cause) {
        LOG.ignore(cause);
        this.stats.countFillInterestedEvents.incrementAndGet();
        super.onFillInterestedFailed(cause);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.ioState.setState(ConnectionState.OPEN);
        LOG.debug("fillInterested", new Object[0]);
        this.fillInterested();
    }

    @Override
    protected boolean onReadTimeout() {
        LOG.warn("Read Timeout", new Object[0]);
        IOState state = this.getIOState();
        if (state.getState() == ConnectionState.CLOSING || state.getState() == ConnectionState.CLOSED) {
            return true;
        }
        this.session.close(1000, "Idle Timeout");
        return false;
    }

    public void onWriteWebSocketClose() {
        if (this.ioState.onCloseHandshake(false)) {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("outgoingFrame({}, {})", frame, callback);
        }
        if (!this.isOpen()) {
            return;
        }
        WriteBytesProvider writeBytesProvider = this.writeBytes;
        synchronized (writeBytesProvider) {
            this.writeBytes.enqueue(frame, WriteCallbackWrapper.wrap(callback));
        }
        this.flush();
    }

    private int read(ByteBuffer buffer) {
        EndPoint endPoint = this.getEndPoint();
        try {
            while (true) {
                int filled;
                if ((filled = endPoint.fill(buffer)) == 0) {
                    return 0;
                }
                if (filled < 0) {
                    LOG.debug("read - EOF Reached", new Object[0]);
                    return -1;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled {} bytes - {}", filled, BufferUtil.toDetailString(buffer));
                }
                this.parser.parse(buffer);
            }
        }
        catch (IOException e) {
            LOG.warn(e);
            this.enqueClose(1002, e.getMessage());
            return -1;
        }
        catch (CloseException e) {
            LOG.warn(e);
            this.enqueClose(e.getStatusCode(), e.getMessage());
            return -1;
        }
    }

    @Override
    public void resume() {
        if (this.suspendToken.getAndSet(false)) {
            this.fillInterested();
        }
    }

    public void setExtensions(List<ExtensionConfig> extensions) {
        this.extensions = extensions;
    }

    @Override
    public void setInputBufferSize(int inputBufferSize) {
        if (inputBufferSize < 28) {
            throw new IllegalArgumentException("Cannot have buffer size less than 28");
        }
        super.setInputBufferSize(inputBufferSize);
    }

    @Override
    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    @Override
    public SuspendToken suspend() {
        this.suspendToken.set(true);
        return this;
    }

    @Override
    public String toString() {
        return String.format("%s{g=%s,p=%s}", super.toString(), this.generator, this.parser);
    }

    private <C> void write(ByteBuffer buffer) {
        EndPoint endpoint = this.getEndPoint();
        if (!this.isOpen()) {
            this.writeBytes.failAll(new IOException("Connection closed"));
            return;
        }
        try {
            endpoint.write(this.writeBytes, buffer);
        }
        catch (Throwable t) {
            this.writeBytes.failed(t);
        }
    }

    public static class Stats {
        private AtomicLong countFillInterestedEvents = new AtomicLong(0L);
        private AtomicLong countOnFillableEvents = new AtomicLong(0L);
        private AtomicLong countFillableErrors = new AtomicLong(0L);

        public long getFillableErrorCount() {
            return this.countFillableErrors.get();
        }

        public long getFillInterestedCount() {
            return this.countFillInterestedEvents.get();
        }

        public long getOnFillableCount() {
            return this.countOnFillableEvents.get();
        }
    }

    private class OnCloseCallback
    implements WriteCallback {
        private OnCloseCallback() {
        }

        @Override
        public void writeFailed(Throwable x) {
            AbstractWebSocketConnection.this.disconnect();
        }

        @Override
        public void writeSuccess() {
            AbstractWebSocketConnection.this.onWriteWebSocketClose();
        }
    }

    private class FlushInvoker
    extends ForkInvoker<Callback> {
        private FlushInvoker() {
            super(4);
        }

        @Override
        public void call(Callback callback) {
            AbstractWebSocketConnection.this.flush();
        }

        @Override
        public void fork(Callback callback) {
            AbstractWebSocketConnection.this.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractWebSocketConnection.this.flush();
                }
            });
        }

        public String toString() {
            return String.format("%s@%x", FlushInvoker.class.getSimpleName(), this.hashCode());
        }
    }

    private class FlushCallback
    implements Callback {
        private FlushCallback() {
        }

        @Override
        public void failed(Throwable x) {
            LOG.warn("Write flush failure", x);
        }

        @Override
        public void succeeded() {
            AbstractWebSocketConnection.this.complete(AbstractWebSocketConnection.this.writeBytes);
        }
    }
}

