/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.servlet;

import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public abstract class WebSocketServlet
extends HttpServlet {
    private WebSocketServletFactory factory;

    public abstract void configure(WebSocketServletFactory var1);

    @Override
    public void destroy() {
        this.factory.cleanup();
    }

    @Override
    public void init() throws ServletException {
        try {
            WebSocketServletFactory baseFactory;
            Iterator<WebSocketServletFactory> factories;
            WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            String max = this.getInitParameter("maxIdleTime");
            if (max != null) {
                policy.setIdleTimeout(Long.parseLong(max));
            }
            if ((max = this.getInitParameter("maxMessageSize")) != null) {
                policy.setMaxMessageSize(Long.parseLong(max));
            }
            if ((max = this.getInitParameter("inputBufferSize")) != null) {
                policy.setInputBufferSize(Integer.parseInt(max));
            }
            if ((factories = ServiceLoader.load(WebSocketServletFactory.class).iterator()).hasNext()) {
                baseFactory = factories.next();
            } else {
                Class<?> wssf = this.getServletContext().getClass().getClassLoader().loadClass("org.eclipse.jetty.websocket.server.WebSocketServerFactory");
                baseFactory = (WebSocketServletFactory)wssf.newInstance();
            }
            this.factory = baseFactory.createFactory(policy);
            this.configure(this.factory);
            this.factory.init();
        }
        catch (Exception x) {
            throw new ServletException(x);
        }
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.factory.isUpgradeRequest(request, response)) {
            if (this.factory.acceptWebSocket(request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.service(request, response);
    }
}

