/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.HashSet;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;

public class HttpField {
    public static final Trie<HttpField> CACHE = new Trie(768);
    public static final Trie<HttpField> CONTENT_TYPE = new Trie(512);
    private static final byte[] __colon_space;
    private final HttpHeader _header;
    private final String _name;
    private final String _value;

    public HttpField(HttpHeader header, String name, String value) {
        this._header = header;
        this._name = name;
        this._value = value;
    }

    public HttpField(HttpHeader header, String value) {
        this(header, header.asString(), value);
    }

    public HttpField(HttpHeader header, HttpHeaderValue value) {
        this(header, header.asString(), value.asString());
    }

    public HttpField(String name, String value) {
        this(HttpHeader.CACHE.get(name), name, value);
    }

    public HttpHeader getHeader() {
        return this._header;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public boolean contains(String value) {
        String[] split;
        if (this._value == null) {
            return false;
        }
        if (value.equalsIgnoreCase(this._value)) {
            return true;
        }
        for (String s : split = this._value.split("\\s*,\\s*")) {
            if (!value.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public int getIntValue() {
        return StringUtil.toInt(this._value);
    }

    public long getLongValue() {
        return StringUtil.toLong(this._value);
    }

    private static byte[] toSanitisedName(String s) {
        byte[] bytes = s.getBytes(StringUtil.__ISO_8859_1_CHARSET);
        int i = bytes.length;
        while (i-- > 0) {
            switch (bytes[i]) {
                case 10: 
                case 13: 
                case 58: {
                    bytes[i] = 63;
                }
            }
        }
        return bytes;
    }

    private static byte[] toSanitisedValue(String s) {
        byte[] bytes = s.getBytes(StringUtil.__ISO_8859_1_CHARSET);
        int i = bytes.length;
        while (i-- > 0) {
            switch (bytes[i]) {
                case 10: 
                case 13: {
                    bytes[i] = 63;
                }
            }
        }
        return bytes;
    }

    public void putTo(ByteBuffer bufferInFillMode) {
        if (this._header != null) {
            bufferInFillMode.put(this._header.getBytesColonSpace());
            bufferInFillMode.put(HttpField.toSanitisedValue(this._value));
        } else {
            bufferInFillMode.put(HttpField.toSanitisedName(this._name));
            bufferInFillMode.put(__colon_space);
            bufferInFillMode.put(HttpField.toSanitisedValue(this._value));
        }
        BufferUtil.putCRLF(bufferInFillMode);
    }

    public void putValueTo(ByteBuffer buffer) {
        buffer.put(HttpField.toSanitisedValue(this._value));
    }

    public String toString() {
        String v = this.getValue();
        return this.getName() + ": " + (v == null ? "" : v.toString());
    }

    public boolean isSame(HttpField field) {
        if (field == null) {
            return false;
        }
        if (field == this) {
            return true;
        }
        if (this._header != null && this._header == field.getHeader()) {
            return true;
        }
        return this._name.equalsIgnoreCase(field.getName());
    }

    static {
        CACHE.put(new CachedHttpField(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE));
        CACHE.put(new CachedHttpField(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE));
        CACHE.put(new CachedHttpField(HttpHeader.CONNECTION, HttpHeaderValue.UPGRADE));
        CACHE.put(new CachedHttpField(HttpHeader.ACCEPT_ENCODING, "gzip, deflate"));
        CACHE.put(new CachedHttpField(HttpHeader.ACCEPT_LANGUAGE, "en-US,en;q=0.5"));
        CACHE.put(new CachedHttpField(HttpHeader.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"));
        CACHE.put(new CachedHttpField(HttpHeader.PRAGMA, "no-cache"));
        CACHE.put(new CachedHttpField(HttpHeader.CACHE_CONTROL, "private, no-cache, no-cache=Set-Cookie, proxy-revalidate"));
        CACHE.put(new CachedHttpField(HttpHeader.CACHE_CONTROL, "no-cache"));
        CACHE.put(new CachedHttpField(HttpHeader.CONTENT_LENGTH, "0"));
        CACHE.put(new CachedHttpField(HttpHeader.CONTENT_ENCODING, "gzip"));
        CACHE.put(new CachedHttpField(HttpHeader.CONTENT_ENCODING, "deflate"));
        CACHE.put(new CachedHttpField(HttpHeader.EXPIRES, "Fri, 01 Jan 1990 00:00:00 GMT"));
        CACHE.put(new CachedHttpField(HttpHeader.USER_AGENT, "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:17.0) Gecko/17.0 Firefox/17.0"));
        for (String type : new String[]{"text/plain", "text/html", "text/xml", "text/json", "application/x-www-form-urlencoded"}) {
            CachedHttpField field = new CachedHttpField(HttpHeader.CONTENT_TYPE, type);
            CACHE.put(field);
            CONTENT_TYPE.put(type, field);
            for (String charset : new String[]{"UTF-8", "ISO-8859-1"}) {
                String type_charset = type + "; charset=" + charset;
                field = new CachedHttpField(HttpHeader.CONTENT_TYPE, type_charset);
                CACHE.put(field);
                CACHE.put(new CachedHttpField(HttpHeader.CONTENT_TYPE, type + ";charset=" + charset));
                CONTENT_TYPE.put(type_charset, field);
                CONTENT_TYPE.put(type + ";charset=" + charset, field);
            }
        }
        HashSet<HttpHeader> headers = new HashSet<HttpHeader>();
        for (String key : CACHE.keySet()) {
            headers.add(CACHE.get(key).getHeader());
        }
        for (HttpHeader h : headers) {
            if (CACHE.put(new HttpField(h, (String)null))) continue;
            throw new IllegalStateException("CACHE FULL");
        }
        __colon_space = new byte[]{58, 32};
    }

    public static class CachedHttpField
    extends HttpField {
        final byte[] _bytes;

        public CachedHttpField(HttpHeader header, String value) {
            super(header, value);
            this._bytes = new byte[header.asString().length() + 2 + value.length() + 2];
            System.arraycopy(header.getBytesColonSpace(), 0, this._bytes, 0, header.asString().length() + 2);
            System.arraycopy(HttpField.toSanitisedValue(value), 0, this._bytes, header.asString().length() + 2, value.length());
            this._bytes[this._bytes.length - 2] = 13;
            this._bytes[this._bytes.length - 1] = 10;
        }

        CachedHttpField(HttpHeader header, HttpHeaderValue value) {
            this(header, value.asString());
        }

        @Override
        public void putTo(ByteBuffer bufferInFillMode) {
            bufferInFillMode.put(this._bytes);
        }
    }
}

