/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;

public interface HttpURI {
    public static Mutable build() {
        return new Mutable();
    }

    public static Mutable build(HttpURI uri) {
        return new Mutable(uri);
    }

    public static Mutable build(HttpURI uri, String pathQuery) {
        return new Mutable(uri, pathQuery);
    }

    public static Mutable build(HttpURI uri, String path, String param, String query) {
        return new Mutable(uri, path, param, query);
    }

    public static Mutable build(URI uri) {
        return new Mutable(uri);
    }

    public static Mutable build(String uri) {
        return new Mutable(uri);
    }

    public static Immutable from(URI uri) {
        return new Mutable(uri).asImmutable();
    }

    public static Immutable from(String uri) {
        return new Mutable(uri).asImmutable();
    }

    public static Immutable from(String method, String uri) {
        if (HttpMethod.CONNECT.is(method)) {
            return new Immutable(uri);
        }
        if (uri.startsWith("/")) {
            return HttpURI.build().pathQuery(uri).asImmutable();
        }
        return HttpURI.from(uri);
    }

    public static Immutable from(String scheme, String host, int port, String pathQuery) {
        return new Mutable(scheme, host, port, pathQuery).asImmutable();
    }

    public Immutable asImmutable();

    public String asString();

    public String getAuthority();

    public String getDecodedPath();

    public String getFragment();

    public String getHost();

    public String getParam();

    public String getPath();

    public String getPathQuery();

    public int getPort();

    public String getQuery();

    public String getScheme();

    public String getUser();

    public boolean hasAuthority();

    public boolean isAbsolute();

    public boolean isAmbiguous();

    public boolean hasAmbiguousSegment();

    public boolean hasAmbiguousSeparator();

    public boolean hasAmbiguousParameter();

    public boolean hasAmbiguousEncoding();

    default public URI toURI() {
        try {
            String query = this.getQuery();
            return new URI(this.getScheme(), null, this.getHost(), this.getPort(), this.getPath(), query == null ? null : UrlEncoded.decodeString(query), null);
        }
        catch (URISyntaxException x) {
            throw new RuntimeException(x);
        }
    }

    public static class Mutable
    implements HttpURI {
        private static final Index<Boolean> __ambiguousSegments = new Index.Builder().caseSensitive(false).with("%2e", Boolean.TRUE).with("%2e%2e", Boolean.TRUE).with(".%2e", Boolean.TRUE).with("%2e.", Boolean.TRUE).with("..", Boolean.FALSE).with(".", Boolean.FALSE).build();
        private String _scheme;
        private String _user;
        private String _host;
        private int _port;
        private String _path;
        private String _param;
        private String _query;
        private String _fragment;
        private String _uri;
        private String _decodedPath;
        private final EnumSet<Ambiguous> _ambiguous = EnumSet.noneOf(Ambiguous.class);

        private Mutable() {
        }

        private Mutable(HttpURI uri) {
            this.uri(uri);
        }

        private Mutable(HttpURI baseURI, String pathQuery) {
            this._uri = null;
            this._scheme = baseURI.getScheme();
            this._user = baseURI.getUser();
            this._host = baseURI.getHost();
            this._port = baseURI.getPort();
            if (pathQuery != null) {
                this.parse(State.PATH, pathQuery);
            }
        }

        private Mutable(HttpURI baseURI, String path, String param, String query) {
            this._uri = null;
            this._scheme = baseURI.getScheme();
            this._user = baseURI.getUser();
            this._host = baseURI.getHost();
            this._port = baseURI.getPort();
            if (path != null) {
                this.parse(State.PATH, path);
            }
            if (param != null) {
                this._param = param;
            }
            if (query != null) {
                this._query = query;
            }
        }

        private Mutable(String uri) {
            this._port = -1;
            this.parse(State.START, uri);
        }

        private Mutable(URI uri) {
            this._uri = null;
            this._scheme = uri.getScheme();
            this._host = uri.getHost();
            if (this._host == null && uri.getRawSchemeSpecificPart().startsWith("//")) {
                this._host = "";
            }
            this._port = uri.getPort();
            this._user = uri.getUserInfo();
            String path = uri.getRawPath();
            if (path != null) {
                this.parse(State.PATH, path);
            }
            this._query = uri.getRawQuery();
            this._fragment = uri.getRawFragment();
        }

        private Mutable(String scheme, String host, int port, String pathQuery) {
            this._uri = null;
            this._scheme = scheme;
            this._host = host;
            this._port = port;
            if (pathQuery != null) {
                this.parse(State.PATH, pathQuery);
            }
        }

        @Override
        public Immutable asImmutable() {
            return new Immutable(this);
        }

        @Override
        public String asString() {
            return this.asImmutable().toString();
        }

        public Mutable authority(String host, int port) {
            this._user = null;
            this._host = host;
            this._port = port;
            this._uri = null;
            return this;
        }

        public Mutable authority(String hostport) {
            HostPort hp = new HostPort(hostport);
            this._user = null;
            this._host = hp.getHost();
            this._port = hp.getPort();
            this._uri = null;
            return this;
        }

        public Mutable clear() {
            this._scheme = null;
            this._user = null;
            this._host = null;
            this._port = -1;
            this._path = null;
            this._param = null;
            this._query = null;
            this._fragment = null;
            this._uri = null;
            this._decodedPath = null;
            this._ambiguous.clear();
            return this;
        }

        public Mutable decodedPath(String path) {
            this._uri = null;
            this._path = URIUtil.encodePath(path);
            this._decodedPath = path;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpURI)) {
                return false;
            }
            return this.asString().equals(((HttpURI)o).asString());
        }

        public Mutable fragment(String fragment) {
            this._fragment = fragment;
            return this;
        }

        @Override
        public String getAuthority() {
            if (this._port > 0) {
                return this._host + ":" + this._port;
            }
            return this._host;
        }

        @Override
        public String getDecodedPath() {
            if (this._decodedPath == null && this._path != null) {
                this._decodedPath = URIUtil.canonicalPath(URIUtil.decodePath(this._path));
            }
            return this._decodedPath;
        }

        @Override
        public String getFragment() {
            return this._fragment;
        }

        @Override
        public String getHost() {
            return this._host;
        }

        @Override
        public String getParam() {
            return this._param;
        }

        @Override
        public String getPath() {
            return this._path;
        }

        @Override
        public String getPathQuery() {
            if (this._query == null) {
                return this._path;
            }
            return this._path + "?" + this._query;
        }

        @Override
        public int getPort() {
            return this._port;
        }

        @Override
        public String getQuery() {
            return this._query;
        }

        @Override
        public String getScheme() {
            return this._scheme;
        }

        @Override
        public String getUser() {
            return this._user;
        }

        @Override
        public boolean hasAuthority() {
            return this._host != null;
        }

        public int hashCode() {
            return this.asString().hashCode();
        }

        public Mutable host(String host) {
            this._host = host;
            this._uri = null;
            return this;
        }

        @Override
        public boolean isAbsolute() {
            return this._scheme != null && !this._scheme.isEmpty();
        }

        @Override
        public boolean isAmbiguous() {
            return !this._ambiguous.isEmpty();
        }

        @Override
        public boolean hasAmbiguousSegment() {
            return this._ambiguous.contains((Object)Ambiguous.SEGMENT);
        }

        @Override
        public boolean hasAmbiguousSeparator() {
            return this._ambiguous.contains((Object)Ambiguous.SEPARATOR);
        }

        @Override
        public boolean hasAmbiguousParameter() {
            return this._ambiguous.contains((Object)Ambiguous.PARAM);
        }

        @Override
        public boolean hasAmbiguousEncoding() {
            return this._ambiguous.contains((Object)Ambiguous.ENCODING);
        }

        public Mutable normalize() {
            HttpScheme scheme;
            HttpScheme httpScheme = scheme = this._scheme == null ? null : HttpScheme.CACHE.get(this._scheme);
            if (scheme != null && this._port == scheme.getDefaultPort()) {
                this._port = 0;
                this._uri = null;
            }
            return this;
        }

        public Mutable param(String param) {
            this._param = param;
            if (this._path != null && this._param != null && !this._path.contains(this._param)) {
                this._path = this._path + ";" + this._param;
            }
            this._uri = null;
            return this;
        }

        public Mutable path(String path) {
            this._uri = null;
            this._path = path;
            this._decodedPath = null;
            return this;
        }

        public Mutable pathQuery(String pathQuery) {
            this._uri = null;
            this._path = null;
            this._decodedPath = null;
            this._param = null;
            this._query = null;
            if (pathQuery != null) {
                this.parse(State.PATH, pathQuery);
            }
            return this;
        }

        public Mutable port(int port) {
            this._port = port;
            this._uri = null;
            return this;
        }

        public Mutable query(String query) {
            this._query = query;
            this._uri = null;
            return this;
        }

        public Mutable scheme(HttpScheme scheme) {
            return this.scheme(scheme.asString());
        }

        public Mutable scheme(String scheme) {
            this._scheme = scheme;
            this._uri = null;
            return this;
        }

        public String toString() {
            return this.asString();
        }

        @Override
        public URI toURI() {
            try {
                return new URI(this._scheme, null, this._host, this._port, this._path, this._query == null ? null : UrlEncoded.decodeString(this._query), null);
            }
            catch (URISyntaxException x) {
                throw new RuntimeException(x);
            }
        }

        public Mutable uri(HttpURI uri) {
            this._scheme = uri.getScheme();
            this._user = uri.getUser();
            this._host = uri.getHost();
            this._port = uri.getPort();
            this._path = uri.getPath();
            this._param = uri.getParam();
            this._query = uri.getQuery();
            this._uri = null;
            this._decodedPath = uri.getDecodedPath();
            if (uri.hasAmbiguousSeparator()) {
                this._ambiguous.add(Ambiguous.SEPARATOR);
            }
            if (uri.hasAmbiguousSegment()) {
                this._ambiguous.add(Ambiguous.SEGMENT);
            }
            return this;
        }

        public Mutable uri(String uri) {
            this.clear();
            this._uri = uri;
            this.parse(State.START, uri);
            return this;
        }

        public Mutable uri(String method, String uri) {
            if (HttpMethod.CONNECT.is(method)) {
                this.clear();
                this._uri = uri;
                this._path = uri;
            } else if (uri.startsWith("/")) {
                this.clear();
                this.pathQuery(uri);
            } else {
                this.uri(uri);
            }
            return this;
        }

        public Mutable uri(String uri, int offset, int length) {
            this.clear();
            int end = offset + length;
            this._uri = uri.substring(offset, end);
            this.parse(State.START, uri);
            return this;
        }

        public Mutable user(String user) {
            this._user = user;
            this._uri = null;
            return this;
        }

        private void parse(State state, String uri) {
            int mark = 0;
            int pathMark = 0;
            int segment = 0;
            boolean encoded = false;
            boolean dot = false;
            int escapedTwo = 0;
            int end = uri.length();
            block72: for (int i = 0; i < end; ++i) {
                char c = uri.charAt(i);
                switch (state) {
                    case START: {
                        switch (c) {
                            case '/': {
                                mark = i;
                                state = State.HOST_OR_PATH;
                                continue block72;
                            }
                            case ';': {
                                mark = i + 1;
                                state = State.PARAM;
                                continue block72;
                            }
                            case '?': {
                                this._path = "";
                                mark = i + 1;
                                state = State.QUERY;
                                continue block72;
                            }
                            case '#': {
                                mark = i + 1;
                                state = State.FRAGMENT;
                                continue block72;
                            }
                            case '*': {
                                this._path = "*";
                                state = State.ASTERISK;
                                continue block72;
                            }
                            case '%': {
                                encoded = true;
                                escapedTwo = 1;
                                pathMark = segment = i;
                                mark = segment;
                                state = State.PATH;
                                continue block72;
                            }
                            case '.': {
                                dot = true;
                                pathMark = segment = i;
                                state = State.PATH;
                                continue block72;
                            }
                        }
                        mark = i;
                        if (this._scheme == null) {
                            state = State.SCHEME_OR_PATH;
                            continue block72;
                        }
                        pathMark = segment = i;
                        state = State.PATH;
                        continue block72;
                    }
                    case SCHEME_OR_PATH: {
                        switch (c) {
                            case ':': {
                                this._scheme = uri.substring(mark, i);
                                state = State.START;
                                continue block72;
                            }
                            case '/': {
                                segment = i + 1;
                                state = State.PATH;
                                continue block72;
                            }
                            case ';': {
                                mark = i + 1;
                                state = State.PARAM;
                                continue block72;
                            }
                            case '?': {
                                this._path = uri.substring(mark, i);
                                mark = i + 1;
                                state = State.QUERY;
                                continue block72;
                            }
                            case '%': {
                                encoded = true;
                                escapedTwo = 1;
                                state = State.PATH;
                                continue block72;
                            }
                            case '#': {
                                this._path = uri.substring(mark, i);
                                state = State.FRAGMENT;
                                continue block72;
                            }
                        }
                        continue block72;
                    }
                    case HOST_OR_PATH: {
                        switch (c) {
                            case '/': {
                                this._host = "";
                                mark = i + 1;
                                state = State.HOST;
                                continue block72;
                            }
                            case '#': 
                            case '%': 
                            case '.': 
                            case ';': 
                            case '?': 
                            case '@': {
                                --i;
                                pathMark = mark;
                                segment = mark + 1;
                                state = State.PATH;
                                continue block72;
                            }
                        }
                        pathMark = mark;
                        segment = mark + 1;
                        state = State.PATH;
                        continue block72;
                    }
                    case HOST: {
                        switch (c) {
                            case '/': {
                                this._host = uri.substring(mark, i);
                                pathMark = mark = i;
                                segment = mark + 1;
                                state = State.PATH;
                                continue block72;
                            }
                            case ':': {
                                if (i > mark) {
                                    this._host = uri.substring(mark, i);
                                }
                                mark = i + 1;
                                state = State.PORT;
                                continue block72;
                            }
                            case '@': {
                                if (this._user != null) {
                                    throw new IllegalArgumentException("Bad authority");
                                }
                                this._user = uri.substring(mark, i);
                                mark = i + 1;
                                continue block72;
                            }
                            case '[': {
                                state = State.IPV6;
                                continue block72;
                            }
                        }
                        continue block72;
                    }
                    case IPV6: {
                        switch (c) {
                            case '/': {
                                throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
                            }
                            case ']': {
                                c = uri.charAt(++i);
                                this._host = uri.substring(mark, i);
                                if (c == ':') {
                                    mark = i + 1;
                                    state = State.PORT;
                                    continue block72;
                                }
                                pathMark = mark = i;
                                state = State.PATH;
                                continue block72;
                            }
                        }
                        continue block72;
                    }
                    case PORT: {
                        if (c == '@') {
                            if (this._user != null) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            this._user = this._host + ":" + uri.substring(mark, i);
                            mark = i + 1;
                            state = State.HOST;
                            continue block72;
                        }
                        if (c != '/') continue block72;
                        this._port = TypeUtil.parseInt(uri, mark, i - mark, 10);
                        pathMark = mark = i;
                        segment = i + 1;
                        state = State.PATH;
                        continue block72;
                    }
                    case PATH: {
                        switch (c) {
                            case ';': {
                                this.checkSegment(uri, segment, i, true);
                                mark = i + 1;
                                state = State.PARAM;
                                continue block72;
                            }
                            case '?': {
                                this.checkSegment(uri, segment, i, false);
                                this._path = uri.substring(pathMark, i);
                                mark = i + 1;
                                state = State.QUERY;
                                continue block72;
                            }
                            case '#': {
                                this.checkSegment(uri, segment, i, false);
                                this._path = uri.substring(pathMark, i);
                                mark = i + 1;
                                state = State.FRAGMENT;
                                continue block72;
                            }
                            case '/': {
                                this.checkSegment(uri, segment, i, false);
                                segment = i + 1;
                                continue block72;
                            }
                            case '.': {
                                dot |= segment == i;
                                continue block72;
                            }
                            case '%': {
                                encoded = true;
                                escapedTwo = 1;
                                continue block72;
                            }
                            case '2': {
                                escapedTwo = escapedTwo == 1 ? 2 : 0;
                                continue block72;
                            }
                            case 'F': 
                            case 'f': {
                                if (escapedTwo == 2) {
                                    this._ambiguous.add(Ambiguous.SEPARATOR);
                                }
                                escapedTwo = 0;
                                continue block72;
                            }
                            case '5': {
                                if (escapedTwo == 2) {
                                    this._ambiguous.add(Ambiguous.ENCODING);
                                }
                                escapedTwo = 0;
                                continue block72;
                            }
                        }
                        escapedTwo = 0;
                        continue block72;
                    }
                    case PARAM: {
                        switch (c) {
                            case '?': {
                                this._path = uri.substring(pathMark, i);
                                this._param = uri.substring(mark, i);
                                mark = i + 1;
                                state = State.QUERY;
                                continue block72;
                            }
                            case '#': {
                                this._path = uri.substring(pathMark, i);
                                this._param = uri.substring(mark, i);
                                mark = i + 1;
                                state = State.FRAGMENT;
                                continue block72;
                            }
                            case '/': {
                                encoded = true;
                                segment = i + 1;
                                state = State.PATH;
                                continue block72;
                            }
                            case ';': {
                                mark = i + 1;
                                continue block72;
                            }
                        }
                        continue block72;
                    }
                    case QUERY: {
                        if (c != '#') continue block72;
                        this._query = uri.substring(mark, i);
                        mark = i + 1;
                        state = State.FRAGMENT;
                        continue block72;
                    }
                    case ASTERISK: {
                        throw new IllegalArgumentException("Bad character '*'");
                    }
                    case FRAGMENT: {
                        this._fragment = uri.substring(mark, end);
                        i = end;
                        continue block72;
                    }
                    default: {
                        throw new IllegalStateException(state.toString());
                    }
                }
            }
            switch (state) {
                case START: 
                case ASTERISK: {
                    break;
                }
                case SCHEME_OR_PATH: 
                case HOST_OR_PATH: {
                    this._path = uri.substring(mark, end);
                    break;
                }
                case HOST: {
                    if (end <= mark) break;
                    this._host = uri.substring(mark, end);
                    break;
                }
                case IPV6: {
                    throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
                }
                case PORT: {
                    this._port = TypeUtil.parseInt(uri, mark, end - mark, 10);
                    break;
                }
                case PARAM: {
                    this._path = uri.substring(pathMark, end);
                    this._param = uri.substring(mark, end);
                    break;
                }
                case PATH: {
                    this.checkSegment(uri, segment, end, false);
                    this._path = uri.substring(pathMark, end);
                    break;
                }
                case QUERY: {
                    this._query = uri.substring(mark, end);
                    break;
                }
                case FRAGMENT: {
                    this._fragment = uri.substring(mark, end);
                    break;
                }
                default: {
                    throw new IllegalStateException(state.toString());
                }
            }
            if (!encoded && !dot) {
                this._decodedPath = this._param == null ? this._path : this._path.substring(0, this._path.length() - this._param.length() - 1);
            } else if (this._path != null) {
                String canonical = URIUtil.canonicalPath(this._path);
                if (canonical == null) {
                    throw new BadMessageException("Bad URI");
                }
                this._decodedPath = URIUtil.decodePath(canonical);
            }
        }

        private void checkSegment(String uri, int segment, int end, boolean param) {
            if (!this._ambiguous.contains((Object)Ambiguous.SEGMENT)) {
                Boolean ambiguous = __ambiguousSegments.get(uri, segment, end - segment);
                if (ambiguous == Boolean.TRUE) {
                    this._ambiguous.add(Ambiguous.SEGMENT);
                } else if (param && ambiguous == Boolean.FALSE) {
                    this._ambiguous.add(Ambiguous.PARAM);
                }
            }
        }

        private static enum State {
            START,
            HOST_OR_PATH,
            SCHEME_OR_PATH,
            HOST,
            IPV6,
            PORT,
            PATH,
            PARAM,
            QUERY,
            FRAGMENT,
            ASTERISK;

        }
    }

    public static class Immutable
    implements HttpURI {
        private final String _scheme;
        private final String _user;
        private final String _host;
        private final int _port;
        private final String _path;
        private final String _param;
        private final String _query;
        private final String _fragment;
        private String _uri;
        private String _decodedPath;
        private final EnumSet<Ambiguous> _ambiguous = EnumSet.noneOf(Ambiguous.class);

        private Immutable(Mutable builder) {
            this._scheme = builder._scheme;
            this._user = builder._user;
            this._host = builder._host;
            this._port = builder._port;
            this._path = builder._path;
            this._param = builder._param;
            this._query = builder._query;
            this._fragment = builder._fragment;
            this._uri = builder._uri;
            this._decodedPath = builder._decodedPath;
            this._ambiguous.addAll(builder._ambiguous);
        }

        private Immutable(String uri) {
            this._scheme = null;
            this._user = null;
            this._host = null;
            this._port = -1;
            this._path = uri;
            this._param = null;
            this._query = null;
            this._fragment = null;
            this._uri = uri;
            this._decodedPath = null;
        }

        @Override
        public Immutable asImmutable() {
            return this;
        }

        @Override
        public String asString() {
            if (this._uri == null) {
                StringBuilder out = new StringBuilder();
                if (this._scheme != null) {
                    out.append(this._scheme).append(':');
                }
                if (this._host != null) {
                    out.append("//");
                    if (this._user != null) {
                        out.append(this._user).append('@');
                    }
                    out.append(this._host);
                }
                if (this._port > 0) {
                    out.append(':').append(this._port);
                }
                if (this._path != null) {
                    out.append(this._path);
                }
                if (this._query != null) {
                    out.append('?').append(this._query);
                }
                if (this._fragment != null) {
                    out.append('#').append(this._fragment);
                }
                this._uri = out.length() > 0 ? out.toString() : "";
            }
            return this._uri;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpURI)) {
                return false;
            }
            return this.asString().equals(((HttpURI)o).asString());
        }

        @Override
        public String getAuthority() {
            if (this._port > 0) {
                return this._host + ":" + this._port;
            }
            return this._host;
        }

        @Override
        public String getDecodedPath() {
            if (this._decodedPath == null && this._path != null) {
                this._decodedPath = URIUtil.canonicalPath(URIUtil.decodePath(this._path));
            }
            return this._decodedPath;
        }

        @Override
        public String getFragment() {
            return this._fragment;
        }

        @Override
        public String getHost() {
            if (this._host != null && this._host.isEmpty()) {
                return null;
            }
            return this._host;
        }

        @Override
        public String getParam() {
            return this._param;
        }

        @Override
        public String getPath() {
            return this._path;
        }

        @Override
        public String getPathQuery() {
            if (this._query == null) {
                return this._path;
            }
            return this._path + "?" + this._query;
        }

        @Override
        public int getPort() {
            return this._port;
        }

        @Override
        public String getQuery() {
            return this._query;
        }

        @Override
        public String getScheme() {
            return this._scheme;
        }

        @Override
        public String getUser() {
            return this._user;
        }

        @Override
        public boolean hasAuthority() {
            return this._host != null;
        }

        public int hashCode() {
            return this.asString().hashCode();
        }

        @Override
        public boolean isAbsolute() {
            return !StringUtil.isEmpty(this._scheme);
        }

        @Override
        public boolean isAmbiguous() {
            return !this._ambiguous.isEmpty();
        }

        @Override
        public boolean hasAmbiguousSegment() {
            return this._ambiguous.contains((Object)Ambiguous.SEGMENT);
        }

        @Override
        public boolean hasAmbiguousSeparator() {
            return this._ambiguous.contains((Object)Ambiguous.SEPARATOR);
        }

        @Override
        public boolean hasAmbiguousParameter() {
            return this._ambiguous.contains((Object)Ambiguous.PARAM);
        }

        @Override
        public boolean hasAmbiguousEncoding() {
            return this._ambiguous.contains((Object)Ambiguous.ENCODING);
        }

        public String toString() {
            return this.asString();
        }

        @Override
        public URI toURI() {
            try {
                return new URI(this._scheme, null, this._host, this._port, this._path, this._query == null ? null : UrlEncoded.decodeString(this._query), this._fragment);
            }
            catch (URISyntaxException x) {
                throw new RuntimeException(x);
            }
        }
    }

    public static enum Ambiguous {
        SEGMENT,
        SEPARATOR,
        ENCODING,
        PARAM;

    }
}

