/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core;

import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;

public class WebSocketComponents
extends ContainerLifeCycle {
    private final DecoratedObjectFactory objectFactory;
    private final WebSocketExtensionRegistry extensionRegistry;
    private final ByteBufferPool bufferPool;
    private final InflaterPool inflaterPool;
    private final DeflaterPool deflaterPool;

    public WebSocketComponents() {
        this(null, null, null, null, null);
    }

    public WebSocketComponents(WebSocketExtensionRegistry extensionRegistry, DecoratedObjectFactory objectFactory, ByteBufferPool bufferPool, InflaterPool inflaterPool, DeflaterPool deflaterPool) {
        this.extensionRegistry = extensionRegistry == null ? new WebSocketExtensionRegistry() : extensionRegistry;
        this.objectFactory = objectFactory == null ? new DecoratedObjectFactory() : objectFactory;
        this.bufferPool = bufferPool == null ? new MappedByteBufferPool() : bufferPool;
        this.inflaterPool = inflaterPool == null ? new InflaterPool(1024, true) : inflaterPool;
        this.deflaterPool = deflaterPool == null ? new DeflaterPool(1024, -1, true) : deflaterPool;
        this.addBean(inflaterPool);
        this.addBean(deflaterPool);
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public WebSocketExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public InflaterPool getInflaterPool() {
        return this.inflaterPool;
    }

    public DeflaterPool getDeflaterPool() {
        return this.deflaterPool;
    }
}

