/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.util.UnclosableWriter;
import org.apache.taglibs.standard.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class TransformSupport
extends BodyTagSupport {
    protected Object xml;
    protected boolean xmlSpecified;
    protected String xmlSystemId;
    protected Object xslt;
    protected String xsltSystemId;
    protected Result result;
    private String var;
    private int scope;
    private Transformer t;
    private XmlUtil.JstlEntityResolver entityResolver;
    private XmlUtil.JstlUriResolver uriResolver;

    public TransformSupport() {
        this.init();
    }

    private void init() {
        this.xslt = null;
        this.xml = null;
        this.xmlSpecified = false;
        this.xsltSystemId = null;
        this.xmlSystemId = null;
        this.var = null;
        this.result = null;
        this.scope = 1;
    }

    public int doStartTag() throws JspException {
        Source source;
        block10: {
            if (this.xslt == null) {
                throw new JspTagException(Resources.getMessage("TRANSFORM_XSLT_IS_NULL"));
            }
            try {
                if (this.xslt instanceof Source) {
                    source = (Source)this.xslt;
                    break block10;
                }
                if (this.xslt instanceof String) {
                    String s = (String)this.xslt;
                    if ((s = s.trim()).length() == 0) {
                        throw new JspTagException(Resources.getMessage("TRANSFORM_XSLT_IS_EMPTY"));
                    }
                    source = XmlUtil.newSAXSource(new StringReader(s), this.xsltSystemId, this.entityResolver);
                    break block10;
                }
                if (this.xslt instanceof Reader) {
                    source = XmlUtil.newSAXSource((Reader)this.xslt, this.xsltSystemId, this.entityResolver);
                    break block10;
                }
                throw new JspTagException(Resources.getMessage("TRANSFORM_XSLT_UNSUPPORTED_TYPE", this.xslt.getClass()));
            }
            catch (SAXException e) {
                throw new JspException(e);
            }
            catch (ParserConfigurationException e) {
                throw new JspException(e);
            }
        }
        try {
            this.t = XmlUtil.newTransformer(source);
            this.t.setURIResolver(this.uriResolver);
        }
        catch (TransformerConfigurationException e) {
            throw new JspTagException(e);
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            Source source;
            Source source2 = source = this.xmlSpecified ? this.getSourceFromXmlAttribute() : this.getSourceFromBodyContent();
            if (this.var != null) {
                Document d = XmlUtil.newEmptyDocument();
                DOMResult doc = new DOMResult(d);
                this.t.transform(source, doc);
                this.pageContext.setAttribute(this.var, d, this.scope);
            } else {
                Result out = this.result;
                if (out == null) {
                    out = new StreamResult(new UnclosableWriter(this.pageContext.getOut()));
                }
                this.t.transform(source, out);
            }
            int n = 6;
            return n;
        }
        catch (TransformerException ex) {
            throw new JspException(ex);
        }
        catch (SAXException e) {
            throw new JspException(e);
        }
        catch (ParserConfigurationException e) {
            throw new JspException(e);
        }
        finally {
            this.t = null;
        }
    }

    public void release() {
        super.release();
        this.init();
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.uriResolver = pageContext == null ? null : new XmlUtil.JstlUriResolver(pageContext);
        this.entityResolver = pageContext == null ? null : new XmlUtil.JstlEntityResolver(pageContext);
    }

    public void addParameter(String name, Object value) {
        this.t.setParameter(name, value);
    }

    Source getSourceFromXmlAttribute() throws JspTagException, SAXException, ParserConfigurationException {
        Object xml = this.xml;
        if (xml == null) {
            throw new JspTagException(Resources.getMessage("TRANSFORM_XML_IS_NULL"));
        }
        if (xml instanceof List) {
            List list = (List)xml;
            if (list.size() != 1) {
                throw new JspTagException(Resources.getMessage("TRANSFORM_XML_LIST_SIZE"));
            }
            xml = list.get(0);
        }
        if (xml instanceof Source) {
            return (Source)xml;
        }
        if (xml instanceof String) {
            String s = (String)xml;
            if ((s = s.trim()).length() == 0) {
                throw new JspTagException(Resources.getMessage("TRANSFORM_XML_IS_EMPTY"));
            }
            return XmlUtil.newSAXSource(new StringReader(s), this.xmlSystemId, this.entityResolver);
        }
        if (xml instanceof Reader) {
            return XmlUtil.newSAXSource((Reader)xml, this.xmlSystemId, this.entityResolver);
        }
        if (xml instanceof Node) {
            return new DOMSource((Node)xml, this.xmlSystemId);
        }
        throw new JspTagException(Resources.getMessage("TRANSFORM_XML_UNSUPPORTED_TYPE", xml.getClass()));
    }

    Source getSourceFromBodyContent() throws JspTagException, SAXException, ParserConfigurationException {
        if (this.bodyContent == null) {
            throw new JspTagException(Resources.getMessage("TRANSFORM_BODY_IS_NULL"));
        }
        String s = this.bodyContent.getString();
        if (s == null) {
            throw new JspTagException(Resources.getMessage("TRANSFORM_BODY_CONTENT_IS_NULL"));
        }
        if ((s = s.trim()).length() == 0) {
            throw new JspTagException(Resources.getMessage("TRANSFORM_BODY_IS_EMPTY"));
        }
        return XmlUtil.newSAXSource(new StringReader(s), this.xmlSystemId, this.entityResolver);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }
}

