/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.config;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import java.util.Set;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.listener.ContainerInitializer;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.websocket.util.server.WebSocketUpgradeFilter;
import org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebSocketServletContainerInitializer.class);

    public static void configure(ServletContextHandler context, Configurator configurator) {
        context.addEventListener(ContainerInitializer.asContextListener(new JettyWebSocketServletContainerInitializer()).afterStartup(servletContext -> {
            if (configurator != null) {
                JettyWebSocketServerContainer container = JettyWebSocketServerContainer.getContainer(servletContext);
                configurator.accept((ServletContext)servletContext, container);
            }
        }));
    }

    private static JettyWebSocketServerContainer initialize(ServletContextHandler context) {
        WebSocketComponents components = WebSocketServerComponents.ensureWebSocketComponents(context.getServletContext());
        FilterHolder filterHolder = WebSocketUpgradeFilter.ensureFilter(context.getServletContext());
        WebSocketMapping mapping = WebSocketMapping.ensureMapping(context.getServletContext(), "org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping");
        JettyWebSocketServerContainer container = JettyWebSocketServerContainer.ensureContainer(context.getServletContext());
        if (LOG.isDebugEnabled()) {
            LOG.debug("configureContext {} {} {} {}", container, mapping, filterHolder, components);
        }
        return container;
    }

    @Override
    public void onStartup(Set<Class<?>> c, ServletContext context) {
        ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler(context, "Jetty WebSocket SCI");
        JettyWebSocketServletContainerInitializer.initialize(contextHandler);
    }

    public static interface Configurator {
        public void accept(ServletContext var1, JettyWebSocketServerContainer var2);
    }
}

