/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi.java;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.eclipse.jetty.jndi.java.javaRootURLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class javaURLContextFactory
implements ObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(javaURLContextFactory.class);

    public Object getObjectInstance(Object url, Name name, Context ctx, Hashtable env) throws Exception {
        if (url == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(">>> new root context requested ");
            }
            return new javaRootURLContext(env);
        }
        if (url instanceof String) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(">>> resolution of url " + url + " requested");
            }
            javaRootURLContext rootctx = new javaRootURLContext(env);
            return rootctx.lookup((String)url);
        }
        if (url instanceof String[]) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(">>> resolution of array of urls requested");
            }
            String[] urls = (String[])url;
            javaRootURLContext rootctx = new javaRootURLContext(env);
            Object object = null;
            NamingException e = null;
            for (int i2 = 0; i2 < urls.length && object == null; ++i2) {
                try {
                    object = rootctx.lookup(urls[i2]);
                    continue;
                }
                catch (NamingException x) {
                    e = x;
                }
            }
            if (object == null) {
                throw e;
            }
            return object;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>> No idea what to do, so return a new root context anyway");
        }
        return new javaRootURLContext(env);
    }
}

